/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.VaultRarity;
import iskallia.vault.world.vault.chest.ExplosionEffect;
import iskallia.vault.world.vault.chest.MobTrapEffect;
import iskallia.vault.world.vault.chest.PotionCloudEffect;
import iskallia.vault.world.vault.chest.VaultChestEffect;
import iskallia.vault.world.vault.logic.VaultSpawner;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Explosion;

public class VaultChestConfig
extends Config {
    @Expose
    public Map<VaultRarity, Double> RARITY_DISTRIBUTION = new LinkedHashMap<VaultRarity, Double>();
    @Expose
    public List<MobTrapEffect> MOB_TRAP_EFFECTS;
    @Expose
    public List<ExplosionEffect> EXPLOSION_EFFECTS;
    @Expose
    public List<PotionCloudEffect> POTION_CLOUD_EFFECTS;
    @Expose
    public LevelEntryList<Level> LEVELS;
    private final String name;

    public VaultChestConfig(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<VaultChestEffect> getAll() {
        return Stream.of(this.MOB_TRAP_EFFECTS, this.EXPLOSION_EFFECTS, this.POTION_CLOUD_EFFECTS).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public VaultChestEffect getByName(String name) {
        return this.getAll().stream().filter(group -> group.getName().equals(name)).findFirst().orElse(null);
    }

    public VaultRarity getRarity(double cdf) {
        Map.Entry<VaultRarity, Double> result = null;
        for (Map.Entry<VaultRarity, Double> entry : this.RARITY_DISTRIBUTION.entrySet()) {
            if (result == null) {
                result = entry;
                continue;
            }
            if (!(cdf < entry.getValue())) continue;
            result = entry;
        }
        return result == null ? null : (VaultRarity)((Object)result.getKey());
    }

    @Override
    protected void reset() {
        this.RARITY_DISTRIBUTION.put(VaultRarity.OMEGA, 0.05);
        this.RARITY_DISTRIBUTION.put(VaultRarity.EPIC, 0.2);
        this.RARITY_DISTRIBUTION.put(VaultRarity.RARE, 0.4);
        this.RARITY_DISTRIBUTION.put(VaultRarity.COMMON, 1.0);
        this.LEVELS = new LevelEntryList();
        this.MOB_TRAP_EFFECTS = Arrays.asList(new MobTrapEffect("Mob Trap", 5, new VaultSpawner.Config().withExtraMaxMobs(15).withMinDistance(1.0).withMaxDistance(12.0).withDespawnDistance(32.0)));
        this.EXPLOSION_EFFECTS = Arrays.asList(new ExplosionEffect("Explosion", 4.0f, 0.0, 3.0, 0.0, true, 10.0f, Explosion.BlockInteraction.BREAK));
        this.POTION_CLOUD_EFFECTS = Arrays.asList(new PotionCloudEffect("Poison", Potions.f_43586_));
        Level level = new Level(5);
        level.probability = 0.1;
        level.pool.add("Explosion", 4);
        level.pool.add("Mob Trap", 4);
        level.pool.add("Poison", 4);
        this.LEVELS.add(level);
    }

    @Nullable
    public double getTrapProbability(int level) {
        return this.getForLevel((int)level).probability;
    }

    @Nullable
    public WeightedList<String> getEffectPool(int level) {
        return this.getForLevel((int)level).pool;
    }

    @Nullable
    public VaultChestEffect getEffectByName(String effect) {
        return ModConfigs.VAULT_CHEST.getByName(effect);
    }

    public Level getForLevel(int level) {
        return this.LEVELS.getForLevel(level).orElse(Level.EMPTY);
    }

    public static class Level
    implements LevelEntryList.ILevelEntry {
        public static Level EMPTY = new Level(0);
        @Expose
        public int level;
        @Expose
        public double probability;
        @Expose
        public WeightedList<String> pool = new WeightedList();

        public Level(int level) {
            this.level = level;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

