/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TrinketConfig
extends Config {
    @Expose
    public TrinketMap TRINKETS = new TrinketMap();

    @Override
    public String getName() {
        return "trinket";
    }

    @Nullable
    public Trinket getTrinketConfig(TrinketEffect<?> trinketEffect) {
        return this.getTrinketConfig(trinketEffect.getRegistryName());
    }

    @Nullable
    private Trinket getTrinketConfig(ResourceLocation key) {
        return (Trinket)this.TRINKETS.get(key);
    }

    @Nullable
    public TrinketEffect<?> getRandomTrinketSet() {
        WeightedList list = new WeightedList();
        this.TRINKETS.forEach((key, config) -> {
            TrinketEffect<?> trinketEffect = TrinketEffectRegistry.getEffect(key);
            if (trinketEffect != null) {
                list.add(trinketEffect, config.getWeight());
            }
        });
        return list.getRandom().orElse(null);
    }

    @Override
    protected void reset() {
        this.TRINKETS.clear();
        for (TrinketEffect<?> effect : TrinketEffectRegistry.getOrderedEntries()) {
            Trinket trinket = new Trinket(100, effect.getRegistryName().m_135815_(), "Trinket Text", 6084886);
            trinket.trinketConfig = effect.getDefaultConfig();
            this.TRINKETS.put(effect.getRegistryName(), trinket);
        }
    }

    public static class TrinketMap
    extends LinkedHashMap<ResourceLocation, Trinket> {

        public static class Serializer
        implements JsonSerializer<TrinketMap>,
        JsonDeserializer<TrinketMap> {
            public TrinketMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                TrinketMap trinketMap = new TrinketMap();
                JsonObject map = json.getAsJsonObject();
                for (String trinketKeyStr : map.keySet()) {
                    ResourceLocation trinketKey = new ResourceLocation(trinketKeyStr);
                    TrinketEffect<?> trinketEffect = TrinketEffectRegistry.getEffect(trinketKey);
                    if (trinketEffect == null) continue;
                    JsonObject trinketConfigObject = map.getAsJsonObject(trinketKeyStr);
                    Trinket trinketConfig = (Trinket)context.deserialize((JsonElement)trinketConfigObject, Trinket.class);
                    trinketConfig.trinketConfig = context.deserialize(trinketConfigObject.get("config"), trinketEffect.getConfigClass());
                    trinketMap.put(trinketKey, trinketConfig);
                }
                return trinketMap;
            }

            public JsonElement serialize(TrinketMap src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject map = new JsonObject();
                src.forEach((trinketKey, trinketConfig) -> {
                    TrinketEffect<?> trinketEffect = TrinketEffectRegistry.getEffect(trinketKey);
                    if (trinketEffect == null) {
                        return;
                    }
                    JsonObject trinketConfigObject = context.serialize(trinketConfig).getAsJsonObject();
                    trinketConfigObject.add("config", context.serialize(trinketConfig.trinketConfig, trinketEffect.getConfigClass()));
                    map.add(trinketKey.toString(), (JsonElement)trinketConfigObject);
                });
                return map;
            }
        }
    }

    public static class Trinket {
        @Expose
        private int weight;
        @Expose
        private String name;
        @Expose
        private String effectText;
        @Expose
        private int color;
        @Expose
        private int minUses;
        @Expose
        private int maxUses;
        private Object trinketConfig;

        public Trinket(int weight, String name, String effectText, int color) {
            this(weight, name, effectText, color, 6, 9);
        }

        public Trinket(int weight, String name, String effectText, int color, int minUses, int maxUses) {
            this.weight = weight;
            this.name = name;
            this.effectText = effectText;
            this.color = color;
            this.minUses = minUses;
            this.maxUses = maxUses;
        }

        public int getWeight() {
            return this.weight;
        }

        public String getName() {
            return this.name;
        }

        public String getEffectText() {
            return this.effectText;
        }

        public int getColor() {
            return this.color;
        }

        public TextColor getComponentColor() {
            return TextColor.m_131266_((int)this.getColor());
        }

        public int getRandomUses() {
            return Mth.m_144928_((Random)Config.rand, (int)this.minUses, (int)this.maxUses);
        }

        public Object getConfig() {
            return this.trinketConfig;
        }
    }
}

