/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.talent.Talent;
import iskallia.vault.skill.talent.TalentGroup;
import iskallia.vault.skill.talent.type.AngelTalent;
import iskallia.vault.skill.talent.type.AttributeTalent;
import iskallia.vault.skill.talent.type.BarteringTalent;
import iskallia.vault.skill.talent.type.BlacksmithTalent;
import iskallia.vault.skill.talent.type.ConditionalDamageTalent;
import iskallia.vault.skill.talent.type.EffectTalent;
import iskallia.vault.skill.talent.type.ExperiencedTalent;
import iskallia.vault.skill.talent.type.LowHealthDamageTalent;
import iskallia.vault.skill.talent.type.LowHealthResistanceTalent;
import iskallia.vault.skill.talent.type.LuckyAltarTalent;
import iskallia.vault.skill.talent.type.VanillaAttributeTalent;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;

public class TalentsConfig
extends Config {
    @Expose
    public TalentGroup<EffectTalent> HASTE;
    @Expose
    public TalentGroup<EffectTalent> STRENGTH;
    @Expose
    public TalentGroup<EffectTalent> SPEED;
    @Expose
    public TalentGroup<VanillaAttributeTalent> REACH;
    @Expose
    public TalentGroup<VanillaAttributeTalent> STONE_SKIN;
    @Expose
    public TalentGroup<AttributeTalent> UNBREAKABLE;
    @Expose
    public TalentGroup<AttributeTalent> CRITICAL_STRIKE;
    @Expose
    public TalentGroup<AttributeTalent> FATAL_STRIKE_CHANCE;
    @Expose
    public TalentGroup<AttributeTalent> FATAL_STRIKE_DAMAGE;
    @Expose
    public TalentGroup<AttributeTalent> THORNS_CHANCE;
    @Expose
    public TalentGroup<AttributeTalent> THORNS_DAMAGE;
    @Expose
    public TalentGroup<AttributeTalent> DAMAGE_UNDEAD;
    @Expose
    public TalentGroup<AttributeTalent> DAMAGE_SPIDERS;
    @Expose
    public TalentGroup<AttributeTalent> DAMAGE_ILLAGERS;
    @Expose
    public TalentGroup<AngelTalent> ANGEL;
    @Expose
    public TalentGroup<ExperiencedTalent> EXPERIENCED;
    @Expose
    public TalentGroup<LuckyAltarTalent> LUCKY_ALTAR;
    @Expose
    public TalentGroup<ConditionalDamageTalent> WEAKNESS_AFFINITY;
    @Expose
    public TalentGroup<ConditionalDamageTalent> WITHER_AFFINITY;
    @Expose
    public TalentGroup<ConditionalDamageTalent> SLOWNESS_AFFINITY;
    @Expose
    public TalentGroup<BarteringTalent> BARTERING;
    @Expose
    public TalentGroup<BlacksmithTalent> BLACKSMITH;
    @Expose
    public TalentGroup<LowHealthResistanceTalent> LAST_STAND;
    @Expose
    public TalentGroup<LowHealthDamageTalent> BERSERKING;

    @Override
    public String getName() {
        return "talents";
    }

    public List<TalentGroup<?>> getAll() {
        return Arrays.asList(this.HASTE, this.STRENGTH, this.SPEED, this.REACH, this.STONE_SKIN, this.UNBREAKABLE, this.CRITICAL_STRIKE, this.FATAL_STRIKE_CHANCE, this.FATAL_STRIKE_DAMAGE, this.THORNS_CHANCE, this.THORNS_DAMAGE, this.DAMAGE_SPIDERS, this.DAMAGE_UNDEAD, this.DAMAGE_ILLAGERS, this.ANGEL, this.EXPERIENCED, this.LUCKY_ALTAR, this.WEAKNESS_AFFINITY, this.WITHER_AFFINITY, this.SLOWNESS_AFFINITY, this.BARTERING, this.BLACKSMITH, this.LAST_STAND, this.BERSERKING);
    }

    public TalentGroup<?> getByName(String name) {
        return this.getAll().stream().filter(group -> group.getParentName().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("Unknown talent with name " + name));
    }

    public Optional<TalentGroup<?>> getTalent(String name) {
        return this.getAll().stream().filter(group -> group.getParentName().equals(name)).findFirst();
    }

    @Override
    protected void reset() {
        this.HASTE = TalentGroup.ofEffect("Haste", MobEffects.f_19598_, 3);
        this.STRENGTH = TalentGroup.ofEffect("Strength", MobEffects.f_19600_, 2);
        this.SPEED = TalentGroup.ofEffect("Speed", MobEffects.f_19596_, 2);
        this.REACH = TalentGroup.ofAttribute("Reach", (Attribute)ForgeMod.REACH_DISTANCE.get(), AttributeModifier.Operation.ADDITION, 3, i -> (double)i * 1.0);
        this.STONE_SKIN = TalentGroup.ofAttribute("Stone Skin", Attributes.f_22278_, AttributeModifier.Operation.ADDITION, 5, i -> (float)i * 0.2f);
        this.UNBREAKABLE = TalentGroup.ofGearAttribute("Unbreakable", ModGearAttributes.DURABILITY_WEAR_REDUCTION, 5, i -> (float)i * 0.07f);
        this.CRITICAL_STRIKE = TalentGroup.ofGearAttribute("Critical Strike", ModGearAttributes.VANILLA_CRITICAL_HIT_CHANCE, 4, i -> (float)i * 0.25f);
        this.THORNS_CHANCE = TalentGroup.ofGearAttribute("Thorns Chance", ModGearAttributes.THORNS_CHANCE, 5, i -> (float)i * 0.05f);
        this.THORNS_DAMAGE = TalentGroup.ofGearAttribute("Thorns Damage", ModGearAttributes.THORNS_DAMAGE, 5, i -> (float)i * 0.15f);
        this.FATAL_STRIKE_CHANCE = TalentGroup.ofGearAttribute("Fatal Strike Chance", ModGearAttributes.FATAL_STRIKE_CHANCE, 5, i -> (float)i * 0.05f);
        this.FATAL_STRIKE_DAMAGE = TalentGroup.ofGearAttribute("Fatal Strike Damage", ModGearAttributes.FATAL_STRIKE_DAMAGE, 5, i -> (float)i * 0.2f);
        this.DAMAGE_UNDEAD = TalentGroup.ofGearAttribute("Arthropod Mastery", ModGearAttributes.DAMAGE_UNDEAD, 5, i -> (float)i * 0.1f);
        this.DAMAGE_SPIDERS = TalentGroup.ofGearAttribute("Undead Mastery", ModGearAttributes.DAMAGE_SPIDERS, 5, i -> (float)i * 0.1f);
        this.DAMAGE_ILLAGERS = TalentGroup.ofGearAttribute("Illager Mastery", ModGearAttributes.DAMAGE_ILLAGERS, 5, i -> (float)i * 0.1f);
        this.ANGEL = new TalentGroup("Angel", (Talent[])new AngelTalent[]{new AngelTalent(100)});
        this.EXPERIENCED = new TalentGroup("Experienced", (Talent[])new ExperiencedTalent[]{new ExperiencedTalent(1, 0.5f), new ExperiencedTalent(1, 1.0f), new ExperiencedTalent(1, 1.5f), new ExperiencedTalent(1, 2.0f), new ExperiencedTalent(1, 3.0f), new ExperiencedTalent(2, 4.0f), new ExperiencedTalent(2, 5.0f), new ExperiencedTalent(3, 7.5f), new ExperiencedTalent(3, 10.0f), new ExperiencedTalent(8, 20.0f)});
        this.LUCKY_ALTAR = new TalentGroup("Lucky Altar", (Talent[])new LuckyAltarTalent[]{new LuckyAltarTalent(3, 0.1f), new LuckyAltarTalent(3, 0.15f), new LuckyAltarTalent(3, 0.2f), new LuckyAltarTalent(6, 0.25f), new LuckyAltarTalent(8, 0.3f)});
        this.WEAKNESS_AFFINITY = new TalentGroup("Weakness Affinity", (Talent[])new ConditionalDamageTalent[]{new ConditionalDamageTalent(1, MobEffects.f_19613_, 0.1), new ConditionalDamageTalent(2, MobEffects.f_19613_, 0.2), new ConditionalDamageTalent(3, MobEffects.f_19613_, 0.3)});
        this.WITHER_AFFINITY = new TalentGroup("Wither Affinity", (Talent[])new ConditionalDamageTalent[]{new ConditionalDamageTalent(1, MobEffects.f_19615_, 0.1), new ConditionalDamageTalent(2, MobEffects.f_19615_, 0.2), new ConditionalDamageTalent(3, MobEffects.f_19615_, 0.3)});
        this.SLOWNESS_AFFINITY = new TalentGroup("Slowness Affinity", (Talent[])new ConditionalDamageTalent[]{new ConditionalDamageTalent(1, MobEffects.f_19597_, 0.1), new ConditionalDamageTalent(2, MobEffects.f_19597_, 0.2), new ConditionalDamageTalent(3, MobEffects.f_19597_, 0.3)});
        this.BARTERING = new TalentGroup("Bartering", (Talent[])new BarteringTalent[]{new BarteringTalent(1, 0.1f), new BarteringTalent(2, 0.2f), new BarteringTalent(3, 0.3f)});
        this.BLACKSMITH = new TalentGroup("Blacksmith", (Talent[])new BlacksmithTalent[]{new BlacksmithTalent(1, 0.1f), new BlacksmithTalent(2, 0.2f), new BlacksmithTalent(3, 0.3f)});
        this.LAST_STAND = new TalentGroup("Last Stand", (Talent[])new LowHealthResistanceTalent[]{new LowHealthResistanceTalent(1, 0.2f, 0.05f), new LowHealthResistanceTalent(2, 0.2f, 0.1f), new LowHealthResistanceTalent(3, 0.2f, 0.15f)});
        this.BERSERKING = new TalentGroup("Berserking", (Talent[])new LowHealthDamageTalent[]{new LowHealthDamageTalent(1, 0.2f, 0.15f), new LowHealthDamageTalent(2, 0.2f, 0.25f), new LowHealthDamageTalent(3, 0.2f, 0.5f)});
    }
}

