/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class SummonAndKillAllBossesConfig
extends Config {
    @Expose
    public LevelEntryList<Level> LEVELS;

    @Override
    public String getName() {
        return "summon_and_kill_all_bosses";
    }

    @Override
    protected void reset() {
        this.LEVELS = new LevelEntryList();
        Level level = new Level(5);
        level.POOLS.addAll(Arrays.asList(new Pool(2, 2).add(VaultMod.id("mobs"), 1).add(VaultMod.id("frail"), 1).add(VaultMod.id("rushed"), 1).add(VaultMod.id("difficult"), 1).add(VaultMod.id("extended"), 1).add(VaultMod.id("rotten"), 1).add(VaultMod.id("treasure_hunter"), 1), new Pool(1, 1).add(VaultMod.id("default"), 1).add(VaultMod.id("dummy"), 3)));
        this.LEVELS.add(level);
    }

    public Set<VaultModifier<?>> getRandom(Random random, int level) {
        Optional<Level> override = this.LEVELS.getForLevel(level);
        if (override.isEmpty()) {
            return new HashSet();
        }
        List<Pool> pools = override.get().POOLS;
        if (pools == null) {
            return new HashSet();
        }
        HashSet modifiers = new HashSet();
        pools.stream().map(pool -> pool.getRandom(random)).forEach(modifiers::addAll);
        return modifiers;
    }

    public Level getForLevel(int level) {
        for (int i = 0; i < this.LEVELS.size(); ++i) {
            if (level < ((Level)this.LEVELS.get((int)i)).MIN_LEVEL) {
                if (i == 0) break;
                return (Level)this.LEVELS.get(i - 1);
            }
            if (i != this.LEVELS.size() - 1) continue;
            return (Level)this.LEVELS.get(i);
        }
        return Level.EMPTY;
    }

    public static class Level
    implements LevelEntryList.ILevelEntry {
        public static Level EMPTY = new Level(0);
        @Expose
        public int MIN_LEVEL;
        @Expose
        public List<Pool> POOLS;

        public Level(int minLevel) {
            this.MIN_LEVEL = minLevel;
            this.POOLS = new ArrayList<Pool>();
        }

        @Override
        public int getLevel() {
            return this.MIN_LEVEL;
        }
    }

    public static class Pool {
        @Expose
        public int MIN_ROLLS;
        @Expose
        public int MAX_ROLLS;
        @Expose
        public WeightedList<ResourceLocation> POOL;

        public Pool(int min, int max) {
            this.MIN_ROLLS = min;
            this.MAX_ROLLS = max;
            this.POOL = new WeightedList();
        }

        public Pool add(ResourceLocation modifierId, int weight) {
            this.POOL.add(modifierId, weight);
            return this;
        }

        public Set<VaultModifier<?>> getRandom(Random random) {
            int rolls = Math.min(this.MIN_ROLLS, this.MAX_ROLLS) + random.nextInt(Math.abs(this.MIN_ROLLS - this.MAX_ROLLS) + 1);
            HashSet<ResourceLocation> res = new HashSet<ResourceLocation>();
            while (res.size() < rolls && res.size() < this.POOL.size()) {
                res.add(this.POOL.getRandom(random));
            }
            return res.stream().map(VaultModifierRegistry::getOpt).flatMap(Optional::stream).collect(Collectors.toSet());
        }
    }
}

