/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.ItemEntry;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ShardGlobalTradeMessage;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.util.data.WeightedList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SoulShardConfig
extends Config {
    @Expose
    private int shardTradePrice;
    @Expose
    private final WeightedList<ShardTrade> shardTrades = new WeightedList();
    @Expose
    private DropRange defaultShardDrops;
    @Expose
    private final Map<String, DropRange> shardDrops = new HashMap<String, DropRange>();

    @Override
    public String getName() {
        return "soul_shard";
    }

    @Override
    protected void reset() {
        this.shardTradePrice = 1000;
        this.shardTrades.clear();
        this.shardTrades.add(new ShardTrade(new ItemEntry((ItemLike)ModItems.SKILL_ESSENCE, 1), 1500, 2500), 1);
        this.shardTrades.add(new ShardTrade(new ItemEntry((ItemLike)ModItems.KNOWLEDGE_STAR_ESSENCE, 1), 900, 1200), 1);
        this.defaultShardDrops = new DropRange(1, 1, 1.0f);
        this.shardDrops.clear();
        this.shardDrops.put(EntityType.f_20501_.getRegistryName().toString(), new DropRange(1, 1, 0.5f));
    }

    public int getShardTradePrice() {
        return this.shardTradePrice;
    }

    public ShardTrade getRandomTrade() {
        return this.shardTrades.getRandom(rand);
    }

    public int getRandomShards(EntityType<?> type, float chanceMultiplier) {
        DropRange range = this.shardDrops.get(type.getRegistryName().toString());
        if (range == null) {
            return this.defaultShardDrops.getRandomAmount(chanceMultiplier);
        }
        return range.getRandomAmount(chanceMultiplier);
    }

    public WeightedList<ShardTrade> getShardTrades() {
        return this.shardTrades;
    }

    @Override
    public <T extends Config> T readConfig() {
        Object cfg = super.readConfig();
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv != null) {
            srv.m_6846_().m_11314_().forEach(player -> this.syncTo((SoulShardConfig)cfg, (ServerPlayer)player));
        }
        return cfg;
    }

    public void syncTo(SoulShardConfig cfg, ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)new ShardGlobalTradeMessage(cfg.getShardTrades()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static class ShardTrade {
        @Expose
        private final ItemEntry item;
        @Expose
        private final int minPrice;
        @Expose
        private final int maxPrice;

        public ShardTrade(ItemEntry item, int minPrice, int maxPrice) {
            this.item = item;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
        }

        public ItemStack getItem() {
            return this.item.createItemStack();
        }

        public ItemEntry getItemEntry() {
            return this.item;
        }

        public int getMinPrice() {
            return this.minPrice;
        }

        public int getMaxPrice() {
            return this.maxPrice;
        }
    }

    public static class DropRange {
        @Expose
        private final int min;
        @Expose
        private final int max;
        @Expose
        private final float chance;

        public DropRange(int min, int max, float chance) {
            this.min = min;
            this.max = max;
            this.chance = chance;
        }

        public int getRandomAmount(float chanceMultiplier) {
            if (Config.rand.nextFloat() > this.chance * chanceMultiplier) {
                return 0;
            }
            return MathUtilities.getRandomInt(this.min, this.max + 1);
        }
    }
}

