/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.data.WeightedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ShopPedestalConfig
extends Config {
    @Expose
    public LevelEntryList<ShopTier> LEVELS;
    public static final ShopOffer EMPTY = new ShopOffer(ItemStack.f_41583_, ItemStack.f_41583_);

    @Override
    public String getName() {
        return "shop_pedestal";
    }

    public ShopOffer getForLevel(int vaultLevel, Random random) {
        return this.LEVELS.getForLevel(vaultLevel).map(shopTier -> shopTier.TRADE_POOL).filter(entries -> !entries.isEmpty()).map(entries -> (ShopEntry)entries.getRandom(random)).map(shopEntry -> shopEntry.roll(random)).orElse(EMPTY);
    }

    @Override
    protected boolean isValid() {
        if (this.LEVELS == null || this.LEVELS.size() == 0) {
            VaultMod.LOGGER.error("Pedestal loot list cannot be empty");
            return false;
        }
        for (ShopTier v : this.LEVELS) {
            if (v.TRADE_POOL == null || v.TRADE_POOL.isEmpty()) {
                VaultMod.LOGGER.error("Pedestal loot pool for level {} cannot be empty", (Object)v.MIN_LEVEL);
                return false;
            }
            for (WeightedList.Entry entry : v.TRADE_POOL) {
                if (entry.value == null || ((ShopEntry)entry.value).CURRENCY == null || ((ShopEntry)entry.value).OFFER == null) {
                    VaultMod.LOGGER.error("Pedestal loot entry cannot be empty");
                    return false;
                }
                if (((ShopEntry)entry.value).MIN_COST <= ((ShopEntry)entry.value).MAX_COST) continue;
                VaultMod.LOGGER.error("Pedestal entry min cost cannot be larger than max cost");
                return false;
            }
        }
        return true;
    }

    @Override
    protected void reset() {
        this.LEVELS = LevelEntryList.of((LevelEntryList.ILevelEntry[])new ShopTier[]{new ShopTier(0, new WeightedList<ShopEntry>(Map.of(new ShopEntry(Items.f_42064_.m_7968_(), (Item)ModBlocks.VAULT_BRONZE, 1, 2), 1)))});
    }

    public record ShopOffer(ItemStack offer, ItemStack currency) {
        public static ShopOffer load(CompoundTag tag) {
            ItemStack i = ItemStack.m_41712_((CompoundTag)tag.m_128469_("offer"));
            ItemStack c = ItemStack.m_41712_((CompoundTag)tag.m_128469_("currency"));
            return ShopOffer.of(i, c);
        }

        public static ShopOffer of(ItemStack offer, ItemStack currency) {
            if (offer.m_41619_() || currency.m_41619_()) {
                return EMPTY;
            }
            return new ShopOffer(offer, currency);
        }

        public void save(CompoundTag tag) {
            tag.m_128365_("offer", (Tag)this.offer.m_41739_(new CompoundTag()));
            tag.m_128365_("currency", (Tag)this.currency.m_41739_(new CompoundTag()));
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }
    }

    private static final class ShopTier
    implements LevelEntryList.ILevelEntry {
        @Expose
        private int MIN_LEVEL;
        @Expose
        private WeightedList<ShopEntry> TRADE_POOL;

        private ShopTier(int MIN_LEVEL, WeightedList<ShopEntry> TRADE_POOL) {
            this.MIN_LEVEL = MIN_LEVEL;
            this.TRADE_POOL = TRADE_POOL;
        }

        @Override
        public int getLevel() {
            return this.MIN_LEVEL;
        }
    }

    private static final class ShopEntry {
        @Expose
        private ItemStack OFFER;
        @Expose
        private Item CURRENCY;
        @Expose
        private int MIN_COST;
        @Expose
        private int MAX_COST;

        private ShopEntry(ItemStack OFFER, Item CURRENCY, int MIN_COST, int MAX_COST) {
            this.OFFER = OFFER;
            this.CURRENCY = CURRENCY;
            this.MIN_COST = MIN_COST;
            this.MAX_COST = MAX_COST;
        }

        public ShopOffer roll(Random random) {
            return ShopOffer.of(this.OFFER, new ItemStack((ItemLike)this.CURRENCY, Mth.m_144928_((Random)random, (int)this.MIN_COST, (int)this.MAX_COST)));
        }
    }
}

