/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.objective.scavenger.ChestScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.CoinStacksScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.MobScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.world.loot.LootRoll;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;

public class ScavengerConfig
extends Config {
    @Expose
    private List<ScavengeTask> tasks;
    @Expose
    private LevelEntryList<Entry> levels;

    @Override
    public String getName() {
        return "scavenger";
    }

    public List<ScavengeTask> getTasks() {
        return this.tasks;
    }

    public List<ScavengerGoal> generateGoals(int level, RandomSource random) {
        ArrayList<ScavengerGoal> result = new ArrayList<ScavengerGoal>();
        ArrayList<ScavengeTask> tasks = new ArrayList<ScavengeTask>(this.tasks);
        Entry entry = this.levels.getForLevel(level).orElse(null);
        if (entry == null) {
            return result;
        }
        int rolls = entry.goalCount.get(random);
        for (int i = 0; i < rolls && !tasks.isEmpty(); ++i) {
            int n = random.nextInt(tasks.size());
            ScavengeTask task = (ScavengeTask)tasks.get(n);
            task.generateGoal(entry.itemCount.get(random), random).ifPresent(goal -> {
                result.add((ScavengerGoal)goal);
                tasks.remove(n);
            });
        }
        return result;
    }

    @Override
    protected void reset() {
        this.tasks = new ArrayList<ScavengeTask>();
        this.levels = new LevelEntryList();
        this.tasks.add(new ChestScavengeTask("the_vault:wooden_chest", 0.5, 1.0, VaultMod.id("gui/scav/wooden_chest"), new WeightedList<ChestScavengeTask.Entry>().add(new ChestScavengeTask.Entry(Items.f_41873_, 0xFFFFFF), 8).add(new ChestScavengeTask.Entry(Items.f_41874_, 0xFFFFFF), 4).add(new ChestScavengeTask.Entry(Items.f_41933_, 0xFFFFFF), 2).add(new ChestScavengeTask.Entry(Items.f_41875_, 0xFFFFFF), 1)));
        this.tasks.add(new CoinStacksScavengeTask(0.5, 1.0, VaultMod.id("gui/scav/wooden_chest"), new WeightedList<CoinStacksScavengeTask.Entry>().add(new CoinStacksScavengeTask.Entry(Items.f_41873_, 0xFFFFFF), 8).add(new CoinStacksScavengeTask.Entry(Items.f_41874_, 0xFFFFFF), 4).add(new CoinStacksScavengeTask.Entry(Items.f_41933_, 0xFFFFFF), 2).add(new CoinStacksScavengeTask.Entry(Items.f_41875_, 0xFFFFFF), 1)));
        this.tasks.add(new MobScavengeTask(0.5, 1.0, VaultMod.id("gui/scav/wooden_chest"), 0xFFFFFF, new MobScavengeTask.Entry(Items.f_42436_, EntityType.f_20501_, EntityType.f_20558_, EntityType.f_20479_)));
        this.levels.add(new Entry(0, LootRoll.ofUniform(2, 6), LootRoll.ofUniform(4, 10)));
    }

    private static class Entry
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private LootRoll goalCount;
        @Expose
        private LootRoll itemCount;

        public Entry(int level, LootRoll goalCount, LootRoll itemCount) {
            this.level = level;
            this.goalCount = goalCount;
            this.itemCount = itemCount;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

