/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.util.data.WeightedList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityType;

public class RaidConfig
extends Config {
    private static final Level DEFAULT = new Level(0, new MobPool());
    @Expose
    private final Map<String, LevelEntryList<Level>> mobPools = new HashMap<String, LevelEntryList<Level>>();
    @Expose
    private final WeightedList<WaveSetup> raidWaves = new WeightedList();
    @Expose
    private final List<AmountLevel> amountLevels = new ArrayList<AmountLevel>();

    @Nullable
    public MobPool getPool(String pool, int level) {
        LevelEntryList<Level> mobLevelPool = this.mobPools.get(pool);
        if (mobLevelPool == null) {
            return null;
        }
        return mobLevelPool.getForLevel((int)level).orElse((Level)RaidConfig.DEFAULT).mobPool;
    }

    public float getMobCountMultiplier(int level) {
        return this.getAmountLevel(this.amountLevels, level).map(AmountLevel::getMobAmountMultiplier).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Nullable
    public WaveSetup getRandomWaveSetup() {
        return this.raidWaves.getRandom(rand);
    }

    @Override
    public String getName() {
        return "raid";
    }

    @Override
    protected void reset() {
        this.mobPools.clear();
        this.raidWaves.clear();
        this.mobPools.put("ranged", LevelEntryList.of((LevelEntryList.ILevelEntry[])new Level[]{new Level(0, new MobPool().add(EntityType.f_20524_, 1)), new Level(75, new MobPool().add(EntityType.f_20524_, 1).add(EntityType.f_20481_, 1))}));
        this.mobPools.put("melee", LevelEntryList.of((LevelEntryList.ILevelEntry[])new Level[]{new Level(0, new MobPool().add(EntityType.f_20501_, 1)), new Level(50, new MobPool().add(EntityType.f_20501_, 2).add(EntityType.f_20493_, 1))}));
        WaveSetup waveSetup = new WaveSetup().addWave(new CompoundWave(new ConfiguredWave(2, 3, "ranged"), new ConfiguredWave(2, 3, "melee"))).addWave(new CompoundWave(new ConfiguredWave(4, 5, "ranged"), new ConfiguredWave(4, 6, "melee"))).addWave(new CompoundWave(new ConfiguredWave(6, 7, "ranged"), new ConfiguredWave(5, 8, "melee")));
        this.raidWaves.add(waveSetup, 1);
        this.amountLevels.clear();
        this.amountLevels.add(new AmountLevel(0, 1.0f));
        this.amountLevels.add(new AmountLevel(50, 1.5f));
        this.amountLevels.add(new AmountLevel(100, 2.0f));
        this.amountLevels.add(new AmountLevel(150, 2.5f));
        this.amountLevels.add(new AmountLevel(200, 3.0f));
        this.amountLevels.add(new AmountLevel(250, 4.0f));
    }

    private Optional<AmountLevel> getAmountLevel(List<AmountLevel> levels, int level) {
        for (int i = 0; i < levels.size(); ++i) {
            if (level < levels.get((int)i).level) {
                if (i == 0) break;
                return Optional.of(levels.get(i - 1));
            }
            if (i != levels.size() - 1) continue;
            return Optional.of(levels.get(i));
        }
        return Optional.empty();
    }

    public static class Level
    implements LevelEntryList.ILevelEntry {
        @Expose
        private final int level;
        @Expose
        private final MobPool mobPool;

        public Level(int level, MobPool mobPool) {
            this.level = level;
            this.mobPool = mobPool;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    public static class MobPool {
        @Expose
        private final WeightedList<String> mobs = new WeightedList();

        public MobPool add(EntityType<?> type, int weight) {
            this.mobs.add(type.getRegistryName().toString(), weight);
            return this;
        }

        public WeightedList<String> getMobs() {
            return this.mobs;
        }

        public String getRandomMob() {
            return this.mobs.getRandom(Config.rand);
        }
    }

    public static class WaveSetup {
        @Expose
        private final List<CompoundWave> waves = new ArrayList<CompoundWave>();

        public WaveSetup addWave(CompoundWave wave) {
            this.waves.add(wave);
            return this;
        }

        public List<CompoundWave> getWaves() {
            return this.waves;
        }
    }

    public static class CompoundWave {
        @Expose
        private final List<ConfiguredWave> waveMobs = new ArrayList<ConfiguredWave>();

        public CompoundWave(ConfiguredWave ... waveMobs) {
            this.waveMobs.addAll(Arrays.asList(waveMobs));
        }

        public List<ConfiguredWave> getWaveMobs() {
            return this.waveMobs;
        }
    }

    public static class ConfiguredWave {
        @Expose
        private int min;
        @Expose
        private int max;
        @Expose
        private String mobPool;

        public ConfiguredWave(int min, int max, String mobPool) {
            this.min = min;
            this.max = max;
            this.mobPool = mobPool;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public String getMobPool() {
            return this.mobPool;
        }
    }

    public static class AmountLevel {
        @Expose
        private final int level;
        @Expose
        private final float mobAmountMultiplier;

        public AmountLevel(int level, float mobAmountMultiplier) {
            this.level = level;
            this.mobAmountMultiplier = mobAmountMultiplier;
        }

        public float getMobAmountMultiplier() {
            return this.mobAmountMultiplier;
        }
    }
}

