/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import iskallia.vault.config.entry.ItemEntry;
import iskallia.vault.config.entry.SingleItemEntry;
import iskallia.vault.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class KeyPressRecipesConfig
extends Config {
    @Expose
    private List<Recipe> RECIPES;

    @Override
    public String getName() {
        return "key_press_recipes";
    }

    public List<Recipe> getRecipes() {
        return this.RECIPES;
    }

    public Recipe getRecipeFor(Item keyItem, Item clusterItem) {
        ResourceLocation keyID = keyItem.getRegistryName();
        ResourceLocation clusterID = clusterItem.getRegistryName();
        if (keyID == null || clusterID == null) {
            return null;
        }
        for (Recipe recipe : this.getRecipes()) {
            if (!recipe.KEY_ITEM.ITEM.equals(keyID.toString()) || !recipe.CLUSTER_ITEM.ITEM.equals(clusterID.toString())) continue;
            return recipe;
        }
        return null;
    }

    public ItemStack getResultFor(Item keyItem, Item clusterItem) {
        Recipe recipe = this.getRecipeFor(keyItem, clusterItem);
        if (recipe == null) {
            return ItemStack.f_41583_;
        }
        ResourceLocation resultID = new ResourceLocation(recipe.RESULT_ITEM.ITEM);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resultID);
        if (item == null) {
            VaultMod.LOGGER.warn("Invalid Key Press recipe result -> {}", (Object)recipe.RESULT_ITEM.ITEM);
            return ItemStack.f_41583_;
        }
        try {
            ItemStack resultStack = new ItemStack((ItemLike)item, recipe.RESULT_ITEM.AMOUNT);
            if (recipe.RESULT_ITEM.NBT != null && !recipe.RESULT_ITEM.NBT.isEmpty()) {
                resultStack.m_41751_(TagParser.m_129359_((String)recipe.RESULT_ITEM.NBT));
            }
            return resultStack;
        }
        catch (CommandSyntaxException e) {
            VaultMod.LOGGER.warn("Malformed NBT at Key Press recipe result -> {} NBT: {}", (Object)recipe.RESULT_ITEM.ITEM, (Object)recipe.RESULT_ITEM.NBT);
            return ItemStack.f_41583_;
        }
    }

    @Override
    protected void reset() {
        this.RECIPES = new ArrayList<Recipe>();
        Recipe recipe = new Recipe();
        recipe.KEY_ITEM = new SingleItemEntry((ItemLike)ModItems.BLANK_KEY);
        recipe.CLUSTER_ITEM = new SingleItemEntry((ItemLike)ModItems.SPARKLETINE_CLUSTER);
        recipe.RESULT_ITEM = new ItemEntry(new ItemStack((ItemLike)ModItems.SPARKLETINE_KEY));
        this.RECIPES.add(recipe);
    }

    public static class Recipe {
        @Expose
        private SingleItemEntry KEY_ITEM;
        @Expose
        private SingleItemEntry CLUSTER_ITEM;
        @Expose
        private ItemEntry RESULT_ITEM;
    }
}

