/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import iskallia.vault.VaultMod;
import iskallia.vault.config.EtchingConfig;
import iskallia.vault.config.TrinketConfig;
import iskallia.vault.config.VaultModifiersConfig;
import iskallia.vault.config.adapter.CompoundTagAdapter;
import iskallia.vault.config.adapter.IdentifierAdapter;
import iskallia.vault.config.adapter.ItemStackAdapter;
import iskallia.vault.config.adapter.LootRollAdapter;
import iskallia.vault.config.adapter.PartialTileAdapter;
import iskallia.vault.config.adapter.RegistryCodecAdapter;
import iskallia.vault.config.adapter.TextColorAdapter;
import iskallia.vault.config.adapter.VersionedKeyAdapter;
import iskallia.vault.config.adapter.WeightedListAdapter;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.data.key.VersionedKey;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.world.loot.LootRoll;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.crystal.CrystalModifiers;
import iskallia.vault.item.crystal.layout.CrystalLayout;
import iskallia.vault.item.crystal.objective.CrystalObjective;
import iskallia.vault.item.crystal.theme.CrystalTheme;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class Config {
    public static final Random rand = new Random();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(MobEffect.class, RegistryCodecAdapter.of(ForgeRegistries.MOB_EFFECTS)).registerTypeHierarchyAdapter(Item.class, RegistryCodecAdapter.of(ForgeRegistries.ITEMS)).registerTypeHierarchyAdapter(Block.class, RegistryCodecAdapter.of(ForgeRegistries.BLOCKS)).registerTypeAdapterFactory(IdentifierAdapter.FACTORY).registerTypeAdapterFactory(TextColorAdapter.FACTORY).registerTypeAdapterFactory(ItemStackAdapter.FACTORY).registerTypeAdapterFactory(PartialTileAdapter.FACTORY).registerTypeAdapterFactory((TypeAdapterFactory)WeightedListAdapter.Factory.INSTANCE).registerTypeHierarchyAdapter(VaultGearTierConfig.AttributeGroup.class, (Object)new VaultGearTierConfig.AttributeGroup.Serializer()).registerTypeHierarchyAdapter(EtchingConfig.EtchingMap.class, (Object)new EtchingConfig.EtchingMap.Serializer()).registerTypeHierarchyAdapter(TrinketConfig.TrinketMap.class, (Object)new TrinketConfig.TrinketMap.Serializer()).registerTypeAdapter(VaultModifiersConfig.ModifierTypeGroups.class, (Object)new VaultModifiersConfig.ModifierTypeGroups.Serializer()).registerTypeAdapter(CompoundTag.class, (Object)CompoundTagAdapter.INSTANCE).registerTypeHierarchyAdapter(VersionedKey.class, (Object)VersionedKeyAdapter.INSTANCE).registerTypeHierarchyAdapter(CrystalLayout.class, (Object)CrystalLayout.Adapter.INSTANCE).registerTypeHierarchyAdapter(CrystalObjective.class, (Object)CrystalObjective.Adapter.INSTANCE).registerTypeHierarchyAdapter(CrystalTheme.class, (Object)CrystalTheme.Adapter.INSTANCE).registerTypeHierarchyAdapter(CrystalModifiers.class, (Object)CrystalModifiers.Adapter.INSTANCE).registerTypeHierarchyAdapter(ScavengeTask.class, (Object)ScavengeTask.Adapter.INSTANCE).registerTypeHierarchyAdapter(LootRoll.class, (Object)LootRollAdapter.INSTANCE).excludeFieldsWithoutExposeAnnotation().enableComplexMapKeySerialization().setPrettyPrinting().create();
    protected String root = "config%s%s%s".formatted(File.separator, "the_vault", File.separator);
    protected String extension = ".json";

    public void generateConfig() {
        this.reset();
        try {
            this.writeConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getConfigFile() {
        return new File(this.root + this.getName() + this.extension);
    }

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Config> T readConfig() {
        VaultMod.LOGGER.info("Reading config: " + this.getName());
        try (FileReader reader = new FileReader(this.getConfigFile());){
            Config config = (Config)GSON.fromJson((Reader)reader, this.getClass());
            config.onLoad(this);
            if (!config.isValid()) {
                VaultMod.LOGGER.error("Invalid config {}, using defaults", (Object)this);
                ModConfigs.INVALID_CONFIGS.add(this.getConfigFile().getName() + " - There was an invalid setting in this config.");
                config.reset();
            }
            Config config2 = config;
            return (T)config2;
        }
        catch (Exception e2) {
            VaultMod.LOGGER.warn("Config file {} not found, generating new", (Object)this);
            this.generateConfig();
            return (T)this;
        }
    }

    protected boolean isValid() {
        return true;
    }

    protected void onLoad(Config oldConfigInstance) {
    }

    public static boolean checkAllFieldsAreNotNull(Object o) throws IllegalAccessException {
        for (Field v : o.getClass().getDeclaredFields()) {
            boolean b;
            if (!v.canAccess(o)) continue;
            Object field = v.get(o);
            if (field == null) {
                return false;
            }
            if (field.getClass().isPrimitive() || (b = Config.checkAllFieldsAreNotNull(field))) continue;
            return false;
        }
        return true;
    }

    protected abstract void reset();

    public void writeConfig() throws IOException {
        File cfgFile = this.getConfigFile();
        File dir = cfgFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        if (!cfgFile.exists() && !cfgFile.createNewFile()) {
            return;
        }
        FileWriter writer = new FileWriter(cfgFile);
        GSON.toJson((Object)this, (Appendable)writer);
        writer.flush();
        writer.close();
    }
}

