/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.config.Config;
import java.util.stream.Stream;
import net.minecraft.network.chat.TextColor;

public class AbilitiesVignetteConfig
extends Config {
    private static final String NAME = "abilities_vignette";
    @Expose
    public boolean ENABLED;
    @Expose
    public VignetteData GHOST_WALK;
    @Expose
    public VignetteData TANK;
    @Expose
    public VignetteData TANK_PROJECTILE;
    @Expose
    public VignetteData TANK_REFLECT;
    @Expose
    public VignetteData EXECUTE;
    @Expose
    public VignetteData MANA_SHIELD;
    @Expose
    public VignetteData RAMPAGE;
    @Expose
    public VignetteData RAMPAGE_LEECH;
    @Expose
    public VignetteData RAMPAGE_CHAIN;
    @Expose
    public VignetteData RAGE;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void reset() {
        this.ENABLED = true;
        this.GHOST_WALK = new VignetteData(TextColor.m_131268_((String)"#ABEABE"), 0.125f, VignetteStyle.VIGNETTE);
        this.TANK = new VignetteData(TextColor.m_131268_((String)"#FFFFFF"), 0.125f, VignetteStyle.VIGNETTE);
        this.TANK_PROJECTILE = new VignetteData(TextColor.m_131268_((String)"#FFFFFF"), 0.125f, VignetteStyle.VIGNETTE);
        this.TANK_REFLECT = new VignetteData(TextColor.m_131268_((String)"#FFFFFF"), 0.125f, VignetteStyle.VIGNETTE);
        this.EXECUTE = new VignetteData(TextColor.m_131268_((String)"#FF0000"), 0.125f, VignetteStyle.VIGNETTE);
        this.MANA_SHIELD = new VignetteData(TextColor.m_131268_((String)"#00FFFF"), 0.125f, VignetteStyle.VIGNETTE);
        this.RAMPAGE = new VignetteData(TextColor.m_131268_((String)"#FF0000"), 0.125f, VignetteStyle.VIGNETTE);
        this.RAMPAGE_LEECH = new VignetteData(TextColor.m_131268_((String)"#FF0000"), 0.125f, VignetteStyle.VIGNETTE);
        this.RAMPAGE_CHAIN = new VignetteData(TextColor.m_131268_((String)"#FF0000"), 0.125f, VignetteStyle.VIGNETTE);
        this.RAGE = new VignetteData(TextColor.m_131268_((String)"#FF0000"), 0.5f, VignetteStyle.VIGNETTE);
    }

    @Override
    protected boolean isValid() {
        return this.getAll().noneMatch(vignetteData -> vignetteData.color == null);
    }

    protected Stream<VignetteData> getAll() {
        return Stream.of(this.GHOST_WALK, this.TANK, this.TANK_PROJECTILE, this.TANK_REFLECT, this.EXECUTE, this.MANA_SHIELD, this.RAMPAGE, this.RAMPAGE_LEECH, this.RAMPAGE_CHAIN, this.RAGE);
    }

    public static class VignetteData {
        @Expose
        public final TextColor color;
        @Expose
        public final float alpha;
        @Expose
        public final VignetteStyle style;

        public VignetteData(TextColor color, float alpha, VignetteStyle style) {
            this.color = color;
            this.alpha = alpha;
            this.style = style;
        }
    }

    public static enum VignetteStyle {
        FILL,
        VIGNETTE;

    }
}

