/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.VaultMod;
import iskallia.vault.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class AbilitiesGUIConfig
extends Config {
    @Expose
    private Map<String, AbilityStyle> styles;
    private final Map<String, SpecializationStyle> specializationStyleLookup = new HashMap<String, SpecializationStyle>();

    @Override
    public String getName() {
        return "abilities_gui_styles";
    }

    @Override
    public <T extends Config> T readConfig() {
        AbilitiesGUIConfig config = (AbilitiesGUIConfig)super.readConfig();
        config.specializationStyleLookup.clear();
        for (AbilityStyle abilityStyle : config.styles.values()) {
            Map<String, SpecializationStyle> specializationStyles = abilityStyle.getSpecializationStyles();
            if (specializationStyles == null) continue;
            config.specializationStyleLookup.putAll(specializationStyles);
        }
        AbilitiesGUIConfig guiConfig = config;
        return (T)guiConfig;
    }

    @Nullable
    public ResourceLocation getIcon(String key) {
        if (this.styles.containsKey(key)) {
            return this.styles.get(key).getIcon();
        }
        if (this.specializationStyleLookup.containsKey(key)) {
            return this.specializationStyleLookup.get(key).getIcon();
        }
        return null;
    }

    public Map<String, AbilityStyle> getStyles() {
        return this.styles;
    }

    @Override
    protected void reset() {
        this.styles = new HashMap<String, AbilityStyle>();
        int x = 0;
        int y = 0;
        this.styles.put("Nova", new AbilityStyle(x, y, VaultMod.id("gui/abilities/nova"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Nova_Speed", new SpecializationStyle(VaultMod.id("gui/abilities/nova_speed")));
                this.put("Nova_Dot", new SpecializationStyle(VaultMod.id("gui/abilities/nova_dot")));
            }
        }));
        this.styles.put("Vein Miner", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/vein_miner"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Vein Miner_Fortune", new SpecializationStyle(VaultMod.id("gui/abilities/vein_miner_fortune")));
                this.put("Vein Miner_Durability", new SpecializationStyle(VaultMod.id("gui/abilities/vein_miner_durability")));
                this.put("Vein Miner_Void", new SpecializationStyle(VaultMod.id("gui/abilities/vein_miner_void")));
            }
        }));
        this.styles.put("Rampage", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/rampage"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Rampage_Leech", new SpecializationStyle(VaultMod.id("gui/abilities/rampage_leech")));
                this.put("Rampage_Chain", new SpecializationStyle(VaultMod.id("gui/abilities/rampage_chain")));
            }
        }));
        this.styles.put("Ghost Walk", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/ghost_walk")));
        this.styles.put("Dash", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/dash"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Dash_Damage", new SpecializationStyle(VaultMod.id("gui/abilities/dash_damage")));
            }
        }));
        this.styles.put("Mega Jump", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/mega_jump"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Mega Jump_Break_Up", new SpecializationStyle(VaultMod.id("gui/abilities/mega_jump_break_up")));
                this.put("Mega Jump_Break_Down", new SpecializationStyle(VaultMod.id("gui/abilities/mega_jump_break_down")));
            }
        }));
        this.styles.put("Mana Shield", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/mana_shield")));
        this.styles.put("Execute", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/execute")));
        this.styles.put("Heal", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/heal"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Heal_Group", new SpecializationStyle(VaultMod.id("gui/abilities/heal_group")));
                this.put("Heal_Effect", new SpecializationStyle(VaultMod.id("gui/abilities/heal_effect")));
            }
        }));
        this.styles.put("Tank", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/tank"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Tank_Projectile", new SpecializationStyle(VaultMod.id("gui/abilities/tank_projectile")));
                this.put("Tank_Reflect", new SpecializationStyle(VaultMod.id("gui/abilities/tank_reflect")));
            }
        }));
        this.styles.put("Summon Eternal", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/summon_eternal")));
        this.styles.put("Hunter", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/hunter"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Hunter_Blocks", new SpecializationStyle(VaultMod.id("gui/abilities/hunter_blocks")));
            }
        }));
        this.styles.put("Farmer", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/farmer"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Farmer_Melon", new SpecializationStyle(VaultMod.id("gui/abilities/farmer_melon")));
                this.put("Farmer_Cactus", new SpecializationStyle(VaultMod.id("gui/abilities/farmer_cactus")));
                this.put("Farmer_Animal", new SpecializationStyle(VaultMod.id("gui/abilities/farmer_animal")));
            }
        }));
        this.styles.put("Taunt", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/taunt"), new LinkedHashMap<String, SpecializationStyle>(){
            {
                this.put("Taunt_Repel", new SpecializationStyle(VaultMod.id("gui/abilities/taunt_repel")));
            }
        }));
        this.styles.put("Stonefall", new AbilityStyle(x += 38, y, VaultMod.id("gui/abilities/stonefall")));
    }

    public static class AbilityStyle
    extends IconStyle {
        @Expose
        private final int x;
        @Expose
        private final int y;
        @Expose
        private final LinkedHashMap<String, SpecializationStyle> specializationStyles;

        public AbilityStyle(int x, int y, ResourceLocation icon) {
            this(x, y, icon, new LinkedHashMap<String, SpecializationStyle>());
        }

        public AbilityStyle(int x, int y, ResourceLocation icon, LinkedHashMap<String, SpecializationStyle> specializationStyles) {
            super(icon);
            this.x = x;
            this.y = y;
            this.specializationStyles = specializationStyles;
        }

        public List<ResourceLocation> getIcons() {
            return this.specializationStyles.values().stream().map(IconStyle::getIcon).collect(Collectors.toCollection(() -> new ArrayList<ResourceLocation>(List.of(this.getIcon()))));
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Map<String, SpecializationStyle> getSpecializationStyles() {
            return this.specializationStyles;
        }
    }

    public static class SpecializationStyle
    extends IconStyle {
        public SpecializationStyle(ResourceLocation icon) {
            super(icon);
        }
    }

    public static class IconStyle {
        @Expose
        private final ResourceLocation icon;

        public IconStyle(ResourceLocation icon) {
            this.icon = icon;
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }
    }
}

