/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerResearchesData;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;

public class VaultLevelCommand
extends Command {
    @Override
    public String getName() {
        return "vault_level";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"add_exp").then(Commands.m_82129_((String)"exp", (ArgumentType)IntegerArgumentType.integer()).executes(this::addExp)));
        builder.then(Commands.m_82127_((String)"set_level").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(this::setLevel)));
        builder.then(Commands.m_82127_((String)"reset_all").executes(this::resetAll));
    }

    private int setLevel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        PlayerVaultStatsData.get(source.m_81372_()).setVaultLevel(player, level);
        player.refreshTabListName();
        return 0;
    }

    private int addExp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int exp = IntegerArgumentType.getInteger(context, (String)"exp");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerVaultStatsData.get(source.m_81372_()).addVaultExp(source.m_81375_(), exp);
        return 0;
    }

    private int resetAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerVaultStatsData.get(source.m_81372_()).reset(source.m_81375_());
        PlayerAbilitiesData.get(source.m_81372_()).resetAbilityTree(source.m_81375_());
        PlayerTalentsData.get(source.m_81372_()).resetTalentTree(source.m_81375_());
        PlayerResearchesData.get(source.m_81372_()).resetResearchTree(source.m_81375_());
        return 0;
    }
}

