/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.world.data.EventTeamData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public class TeamScoreCommand
extends Command {
    @Override
    public String getName() {
        return "scores";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.executes(this::showScores);
    }

    private int showScores(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        List<EventTeamData.Team> teams = EventTeamData.get(player.m_183503_()).getTeams();
        teams.sort(Comparator.comparing(EventTeamData.Team::getScore).reversed());
        ArrayList scores = new ArrayList();
        teams.forEach(team -> {
            if (!scores.contains(team.getScore())) {
                scores.add(team.getScore());
            }
        });
        scores.sort(Comparator.reverseOrder());
        for (int i = 0; i < teams.size(); ++i) {
            EventTeamData.Team team2 = teams.get(i);
            if (i > 0) {
                player.m_6352_((Component)new TextComponent("----------------").m_130940_(ChatFormatting.DARK_GRAY), Util.f_137441_);
            }
            MutableComponent ct = new TextComponent("Team: ").m_7220_((Component)new TextComponent(team2.getName()).m_130940_(team2.getColor()));
            player.m_6352_((Component)ct, Util.f_137441_);
            int rankIndex = scores.indexOf(team2.getScore()) + 1;
            ChatFormatting rankColor = rankIndex == 1 ? ChatFormatting.GOLD : (rankIndex == 2 ? ChatFormatting.GRAY : ChatFormatting.RED);
            MutableComponent rankTxt = new TextComponent("Rank: ").m_7220_((Component)new TextComponent(String.valueOf(rankIndex)).m_130940_(rankColor)).m_130946_(" ").m_7220_((Component)new TextComponent("Score: ")).m_7220_((Component)new TextComponent(String.valueOf(team2.getScore())).m_130940_(rankColor));
            player.m_6352_((Component)rankTxt, Util.f_137441_);
            player.m_6352_((Component)new TextComponent("Members:"), Util.f_137441_);
            String memberNames = Strings.join(team2.getMembers(), (String)", ");
            player.m_6352_((Component)new TextComponent(memberNames).m_130940_(team2.getColor()), Util.f_137441_);
        }
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

