/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.world.data.VaultPartyData;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;

public class PartyCommand
extends Command {
    @Override
    public void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)this.getName());
        builder.requires(sender -> sender.m_6761_(this.getRequiredPermissionLevel()));
        this.build((LiteralArgumentBuilder<CommandSourceStack>)builder);
        dispatcher.register(builder);
    }

    @Override
    public String getName() {
        return "party";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"create").executes(this::create));
        builder.then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(this::invite)));
        builder.then(Commands.m_82127_((String)"accept_invite").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(this::accept)));
        builder.then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(this::remove)));
        builder.then(Commands.m_82127_((String)"leave").executes(this::leave));
        builder.then(Commands.m_82127_((String)"disband").executes(this::disband));
        builder.then(Commands.m_82127_((String)"list").executes(this::list));
    }

    private int list(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player;
        VaultPartyData data = VaultPartyData.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        Optional<VaultPartyData.Party> party = data.getParty((player = ((CommandSourceStack)ctx.getSource()).m_81375_()).m_142081_());
        if (!party.isPresent()) {
            player.m_6352_((Component)new TextComponent("You are not in a party!").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        PlayerList players = player.m_20194_().m_6846_();
        MutableComponent members = new TextComponent("Members: ").m_130940_(ChatFormatting.GREEN);
        List playerNames = party.get().getMembers().stream().map(arg_0 -> ((PlayerList)players).m_11259_(arg_0)).filter(Objects::nonNull).map(Player::m_7755_).collect(Collectors.toList());
        for (int i = 0; i < playerNames.size(); ++i) {
            if (i != 0) {
                members.m_130946_(", ");
            }
            members.m_7220_((Component)playerNames.get(i));
        }
        player.m_6352_((Component)members, player.m_142081_());
        return 0;
    }

    private int invite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        VaultPartyData data = VaultPartyData.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        Optional<VaultPartyData.Party> party = data.getParty(player.m_142081_());
        if (!party.isPresent()) {
            player.m_6352_((Component)new TextComponent("You are not in a party!").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        if (data.getParty(target.m_142081_()).isPresent()) {
            player.m_6352_((Component)new TextComponent("This player is already in another party.").m_130940_(ChatFormatting.RED), player.m_142081_());
        } else {
            party.get().getMembers().forEach(uuid -> {
                ServerPlayer player2 = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
                if (player2 == null) {
                    return;
                }
                player2.m_6352_((Component)new TextComponent("Inviting " + target.m_7755_().getString() + " to the party.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
            });
            String partyAccept = "/party accept_invite " + player.m_7755_().getString();
            MutableComponent acceptTxt = new TextComponent(partyAccept).m_130940_(ChatFormatting.AQUA);
            acceptTxt.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to accept!"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, partyAccept)));
            MutableComponent acceptMessage = new TextComponent("").m_7220_((Component)new TextComponent("Run '").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)acceptTxt).m_7220_((Component)new TextComponent("' to accept their invite!").m_130940_(ChatFormatting.GREEN));
            party.get().invite(target.m_142081_());
            target.m_6352_((Component)new TextComponent(player.m_7755_().getString() + " has invited you to their party.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
            target.m_6352_((Component)acceptMessage, player.m_142081_());
        }
        return 0;
    }

    private int accept(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        VaultPartyData data = VaultPartyData.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        Optional<VaultPartyData.Party> party = data.getParty(player.m_142081_());
        if (party.isPresent()) {
            player.m_6352_((Component)new TextComponent("You already are in a party!").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        if (!data.getParty(target.m_142081_()).isPresent()) {
            player.m_6352_((Component)new TextComponent("This player has left their party.").m_130940_(ChatFormatting.RED), player.m_142081_());
        } else {
            data.getParty(target.m_142081_()).get().getMembers().forEach(uuid -> {
                ServerPlayer player2 = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
                if (player2 == null) {
                    return;
                }
                player2.m_6352_((Component)new TextComponent("Successfully added " + player.m_7755_().getString() + " to the party.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
            });
            if (data.getParty(target.m_142081_()).get().confirmInvite(player.m_142081_())) {
                VaultPartyData.broadcastPartyData(player.m_183503_());
                player.m_6352_((Component)new TextComponent("You have been added to " + target.m_7755_().getString() + "'s party.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
            } else {
                player.m_6352_((Component)new TextComponent("You are not invited to " + target.m_7755_().getString() + "'s party.").m_130940_(ChatFormatting.RED), player.m_142081_());
            }
        }
        return 0;
    }

    private int remove(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        VaultPartyData data = VaultPartyData.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        Optional<VaultPartyData.Party> party = data.getParty(player.m_142081_());
        if (!party.isPresent()) {
            player.m_6352_((Component)new TextComponent("You are not in a party!").m_130940_(ChatFormatting.RED), player.m_142081_());
            return 0;
        }
        Optional<VaultPartyData.Party> other = data.getParty(target.m_142081_());
        if (other.isPresent() && other.get() != party.get()) {
            player.m_6352_((Component)new TextComponent("This player is in another party.").m_130940_(ChatFormatting.RED), player.m_142081_());
        } else if (party.get().remove(target.m_142081_())) {
            party.get().getMembers().forEach(uuid -> {
                ServerPlayer player2 = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
                if (player2 == null) {
                    return;
                }
                player2.m_6352_((Component)new TextComponent(target.m_7755_().getString() + " was removed from the party.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
            });
            target.m_6352_((Component)new TextComponent("You have been removed from " + player.m_7755_().getString() + "'s party.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
            VaultPartyData.broadcastPartyData(player.m_183503_());
        } else {
            player.m_6352_((Component)new TextComponent("This player not in your party.").m_130940_(ChatFormatting.RED), player.m_142081_());
        }
        return 0;
    }

    private int create(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player;
        VaultPartyData data = VaultPartyData.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        if (data.createParty((player = ((CommandSourceStack)ctx.getSource()).m_81375_()).m_142081_())) {
            player.m_6352_((Component)new TextComponent("Successfully created a party.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
            VaultPartyData.broadcastPartyData(player.m_183503_());
        } else {
            player.m_6352_((Component)new TextComponent("You are already in a party! Please leave or disband it first.").m_130940_(ChatFormatting.RED), player.m_142081_());
        }
        return 0;
    }

    private int leave(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player;
        VaultPartyData data = VaultPartyData.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        Optional<VaultPartyData.Party> party = data.getParty((player = ((CommandSourceStack)ctx.getSource()).m_81375_()).m_142081_());
        if (party.isPresent()) {
            if (party.get().remove(player.m_142081_())) {
                party.get().getMembers().forEach(uuid -> {
                    ServerPlayer player2 = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
                    if (player2 == null) {
                        return;
                    }
                    player2.m_6352_((Component)new TextComponent(player.m_7755_().getString() + " has left the party.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
                });
                player.m_6352_((Component)new TextComponent("Successfully left the party.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
                VaultPartyData.broadcastPartyData(player.m_183503_());
            } else {
                player.m_6352_((Component)new TextComponent("You are not in a party!").m_130940_(ChatFormatting.RED), player.m_142081_());
            }
        } else {
            player.m_6352_((Component)new TextComponent("You are not in a party!").m_130940_(ChatFormatting.RED), player.m_142081_());
        }
        return 0;
    }

    private int disband(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player;
        VaultPartyData data = VaultPartyData.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        VaultPartyData.Party party = data.getParty((player = ((CommandSourceStack)ctx.getSource()).m_81375_()).m_142081_()).orElse(null);
        if (party != null && data.disbandParty(player.m_142081_())) {
            party.getMembers().forEach(uuid -> {
                ServerPlayer player2 = ((CommandSourceStack)ctx.getSource()).m_81377_().m_6846_().m_11259_(uuid);
                if (player2 == null) {
                    return;
                }
                player2.m_6352_((Component)new TextComponent("The party was disbanded.").m_130940_(ChatFormatting.GREEN), player.m_142081_());
            });
            VaultPartyData.broadcastPartyData(player.m_183503_());
        } else {
            player.m_6352_((Component)new TextComponent("You are not in a party!").m_130940_(ChatFormatting.RED), player.m_142081_());
        }
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

