/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.dynamodel.model.armor.ArmorModel;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.DiscoveredRelicsData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModelDebugCommand
extends Command {
    @Override
    public String getName() {
        return "model_debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"discover_all").executes(this::discoverAll));
        builder.then(Commands.m_82127_((String)"undiscover_all").executes(this::undiscoverAll));
        ModDynamicModels.Armor.MODEL_REGISTRY.forEach((setId, armorModel) -> {
            builder.then(Commands.m_82127_((String)"all_armor_pieces").then(Commands.m_82127_((String)setId.toString()).executes(ctx -> this.giveAllPieces((CommandContext<CommandSourceStack>)ctx, (ArmorModel)armorModel))));
            armorModel.getPiece(EquipmentSlot.HEAD).ifPresent(piece -> builder.then(Commands.m_82127_((String)"helmet").then(Commands.m_82127_((String)piece.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.HELMET, piece.getId())))));
            armorModel.getPiece(EquipmentSlot.CHEST).ifPresent(piece -> builder.then(Commands.m_82127_((String)"chestplate").then(Commands.m_82127_((String)piece.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.CHESTPLATE, piece.getId())))));
            armorModel.getPiece(EquipmentSlot.LEGS).ifPresent(piece -> builder.then(Commands.m_82127_((String)"leggings").then(Commands.m_82127_((String)piece.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.LEGGINGS, piece.getId())))));
            armorModel.getPiece(EquipmentSlot.FEET).ifPresent(piece -> builder.then(Commands.m_82127_((String)"boots").then(Commands.m_82127_((String)piece.getId().toString()).executes(ctx -> this.givePiece((CommandContext<CommandSourceStack>)ctx, (Item)ModItems.BOOTS, piece.getId())))));
        });
    }

    private int discoverAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        DiscoveredModelsData modelsData = DiscoveredModelsData.get(player.f_8924_);
        ModDynamicModels.REGISTRIES.getUniqueRegistries().forEach(registry -> registry.forEach((modelId, model) -> modelsData.discoverModel(player.m_142081_(), (ResourceLocation)modelId)));
        return 0;
    }

    private int undiscoverAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        DiscoveredModelsData modelsData = DiscoveredModelsData.get(player.f_8924_);
        modelsData.reset(player.m_142081_());
        DiscoveredRelicsData relicsData = DiscoveredRelicsData.get(player.f_8924_);
        relicsData.getDiscoveredRelics(player.m_142081_()).clear();
        relicsData.m_77762_();
        return 0;
    }

    private int giveAllPieces(CommandContext<CommandSourceStack> context, ArmorModel armorModel) throws CommandSyntaxException {
        armorModel.getPiece(EquipmentSlot.HEAD).ifPresent(armorModelPiece -> this.givePiece(context, (Item)ModItems.HELMET, armorModelPiece.getId()));
        armorModel.getPiece(EquipmentSlot.CHEST).ifPresent(armorModelPiece -> this.givePiece(context, (Item)ModItems.CHESTPLATE, armorModelPiece.getId()));
        armorModel.getPiece(EquipmentSlot.LEGS).ifPresent(armorModelPiece -> this.givePiece(context, (Item)ModItems.LEGGINGS, armorModelPiece.getId()));
        armorModel.getPiece(EquipmentSlot.FEET).ifPresent(armorModelPiece -> this.givePiece(context, (Item)ModItems.BOOTS, armorModelPiece.getId()));
        return 0;
    }

    private int givePiece(CommandContext<CommandSourceStack> context, Item gear, ResourceLocation modelId) {
        try {
            ItemStack helmetStack = new ItemStack((ItemLike)gear);
            this.configureGear(helmetStack, modelId, VaultGearRarity.COMMON);
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            EntityHelper.giveItem((Player)player, helmetStack);
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
        return 0;
    }

    private void configureGear(ItemStack gearStack, ResourceLocation modelId, VaultGearRarity rarity) {
        VaultGearData gearData = VaultGearData.read(gearStack);
        gearData.setState(VaultGearState.IDENTIFIED);
        gearData.setRarity(rarity);
        gearData.updateAttribute(ModGearAttributes.GEAR_MODEL, modelId);
        gearData.updateAttribute(ModGearAttributes.GEAR_COLOR, -1);
        gearData.write(gearStack);
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

