/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.backup.BackupListArgument;
import iskallia.vault.backup.BackupManager;
import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.command.Command;
import iskallia.vault.init.ModBlocks;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;

@Deprecated
public class InvRestoreCommand
extends Command {
    @Override
    public String getName() {
        return "inv_restore";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"playerUUID", (ArgumentType)UuidArgument.m_113850_()).executes(this::listTimestamps)));
        builder.then(Commands.m_82127_((String)"restore").then(Commands.m_82129_((String)"playerUUID", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82129_((String)"target", (ArgumentType)new BackupListArgument.UUIDRef()).executes(this::restoreUUID))));
    }

    private int listTimestamps(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        UUID playerRef = UuidArgument.m_113853_(ctx, (String)"playerUUID");
        List<String> timestamps = BackupManager.getMostRecentBackupFileTimestamps(src.m_81377_(), playerRef);
        src.m_81354_((Component)new TextComponent("Last 5 available backups:"), true);
        timestamps.forEach(timestamp -> {
            String restoreCmd = String.format("/%s %s restore %s %s", "the_vault", this.getName(), playerRef.toString(), timestamp);
            ClickEvent ce = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, restoreCmd);
            HoverEvent he = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to get restore command!"));
            TextComponent feedback = new TextComponent(timestamp);
            feedback.m_6270_(Style.f_131099_.m_131142_(ce).m_131144_(he));
            src.m_81354_((Component)feedback, true);
        });
        return 0;
    }

    private int restoreUUID(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        UUID playerRef = UuidArgument.m_113853_(ctx, (String)"playerUUID");
        if (this.attemptRestore((CommandSourceStack)ctx.getSource(), playerRef, (String)ctx.getArgument("target", String.class))) {
            return 1;
        }
        return 0;
    }

    private boolean attemptRestore(CommandSourceStack src, UUID playerRef, String target) throws CommandSyntaxException {
        ServerPlayer playerSource = src.m_81375_();
        MinecraftServer srv = src.m_81377_();
        return BackupManager.getStoredItemStacks(srv, playerRef, target).map(stacks -> {
            BlockPos chestPos;
            int i;
            if (stacks.isEmpty()) {
                src.m_81354_((Component)new TextComponent("Backup file did not contain any items!").m_130940_(ChatFormatting.RED), true);
                return false;
            }
            ServerLevel world = playerSource.m_183503_();
            BlockPos offset = playerSource.m_142538_();
            int chestsRequired = Mth.m_14167_((float)((float)stacks.size() / 27.0f));
            for (i = 0; i < 2 + chestsRequired; ++i) {
                chestPos = offset.m_142082_(0, 2 + i, 0);
                if (world.m_46739_(chestPos) && world.m_46859_(chestPos)) continue;
                src.m_81354_((Component)new TextComponent("Empty space above the player is required!").m_130940_(ChatFormatting.RED), true);
                return false;
            }
            for (i = 0; i < chestsRequired; ++i) {
                BlockEntity te;
                chestPos = offset.m_142082_(0, 2 + i, 0);
                List subStacks = stacks.subList(i * 27, Math.min(stacks.size(), (i + 1) * 27));
                if (!world.m_7731_(chestPos, ModBlocks.WOODEN_CHEST.m_49966_(), 3) || !((te = world.m_7702_(chestPos)) instanceof VaultChestTileEntity)) continue;
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                    for (int index = 0; index < subStacks.size(); ++index) {
                        inv.insertItem(index, (ItemStack)subStacks.get(index), false);
                    }
                });
            }
            return true;
        }).orElseGet(() -> {
            src.m_81354_((Component)new TextComponent("No such backup file found!").m_130940_(ChatFormatting.RED), true);
            return false;
        });
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

