/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.config.StreamerMultipliersConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.ItemGiftBomb;
import iskallia.vault.item.ItemRelicBoosterPack;
import iskallia.vault.research.type.Research;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.data.EventTeamData;
import iskallia.vault.world.data.PlayerAliasData;
import iskallia.vault.world.data.PlayerBlackMarketData;
import iskallia.vault.world.data.PlayerResearchesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.StreamData;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class InternalCommand
extends Command {
    @Override
    public String getName() {
        return "internal";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"received_sub").then(Commands.m_82129_((String)"subscriber", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"months", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> this.receivedSub((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"subscriber"), IntegerArgumentType.getInteger((CommandContext)context, (String)"months"), 1)))));
        builder.then(Commands.m_82127_((String)"received_sub").then(Commands.m_82129_((String)"subscriber", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"months", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.receivedSub((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"subscriber"), IntegerArgumentType.getInteger((CommandContext)context, (String)"months"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier")))))));
        builder.then(Commands.m_82127_((String)"received_sub_gift").then(Commands.m_82129_((String)"gifter", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.receivedSubGift((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"gifter"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier")))))));
        builder.then(Commands.m_82127_((String)"received_donation").then(Commands.m_82129_((String)"donator", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.receivedDonation((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"donator"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
        builder.then(Commands.m_82127_((String)"received_bit_donation").then(Commands.m_82129_((String)"donator", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> this.receivedBitDonation((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"donator"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
        builder.then(Commands.m_82127_((String)"received_trader_core_redemption").then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.word()).executes(context -> this.receiveTraderCoreRedemption((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"sender")))));
        builder.then(Commands.m_82127_((String)"booster_pack").executes(this::giveBoosterPack));
        builder.then(Commands.m_82127_((String)"team_modifyscore").then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(this::modifyScore))));
        builder.then(Commands.m_82127_((String)"reset_black_market").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::resetBlackMarket)));
        builder.then(Commands.m_82127_((String)"reset_black_markets").executes(this::resetBlackMarkets));
        builder.then(Commands.m_82127_((String)"remove_research").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"research", (ArgumentType)StringArgumentType.string()).executes(this::unlearnResearch))));
    }

    private int unlearnResearch(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        Research research = ModConfigs.RESEARCHES.getByName(StringArgumentType.getString(ctx, (String)"research"));
        if (research == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Unknown research"));
            return 0;
        }
        PlayerResearchesData.get(target.m_183503_()).removeResearch(target, research);
        return 0;
    }

    private int resetBlackMarket(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        PlayerBlackMarketData.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getBlackMarket((Player)target).resetTrades();
        return 0;
    }

    private int resetBlackMarkets(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        PlayerBlackMarketData.get(((CommandSourceStack)ctx.getSource()).m_81377_()).getPlayerMap().forEach((uuid, blackMarket) -> blackMarket.resetTrades());
        return 0;
    }

    private int modifyScore(CommandContext<CommandSourceStack> context) {
        ServerLevel sWorld = ((CommandSourceStack)context.getSource()).m_81372_();
        String team = StringArgumentType.getString(context, (String)"team");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        EventTeamData.get(sWorld).modifyScore(team, amount);
        return 0;
    }

    private int giveBoosterPack(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        if (ModConfigs.ARCHITECT_EVENT.isEnabled()) {
            MiscUtils.giveItem(player, ItemRelicBoosterPack.getArchitectBoosterPack());
        } else {
            MiscUtils.giveItem(player, new ItemStack((ItemLike)ModItems.RELIC_BOOSTER_PACK));
        }
        return 0;
    }

    private int receivedSub(CommandContext<CommandSourceStack> context, String name, int months, int tier) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        name = PlayerAliasData.applyAlias(player, name);
        StreamData.get(player.m_183503_()).onSub(player.m_20194_(), player.m_142081_(), name, months);
        PlayerVaultStatsData.get(player.m_183503_()).addVaultExp(player, ModConfigs.STREAMER_EXP.getExpPerSub(player.m_7755_().getString()));
        if (tier >= 3) {
            player.m_6352_((Component)new TextComponent(name + " subscribed with Tier 3!").m_130940_(ChatFormatting.GRAY), Util.f_137441_);
        }
        return 0;
    }

    private int receivedSubGift(CommandContext<CommandSourceStack> context, String gifter, int amount, int tier) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String mcNick = player.m_5446_().getString();
        gifter = PlayerAliasData.applyAlias(player, gifter);
        StreamerMultipliersConfig.StreamerMultipliers multipliers = ModConfigs.STREAMER_MULTIPLIERS.ofStreamer(mcNick);
        float multiplier = tier == 0 || tier == 1 ? (float)multipliers.weightPerGiftedSubT1 : (tier == 2 ? (float)multipliers.weightPerGiftedSubT2 : (float)multipliers.weightPerGiftedSubT3);
        StreamData.get(player.m_183503_()).onDono(player.m_20194_(), player.m_142081_(), gifter, (int)((float)amount * multiplier));
        this.handleGiftBombs(player, gifter, amount);
        return 0;
    }

    private int receivedDonation(CommandContext<CommandSourceStack> context, String donator, int amount) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String mcNick = player.m_5446_().getString();
        donator = PlayerAliasData.applyAlias(player, donator);
        int multiplier = ModConfigs.STREAMER_MULTIPLIERS.ofStreamer((String)mcNick).weightPerDonationUnit;
        StreamData.get(player.m_183503_()).onDono(player.m_20194_(), player.m_142081_(), donator, amount * multiplier);
        return 0;
    }

    private int receivedBitDonation(CommandContext<CommandSourceStack> context, String donator, int amount) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String mcNick = player.m_5446_().getString();
        donator = PlayerAliasData.applyAlias(player, donator);
        int multiplier = ModConfigs.STREAMER_MULTIPLIERS.ofStreamer((String)mcNick).weightPerHundredBits;
        StreamData.get(player.m_183503_()).onDono(player.m_20194_(), player.m_142081_(), donator, amount / 100 * multiplier);
        return 0;
    }

    private int receiveTraderCoreRedemption(CommandContext<CommandSourceStack> context, String claimer) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        claimer = PlayerAliasData.applyAlias(player, claimer);
        player.m_6352_((Component)new TextComponent(claimer + " redeemed a Trader Core!").m_130940_(ChatFormatting.GRAY), Util.f_137441_);
        return 0;
    }

    private void handleGiftBombs(ServerPlayer player, String gifter, int amount) {
        if (amount < 5) {
            return;
        }
        gifter = PlayerAliasData.applyAlias(player, gifter);
        ItemGiftBomb.Variant variant = amount <= 9 ? ItemGiftBomb.Variant.NORMAL : (amount <= 19 ? ItemGiftBomb.Variant.SUPER : (amount <= 49 ? ItemGiftBomb.Variant.MEGA : ItemGiftBomb.Variant.OMEGA));
        Vec3 position = player.m_20182_();
        player.m_183503_().m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, variant == ItemGiftBomb.Variant.NORMAL || variant == ItemGiftBomb.Variant.SUPER ? ModSounds.GIFT_BOMB_GAIN_SFX : ModSounds.MEGA_GIFT_BOMB_GAIN_SFX, SoundSource.PLAYERS, 0.75f, 1.0f);
        ItemStack giftBomb = ItemGiftBomb.forGift(variant, gifter, amount);
        EntityHelper.giveItem((Player)player, giftBomb);
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

