/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultChampionTrophy;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.block.item.FinalVaultFrameBlockItem;
import iskallia.vault.block.item.LootStatueBlockItem;
import iskallia.vault.block.item.TrophyStatueBlockItem;
import iskallia.vault.block.item.VaultChampionTrophyBlockItem;
import iskallia.vault.command.Command;
import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.CrateLootGenerator;
import iskallia.vault.core.vault.objective.AwardCrateObjective;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.theme.PoolCrystalTheme;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.WeekKey;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.server.command.EnumArgument;

public class GiveLootCommand
extends Command {
    @Override
    public String getName() {
        return "give_loot";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"arena_crate").then(Commands.m_82129_((String)"champion", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.giveArenaCrate((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"champion")))));
        builder.then(Commands.m_82127_((String)"raffle_boss_crate").then(Commands.m_82129_((String)"boss_name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.giveRaffleBossCrate((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"boss_name")))));
        builder.then(Commands.m_82127_((String)"normal_boss_crate").executes(ctx -> this.giveNormalBossCrate((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_())));
        builder.then(Commands.m_82127_((String)"loot_statue").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.giveLootStatue(StringArgumentType.getString((CommandContext)ctx, (String)"name"), (CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_()))));
        builder.then(Commands.m_82127_((String)"raffle_crystal").then(Commands.m_82129_((String)"winner", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.giveRaffleCrystal((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"winner")))));
        builder.then(Commands.m_82127_((String)"crystal").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)EnumArgument.enumArgument(CrystalData.Type.class)).executes(this::giveCrystal)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(this::giveCrystal))));
        builder.then(Commands.m_82127_((String)"paxel").then(Commands.m_82129_((String)"enhancementId", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.givePaxel((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"enhancementId")))));
        builder.then(Commands.m_82127_((String)"set_gear_name").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(this::setGearName)));
        builder.then(Commands.m_82127_((String)"record_trophy").then(Commands.m_82129_((String)"year", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"week", (ArgumentType)IntegerArgumentType.integer()).executes(this::giveTrophy))));
        builder.then(Commands.m_82127_((String)"record_box").executes(this::giveTrophyBox));
        builder.then(Commands.m_82127_((String)"final_vault_frame").then(Commands.m_82129_((String)"ownerUUID", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82129_((String)"ownerNickname", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.giveFinalVaultFrame((CommandContext<CommandSourceStack>)ctx, UuidArgument.m_113853_((CommandContext)ctx, (String)"ownerUUID"), StringArgumentType.getString((CommandContext)ctx, (String)"ownerNickname"))))));
        builder.then(Commands.m_82127_((String)"champion_trophy").then(Commands.m_82129_((String)"ownerUUID", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82129_((String)"ownerNickname", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"variant", (ArgumentType)EnumArgument.enumArgument(VaultChampionTrophy.Variant.class)).executes(ctx -> this.giveChampionTrophy((CommandContext<CommandSourceStack>)ctx, UuidArgument.m_113853_((CommandContext)ctx, (String)"ownerUUID"), StringArgumentType.getString((CommandContext)ctx, (String)"ownerNickname"), (VaultChampionTrophy.Variant)((Object)((Object)ctx.getArgument("variant", VaultChampionTrophy.Variant.class)))))))));
        builder.then(Commands.m_82127_((String)"vault_doll").then(Commands.m_82129_((String)"playerIGN", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.giveVaultDoll((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"playerIGN")))));
        builder.then(Commands.m_82127_((String)"crate").then(Commands.m_82129_((String)"crateType", (ArgumentType)EnumArgument.enumArgument(VaultCrateBlock.Type.class)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::giveCrate))).executes(this::giveCrate))));
    }

    private int giveCrate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player;
        VaultCrateBlock.Type type = (VaultCrateBlock.Type)((Object)ctx.getArgument("crateType", VaultCrateBlock.Type.class));
        ItemStack crate = ItemStack.f_41583_;
        try {
            player = EntityArgument.m_91474_(ctx, (String)"player");
        }
        catch (CommandSyntaxException exception) {
            player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        }
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        switch (type) {
            case BOUNTY: {
                crate = ModConfigs.REWARD_CONFIG.generateReward(level).createRewardCrate();
                break;
            }
            case CAKE: 
            case MONOLITH: 
            case SCAVENGER: 
            case BOSS: {
                AwardCrateObjective objective = AwardCrateObjective.ofConfig(type, type.toString().toLowerCase(), level, true);
                CrateLootGenerator crateLootGenerator = new CrateLootGenerator(objective.get(AwardCrateObjective.LOOT_TABLE), objective.has(AwardCrateObjective.ADD_ARTIFACT), objective.get(AwardCrateObjective.ARTIFACT_CHANCE).floatValue());
                crate = VaultCrateBlock.getCrateWithLoot(type, crateLootGenerator.createLootForCommand(JavaRandom.ofInternal(new Random().nextLong()), level));
            }
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)crate);
        return 0;
    }

    private int setGearName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack heldItem = sPlayer.m_21205_();
        if (heldItem.m_41619_()) {
            return 0;
        }
        return 0;
    }

    public int giveTrophyBox(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel sWorld = sPlayer.m_183503_();
        LootContext.Builder builder = new LootContext.Builder(sWorld).m_78977_(sWorld.f_46441_).m_78963_(sPlayer.m_36336_());
        int playerLevel = PlayerVaultStatsData.get(sWorld).getVaultStats(sPlayer.m_142081_()).getVaultLevel();
        LegacyLootTablesConfig.Level config = ModConfigs.LOOT_TABLES.getForLevel(playerLevel);
        LootTable bossBonusTbl = sPlayer.m_20194_().m_129898_().m_79217_(config.getScavengerCrate());
        NonNullList quickBossLoot = NonNullList.m_122779_();
        quickBossLoot.addAll((Collection)bossBonusTbl.m_79129_(builder.m_78975_(LootContextParamSets.f_81410_)));
        Collections.shuffle(quickBossLoot);
        ItemStack box = new ItemStack((ItemLike)Items.f_42266_);
        box.m_41784_().m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        ContainerHelper.m_18973_((CompoundTag)box.m_41784_().m_128469_("BlockEntityTag"), (NonNullList)quickBossLoot);
        sPlayer.m_36356_(box);
        sPlayer.m_6352_((Component)new TextComponent("Generated Recordbox for Vault level " + playerLevel), Util.f_137441_);
        return 0;
    }

    public int giveTrophy(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        int year = IntegerArgumentType.getInteger(context, (String)"year");
        int week = IntegerArgumentType.getInteger(context, (String)"week");
        ItemStack statue = TrophyStatueBlockItem.getTrophy(sPlayer.m_183503_(), WeekKey.of(year, week));
        if (!statue.m_41619_()) {
            sPlayer.m_36356_(statue);
        } else {
            sPlayer.m_6352_((Component)new TextComponent("No record set!"), Util.f_137441_);
        }
        return 0;
    }

    private int giveLootStatue(String name, CommandContext<CommandSourceStack> context, ServerPlayer player) {
        ItemStack statue = LootStatueBlockItem.getStatueBlockItem(name);
        player.m_36356_(statue);
        return 0;
    }

    public int giveCrystal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int level = 0;
        try {
            level = (Integer)context.getArgument("level", Integer.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CrystalData.Type type = (CrystalData.Type)((Object)context.getArgument("type", CrystalData.Type.class));
        ItemStack stack = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
        CrystalData crystal = new CrystalData(stack);
        crystal.setTheme(new PoolCrystalTheme(VaultMod.id("default")));
        crystal.setLevel(level);
        if (type == CrystalData.Type.RAFFLE) {
            // empty if block
        }
        EntityHelper.giveItem((Player)((CommandSourceStack)context.getSource()).m_81375_(), stack);
        return 0;
    }

    public int giveArenaCrate(CommandContext<CommandSourceStack> context, ServerPlayer player, String championName) {
        ServerLevel world = player.m_183503_();
        LootContext.Builder builder = new LootContext.Builder(world).m_78977_(world.f_46441_).m_78963_(player.m_36336_());
        LootContext ctx = builder.m_78975_(LootContextParamSets.f_81410_);
        NonNullList stacks = NonNullList.m_122779_();
        stacks.add((Object)LootStatueBlockItem.getStatueBlockItem(championName));
        int level = PlayerVaultStatsData.get(world).getVaultStats((Player)player).getVaultLevel();
        List items = world.m_142572_().m_129898_().m_79217_(ModConfigs.LOOT_TABLES.getForLevel(level).getArenaCrate()).m_79129_(ctx);
        stacks.addAll((Collection)items);
        ItemStack crate = VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.ARENA, (NonNullList<ItemStack>)stacks);
        EntityHelper.giveItem((Player)player, crate);
        return 0;
    }

    public int giveNormalBossCrate(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        ServerLevel world = player.m_183503_();
        LootContext.Builder builder = new LootContext.Builder(world).m_78977_(world.f_46441_).m_78963_(player.m_36336_());
        LootContext ctx = builder.m_78975_(LootContextParamSets.f_81410_);
        int level = PlayerVaultStatsData.get(world).getVaultStats((Player)player).getVaultLevel();
        NonNullList stacks = NonNullList.m_122779_();
        ItemStack crate = VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.BOSS, (NonNullList<ItemStack>)stacks);
        EntityHelper.giveItem((Player)player, crate);
        return 0;
    }

    public int giveRaffleBossCrate(CommandContext<CommandSourceStack> context, ServerPlayer player, String bossName) {
        ServerLevel world = player.m_183503_();
        LootContext.Builder builder = new LootContext.Builder(world).m_78977_(world.f_46441_).m_78963_(player.m_36336_());
        LootContext ctx = builder.m_78975_(LootContextParamSets.f_81410_);
        NonNullList stacks = NonNullList.m_122779_();
        stacks.add((Object)LootStatueBlockItem.getStatueBlockItem(bossName));
        int level = PlayerVaultStatsData.get(world).getVaultStats((Player)player).getVaultLevel();
        ItemStack crate = VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.BOSS, (NonNullList<ItemStack>)stacks);
        EntityHelper.giveItem((Player)player, crate);
        return 0;
    }

    public int giveRaffleCrystal(CommandContext<CommandSourceStack> context, ServerPlayer player, String winner) {
        ItemStack crystalStack = VaultCrystalItem.getCrystalWithBoss(winner);
        EntityHelper.giveItem((Player)player, crystalStack);
        return 0;
    }

    public int givePaxel(CommandContext<CommandSourceStack> context, ServerPlayer player, String enhancementSId) {
        ItemStack paxelStack = new ItemStack((ItemLike)ModItems.VAULTERITE_PICKAXE);
        EntityHelper.giveItem((Player)player, paxelStack);
        return 0;
    }

    public int giveFinalVaultFrame(CommandContext<CommandSourceStack> context, UUID ownerUUID, String ownerNickname) throws CommandSyntaxException {
        ItemStack frameStack = new ItemStack((ItemLike)ModBlocks.FINAL_VAULT_FRAME_BLOCK_ITEM);
        FinalVaultFrameBlockItem.writeToItemStack(frameStack, ownerUUID, ownerNickname);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        EntityHelper.giveItem((Player)player, frameStack);
        return 0;
    }

    public int giveChampionTrophy(CommandContext<CommandSourceStack> context, UUID ownerUUID, String ownerNickname, VaultChampionTrophy.Variant variant) throws CommandSyntaxException {
        ItemStack trophyStack = VaultChampionTrophyBlockItem.create(ownerUUID, ownerNickname, variant);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        EntityHelper.giveItem((Player)player, trophyStack);
        return 0;
    }

    private int giveVaultDoll(CommandContext<CommandSourceStack> context, String playerIGN) throws CommandSyntaxException {
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack dollStack = new ItemStack((ItemLike)ModItems.VAULT_DOLL);
        ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
        serverLevel.m_142572_().m_129927_().m_10996_(playerIGN).ifPresentOrElse(gp -> {
            VaultDollItem.setNewDollAttributes(dollStack, gp, (Level)((CommandSourceStack)context.getSource()).m_81372_());
            EntityHelper.giveItem((Player)serverPlayer, dollStack);
        }, () -> serverPlayer.m_6352_((Component)new TextComponent("Unable to find player's IGN: " + playerIGN).m_130940_(ChatFormatting.RED), Util.f_137441_));
        return 0;
    }
}

