/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.objective.raid.RaidChallengeObjective;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class EventCommand
extends Command {
    @Override
    public String getName() {
        return "event";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"vote").then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"modifier", (ArgumentType)StringArgumentType.string()).executes(this::voteModifier))));
    }

    private int voteModifier(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel sWorld = player.m_183503_();
        if (!ModConfigs.RAID_EVENT_CONFIG.isEnabled()) {
            return 0;
        }
        VaultRaid vault = null;
        if (vault == null) {
            return 0;
        }
        RaidChallengeObjective objective = vault.getActiveObjective(RaidChallengeObjective.class).orElse(null);
        if (objective == null || objective.getVotingSession() == null) {
            return 0;
        }
        String sender = StringArgumentType.getString(context, (String)"sender");
        String modifier = StringArgumentType.getString(context, (String)"modifier");
        objective.getVotingSession().addVote(sender, modifier);
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

