/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.block.CryoChamberBlock;
import iskallia.vault.command.Command;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.world.data.EternalsData;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class EternalCommand
extends Command {
    @Override
    public String getName() {
        return "eternal";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).executes(this::removeEternal)));
        builder.then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"playerId", (ArgumentType)UuidArgument.m_113850_()).executes(this::listEternals)));
        builder.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).executes(this::setEternal)));
    }

    private int setEternal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack held = sPlayer.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_() || !(held.m_41720_() instanceof BlockItem) || !(((BlockItem)held.m_41720_()).m_40614_() instanceof CryoChamberBlock)) {
            sPlayer.m_6352_((Component)new TextComponent("Not holding cryochamber!").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        UUID eternalUUID = UuidArgument.m_113853_(context, (String)"uuid");
        EternalsData data = EternalsData.get(sPlayer.m_183503_());
        EternalData eternal = data.getEternal(eternalUUID);
        if (eternal == null) {
            sPlayer.m_6352_((Component)new TextComponent("Specified eternal does not exist!").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return 0;
        }
        CompoundTag tag = held.m_41698_("BlockEntityTag");
        tag.m_128362_("EternalId", eternalUUID);
        sPlayer.m_6352_((Component)new TextComponent("Eternal set!").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 0;
    }

    private int listEternals(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        UUID playerId = UuidArgument.m_113853_(context, (String)"playerId");
        EternalsData data = EternalsData.get(sPlayer.m_183503_());
        EternalsData.EternalGroup group = data.getEternals(playerId);
        sPlayer.m_6352_((Component)new TextComponent("Eternals:").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        for (EternalData eternal : group.getEternals()) {
            TextComponent txt = new TextComponent(eternal.getId().toString() + " / " + eternal.getName());
            txt.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Copy UUID"))));
            txt.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, eternal.getId().toString())));
            sPlayer.m_6352_((Component)txt, Util.f_137441_);
        }
        return 0;
    }

    private int removeEternal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer sPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        UUID eternalUUID = UuidArgument.m_113853_(context, (String)"uuid");
        EternalsData data = EternalsData.get(sPlayer.m_183503_());
        if (data.removeEternal(eternalUUID)) {
            sPlayer.m_6352_((Component)new TextComponent("Eternal removed!").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
            return 0;
        }
        sPlayer.m_6352_((Component)new TextComponent("Specified eternal does not exist!").m_130940_(ChatFormatting.RED), Util.f_137441_);
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

