/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.google.common.collect.Streams;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.VaultMod;
import iskallia.vault.altar.RequiredItems;
import iskallia.vault.command.Command;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.VersionedKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.Event;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.dump.EntityAttrDump;
import iskallia.vault.dump.GearModelDump;
import iskallia.vault.dump.TranslationsDump;
import iskallia.vault.etching.EtchingRegistry;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.gear.EtchingItem;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.world.data.PlayerProficiencyData;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.StreamData;
import iskallia.vault.world.data.VaultPlayerStats;
import iskallia.vault.world.vault.gen.layout.CircleRoomLayout;
import iskallia.vault.world.vault.gen.layout.DiamondRoomLayout;
import iskallia.vault.world.vault.gen.layout.SquareRoomLayout;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DebugCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_LOOT_TABLE = (context, builder) -> SharedSuggestionProvider.m_82957_(VaultRegistry.LOOT_TABLE.getKeys().stream().map(VersionedKey::getId), (SuggestionsBuilder)builder);

    @Override
    public String getName() {
        return "debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"20_subs").executes(this::random20Subs));
        builder.then(Commands.m_82127_((String)"dump_configs").executes(this::dumpConfigs));
        builder.then(Commands.m_82127_((String)"dump_blockstate").then(Commands.m_82129_((String)"block_pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> this.dumpBlockstate((CommandContext<CommandSourceStack>)ctx, BlockPosArgument.m_174395_((CommandContext)ctx, (String)"block_pos")))));
        builder.then(Commands.m_82127_((String)"dump_item_nbt").executes(this::dumpItemNBT));
        builder.then(Commands.m_82127_((String)"dump_vault_sizes").executes(this::dumpVaultSizes));
        builder.then(Commands.m_82127_((String)"vault_kick").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::kickFromVault)));
        builder.then(Commands.m_82127_((String)"apply_etching").then(Commands.m_82129_((String)"etching", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(this::testApplyEtching)));
        builder.then(Commands.m_82127_((String)"give_all_etchings").executes(this::testGiveAllEtchings));
        builder.then(Commands.m_82127_((String)"give_all_trinkets").executes(this::testGiveAllTrinkets));
        builder.then(Commands.m_82127_((String)"dev_world").executes(this::setupDevWorld));
        builder.then(Commands.m_82127_((String)"reset_proficiencies").executes(this::resetProficiencies));
        builder.then(Commands.m_82127_((String)"insert_loot").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_LOOT_TABLE).executes(this::insertLoot))));
        builder.then(Commands.m_82127_((String)"debug_events").executes(this::debugEvents));
        builder.then(Commands.m_82127_((String)"prompt_vault_stats").executes(this::promptVaultStats));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"altar_level").then(Commands.m_82127_((String)"get").executes(this::getAltarLevel))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(this::setAltarLevel))));
    }

    private int resetProficiencies(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        PlayerProficiencyData data = PlayerProficiencyData.get(player.m_183503_());
        for (ProficiencyType type : ProficiencyType.values()) {
            data.setProficiency(player.m_142081_(), type, 0);
        }
        data.sendProficiencyInformation(player);
        return 0;
    }

    private int getAltarLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int level = PlayerStatsData.get().get((Player)player).getCrystals().size();
        player.m_6352_((Component)new TextComponent("Altar Level: " + level), player.m_142081_());
        return 0;
    }

    private int setAltarLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        PlayerStatsData playerStatsData = PlayerStatsData.get();
        playerStatsData.clearCrystals(player.m_142081_());
        for (int i = 0; i <= level; ++i) {
            playerStatsData.onCrystalCrafted(player.m_142081_(), List.of(new RequiredItems("resource", List.of(ItemStack.f_41583_), 100), new RequiredItems("mob", List.of(ItemStack.f_41583_), 100), new RequiredItems("farmable", List.of(ItemStack.f_41583_), 100), new RequiredItems("misc", List.of(ItemStack.f_41583_), 100)));
        }
        return 0;
    }

    private int promptVaultStats(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        VaultPlayerStats.prompt(((CommandSourceStack)ctx.getSource()).m_81375_());
        return 0;
    }

    private int debugEvents(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        player.m_9146_((Component)new TextComponent("~ Listing events ordered by highest priority ~").m_130940_(ChatFormatting.GREEN), ChatType.SYSTEM, player.m_142081_());
        ArrayList valid = new ArrayList();
        for (Event<?, ?> event : CommonEvents.REGISTRY) {
            for (Integer priority : event.getListeners().keySet()) {
                Map<Object, List<Consumer<?>>> map = event.getListeners().get(priority);
                for (List<Consumer<?>> listeners : map.values()) {
                    if (listeners.isEmpty()) continue;
                    valid.add(event);
                }
            }
        }
        for (Event<?, ?> event : CommonEvents.REGISTRY) {
            if (!valid.contains(event)) continue;
            player.m_9146_((Component)new TextComponent("=== ").m_7220_((Component)new TextComponent(event.getClass().getSimpleName()).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)new TextComponent(" ===").m_130940_(ChatFormatting.WHITE)), ChatType.SYSTEM, player.m_142081_());
            for (Integer priority : event.getListeners().keySet()) {
                if (event.getListeners().get(priority).isEmpty()) continue;
                player.m_9146_((Component)new TextComponent("Priority: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(String.valueOf(priority)).m_130940_(priority == 0 ? ChatFormatting.GRAY : (priority < 0 ? ChatFormatting.RED : ChatFormatting.GREEN))), ChatType.SYSTEM, player.m_142081_());
                for (Map.Entry<Object, List<Consumer<?>>> map : event.getListeners().get(priority).entrySet()) {
                    player.m_9146_((Component)new TextComponent("   " + map.getKey().getClass().getSimpleName()).m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)new TextComponent(" has ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent("" + map.getValue().size()).m_130940_(ChatFormatting.GOLD)), ChatType.SYSTEM, player.m_142081_());
                }
            }
        }
        return 0;
    }

    private int insertLoot(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_118242_(context, (String)"pos");
        ResourceLocation id = ResourceLocationArgument.m_107011_(context, (String)"id");
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).m_81372_().m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                LootTableGenerator generator = new LootTableGenerator(Version.latest(), VaultRegistry.LOOT_TABLE.getKey(id));
                generator.generate(JavaRandom.ofNanoTime());
                generator.getItems().forEachRemaining(stack -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false));
            });
        }
        return 0;
    }

    private int setupDevWorld(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        MinecraftServer srv = player.m_20194_();
        ServerLevel level = player.m_183503_();
        GameRules rules = level.m_46469_();
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46140_)).m_46246_(false, srv);
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46150_)).m_46246_(false, srv);
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46134_)).m_46246_(false, srv);
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46131_)).m_46246_(false, srv);
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46125_)).m_46246_(false, srv);
        level.m_8615_(6000L);
        level.m_8606_(6000, 0, false, false);
        List<Entity> entities = Streams.stream((Iterable)level.m_142646_().m_142273_()).filter(entity -> !(entity instanceof Player)).toList();
        entities.forEach(entity -> entity.m_142467_(Entity.RemovalReason.DISCARDED));
        return 0;
    }

    private int testApplyEtching(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_() || !(held.m_41720_() instanceof VaultGearItem)) {
            player.m_6352_((Component)new TextComponent("Not holding VaultGear item"), Util.f_137441_);
            return 0;
        }
        ResourceLocation etchingKey = ResourceLocationArgument.m_107011_(context, (String)"etching");
        EtchingSet<?> etchingSet = EtchingRegistry.getEtchingSet(etchingKey);
        if (etchingSet == null) {
            player.m_6352_((Component)new TextComponent("Unknown etching set: " + etchingKey), Util.f_137441_);
            return 0;
        }
        VaultGearData data = VaultGearData.read(held);
        data.updateAttribute(ModGearAttributes.ETCHING, etchingSet);
        data.write(held);
        return 0;
    }

    private int testGiveAllTrinkets(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        for (TrinketEffect<?> trinket : TrinketEffectRegistry.getOrderedEntries()) {
            EntityHelper.giveItem((Player)player, TrinketItem.createRandomTrinket(trinket));
        }
        return 0;
    }

    private int testGiveAllEtchings(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        for (EtchingSet<?> set : EtchingRegistry.getOrderedEntries()) {
            EntityHelper.giveItem((Player)player, EtchingItem.createEtchingStack(set));
        }
        return 0;
    }

    private int kickFromVault(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        ServerLevel world = player.m_183503_();
        ServerVaults.get((Level)world).ifPresent(vault -> vault.ifPresent(Vault.LISTENERS, listeners -> {
            Listener listener = listeners.get(player.m_142081_());
            listeners.remove((VirtualWorld)world, (Vault)vault, listener);
            vault.ifPresent(Vault.STATS, collector -> {
                StatCollector stats = collector.get(listener.get(Listener.ID));
                stats.set(StatCollector.COMPLETION, Completion.BAILED);
            });
        }));
        return 0;
    }

    private int random20Subs(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        MinecraftServer server = player.m_20194_();
        StreamData streamData = StreamData.get(player.m_183503_());
        for (int i = 0; i < 20; ++i) {
            int randomId = MathUtilities.getRandomInt(0, 9999);
            streamData.onSub(server, player.m_142081_(), "Test" + randomId, i * 5);
        }
        return 0;
    }

    private int dumpBlockstate(CommandContext<CommandSourceStack> context, BlockPos blockPos) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel world = player.m_183503_();
        BlockState blockState = world.m_8055_(blockPos);
        VaultMod.LOGGER.info("Blockstate {} = {}", (Object)blockPos, (Object)blockState);
        player.m_6352_((Component)new TextComponent(blockState.toString()), Util.f_137441_);
        return 0;
    }

    private int dumpItemNBT(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack heldStack = player.m_21205_();
        VaultMod.LOGGER.info("Held Stack NBT = {}", (Object)heldStack.m_41783_());
        player.m_6352_((Component)new TextComponent(heldStack.m_41783_().toString()), Util.f_137441_);
        return 0;
    }

    private int dumpVaultSizes(CommandContext<CommandSourceStack> context) {
        List<ResourceLocation> dumpLayoutKeys = Arrays.asList(DiamondRoomLayout.ID, SquareRoomLayout.ID, CircleRoomLayout.ID);
        for (ResourceLocation layoutKey : dumpLayoutKeys) {
            VaultMod.LOGGER.info("Layout: " + layoutKey.m_135815_());
            VaultRoomLayoutGenerator gen = VaultRoomLayoutRegistry.getLayoutGenerator(layoutKey);
            for (int i = 1; i < 33; i += 2) {
                gen.setSize(i);
                VaultMod.LOGGER.info("Size: " + i + " Rooms: " + gen.generateLayout().getRooms().size());
            }
        }
        return 0;
    }

    private int dumpConfigs(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String gamePath = FMLPaths.GAMEDIR.get().toString();
        String dumpPath = gamePath + File.separator + "config-dump";
        try {
            new GearModelDump().dumpToFile(dumpPath);
            new EntityAttrDump().dumpToFile(dumpPath);
            new TranslationsDump().dumpToFile(dumpPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandRuntimeException((Component)new TextComponent("Unable to dump file.."));
        }
        return 0;
    }
}

