/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import iskallia.vault.command.Command;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.VaultRoomNames;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.modifier.VaultModifierStack;
import iskallia.vault.world.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.command.EnumArgument;

public class CrystalCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_MODIFIER = (context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)VaultModifierRegistry.getAll().map(VaultModifier::getId).collect(Collectors.toList()), (SuggestionsBuilder)builder);

    @Override
    public String getName() {
        return "crystal";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"preventRandomModifiers").then(Commands.m_82129_((String)"random", (ArgumentType)BoolArgumentType.bool()).executes(this::setRollsRandom)));
        builder.then(Commands.m_82127_((String)"canTriggerInfluences").then(Commands.m_82129_((String)"trigger", (ArgumentType)BoolArgumentType.bool()).executes(this::setCanTriggerInfluences)));
        builder.then(Commands.m_82127_((String)"canGenerateTreasureRooms").then(Commands.m_82129_((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(this::canGenerateTreasureRooms)));
        builder.then(Commands.m_82127_((String)"setModifiable").then(Commands.m_82129_((String)"modifiable", (ArgumentType)BoolArgumentType.bool()).executes(this::setModifiable)));
        builder.then(Commands.m_82127_((String)"addModifier").then(Commands.m_82129_((String)"modifier", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_MODIFIER).then(Commands.m_82129_((String)"stackSize", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::addModifier))));
        builder.then(Commands.m_82127_((String)"addRoom").then(Commands.m_82129_((String)"roomKey", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::addRoom))));
        builder.then(Commands.m_82127_((String)"objectiveCount").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::setObjectiveCount)));
        builder.then(Commands.m_82127_((String)"objective").then(Commands.m_82129_((String)"crystalObjective", (ArgumentType)StringArgumentType.string()).executes(this::setObjective)));
        builder.then(Commands.m_82127_((String)"clearObjective").executes(this::clearObjective));
        builder.then(Commands.m_82127_((String)"type").then(Commands.m_82129_((String)"crystalType", (ArgumentType)EnumArgument.enumArgument(CrystalData.Type.class)).executes(this::setType)));
        builder.then(Commands.m_82127_((String)"setInstabilityCounter").then(Commands.m_82129_((String)"instabilityCounter", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setInstability)));
        builder.then(Commands.m_82127_((String)"setLevel").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::setLevel)));
    }

    private int setLevel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(context);
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        VaultCrystalItem.getData(crystal).setLevel(level);
        return 0;
    }

    private int canGenerateTreasureRooms(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        boolean generateTreasureRooms = BoolArgumentType.getBool(ctx, (String)"generate");
        data.setCanGenerateTreasureRooms(generateTreasureRooms);
        return 0;
    }

    private int setCanTriggerInfluences(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        boolean triggerInfluences = BoolArgumentType.getBool(ctx, (String)"trigger");
        data.setCanTriggerInfluences(triggerInfluences);
        return 0;
    }

    private int setRollsRandom(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        boolean randomModifiers = BoolArgumentType.getBool(ctx, (String)"random");
        data.setPreventsRandomModifiers(randomModifiers);
        return 0;
    }

    private int setModifiable(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        boolean modifiable = BoolArgumentType.getBool(ctx, (String)"modifiable");
        data.setModifiable(modifiable);
        return 0;
    }

    private int addRoom(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        String roomKey = StringArgumentType.getString(ctx, (String)"roomKey");
        if (VaultRoomNames.getName(roomKey) == null) {
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TextComponent("Unknown Room: " + roomKey), Util.f_137441_);
            return 0;
        }
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        for (int i = 0; i < amount; ++i) {
            data.addGuaranteedRoom(roomKey);
        }
        return 0;
    }

    private int addModifier(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"modifier");
        VaultModifier<?> modifier = VaultModifierRegistry.getOrDefault(id, null);
        if (modifier == null) {
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TextComponent("Unknown Modifier: " + id), Util.f_137441_);
            return 0;
        }
        int stackSize = IntegerArgumentType.getInteger(ctx, (String)"stackSize");
        data.addModifier(VaultModifierStack.of(modifier, stackSize));
        return 0;
    }

    private int setObjectiveCount(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        int count = IntegerArgumentType.getInteger(ctx, (String)"count");
        return 0;
    }

    private int clearObjective(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        return 0;
    }

    private int setObjective(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        String objectiveStr = StringArgumentType.getString(ctx, (String)"crystalObjective");
        VaultRaid.ARCHITECT_EVENT.get();
        VaultObjective objective = VaultObjective.getObjective(new ResourceLocation(objectiveStr));
        if (objective == null) {
            ((CommandSourceStack)ctx.getSource()).m_81375_().m_6352_((Component)new TextComponent("Unknown Objective: " + objectiveStr), Util.f_137441_);
            return 0;
        }
        return 0;
    }

    private int setType(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        CrystalData.Type type = (CrystalData.Type)((Object)ctx.getArgument("crystalType", CrystalData.Type.class));
        if (type != CrystalData.Type.RAFFLE) {
            data.setType(type);
        }
        return 0;
    }

    private int setInstability(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ItemStack crystal = this.getCrystal(ctx);
        CrystalData data = VaultCrystalItem.getData(crystal);
        int instabilityCounter = IntegerArgumentType.getInteger(ctx, (String)"instabilityCounter");
        data.setInstabilityCounter(instabilityCounter);
        return 0;
    }

    private ItemStack getCrystal(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held.m_41619_() || !(held.m_41720_() instanceof VaultCrystalItem)) {
            player.m_6352_((Component)new TextComponent("Not holding crystal!"), Util.f_137441_);
            throw new RuntimeException();
        }
        return held;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

