/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.objective.architect.ArchitectObjective;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import iskallia.vault.world.vault.player.VaultPlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class ArchitectCommand
extends Command {
    @Override
    public String getName() {
        return "architect";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"player_vote").then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"direction", (ArgumentType)StringArgumentType.word()).executes(this::receiveArchitectVote))));
        builder.then(Commands.m_82127_((String)"temporary_modifier").then(Commands.m_82129_((String)"sender", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(this::addRandomModifier))));
    }

    private int addRandomModifier(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel sWorld = player.m_183503_();
        VaultRaid vault = null;
        if (vault == null) {
            return 0;
        }
        if (vault.getActiveObjective(ArchitectObjective.class).isEmpty()) {
            return 0;
        }
        String sender = StringArgumentType.getString(context, (String)"sender");
        boolean isPositive = StringArgumentType.getString(context, (String)"type").equalsIgnoreCase("positive");
        VaultModifier modifier = isPositive ? ModConfigs.ARCHITECT_EVENT.getRandomPositiveModifier() : ModConfigs.ARCHITECT_EVENT.getRandomNegativeModifier();
        int minutes = ModConfigs.ARCHITECT_EVENT.getTemporaryModifierMinutes();
        MutableComponent ct = new TextComponent(sender).m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_(modifier.getNameComponent()).m_7220_((Component)new TextComponent(" for ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(minutes + " minutes!").m_130940_(ChatFormatting.GOLD));
        vault.getModifiers().addTemporaryModifier(modifier, 1, minutes * 60 * 20);
        vault.getPlayers().forEach(arg_0 -> ArchitectCommand.lambda$addRandomModifier$1(player, (Component)ct, arg_0));
        return 0;
    }

    private int receiveArchitectVote(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String sender = StringArgumentType.getString(context, (String)"sender");
        String directionString = StringArgumentType.getString(context, (String)"direction");
        Direction dir = Direction.m_122402_((String)directionString);
        if (dir == null) {
            return 0;
        }
        VaultRaid vault = null;
        if (vault == null) {
            return 0;
        }
        vault.getActiveObjective(ArchitectObjective.class).ifPresent(objective -> objective.handleVote(sender, dir));
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    private static /* synthetic */ void lambda$addRandomModifier$1(ServerPlayer player, Component ct, VaultPlayer vPlayer) {
        vPlayer.runIfPresent(player.m_20194_(), sPlayer -> sPlayer.m_6352_(ct, Util.f_137441_));
    }
}

