/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.command.Command;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class AbilityCommand
extends Command {
    @Override
    public String getName() {
        return "ability";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"reset_specializations").executes(this::resetSpecializations));
    }

    private int resetSpecializations(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerAbilitiesData data = PlayerAbilitiesData.get(player.m_183503_());
        AbilityTree abilities = data.getAbilities((Player)player);
        for (AbilityNode<?, ?> node : abilities.getLearnedNodes()) {
            data.selectSpecialization(player, node, null);
        }
        player.m_6352_((Component)new TextComponent("Success").m_130940_(ChatFormatting.GREEN), Util.f_137441_);
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }
}

