/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.vault.goal;

import iskallia.vault.client.gui.overlay.goal.ActiveRaidOverlay;
import iskallia.vault.client.gui.overlay.goal.BossBarOverlay;
import iskallia.vault.client.vault.goal.VaultGoalData;
import iskallia.vault.network.message.VaultGoalMessage;
import iskallia.vault.world.vault.logic.objective.VaultModifierVotingSession;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;

public class ActiveRaidGoalData
extends VaultGoalData {
    private int wave;
    private int totalWaves;
    private int aliveMobs;
    private int totalMobs;
    private int tickWaveDelay;
    private int raidsCompleted;
    private int targetRaids;
    private List<Component> positives = new ArrayList<Component>();
    private List<Component> negatives = new ArrayList<Component>();
    private VaultModifierVotingSession session;

    @Override
    @Nullable
    public BossBarOverlay getBossBarOverlay() {
        return new ActiveRaidOverlay(this);
    }

    public int getWave() {
        return this.wave;
    }

    public int getTotalWaves() {
        return this.totalWaves;
    }

    public int getAliveMobs() {
        return this.aliveMobs;
    }

    public int getTotalMobs() {
        return this.totalMobs;
    }

    public int getTickWaveDelay() {
        return this.tickWaveDelay;
    }

    public int getRaidsCompleted() {
        return this.raidsCompleted;
    }

    public int getTargetRaids() {
        return this.targetRaids;
    }

    public List<Component> getPositives() {
        return this.positives;
    }

    public List<Component> getNegatives() {
        return this.negatives;
    }

    @Nullable
    public VaultModifierVotingSession getVotingSession() {
        return this.session;
    }

    @Override
    public void receive(VaultGoalMessage pkt) {
        CompoundTag tag = pkt.payload;
        this.wave = tag.m_128451_("wave");
        this.totalWaves = tag.m_128451_("totalWaves");
        this.aliveMobs = tag.m_128451_("aliveMobs");
        this.totalMobs = tag.m_128451_("totalMobs");
        this.tickWaveDelay = tag.m_128451_("tickWaveDelay");
        this.raidsCompleted = tag.m_128451_("completedRaids");
        this.targetRaids = tag.m_128451_("targetRaids");
        ListTag positives = tag.m_128437_("positives", 8);
        this.positives = new ArrayList<Component>();
        for (int i = 0; i < positives.size(); ++i) {
            this.positives.add((Component)Component.Serializer.m_130701_((String)positives.m_128778_(i)));
        }
        ListTag negatives = tag.m_128437_("negatives", 8);
        this.negatives = new ArrayList<Component>();
        for (int i = 0; i < negatives.size(); ++i) {
            this.negatives.add((Component)Component.Serializer.m_130701_((String)negatives.m_128778_(i)));
        }
        if (tag.m_128425_("votingSession", 10)) {
            this.session = VaultModifierVotingSession.deserialize(tag.m_128469_("votingSession"));
        }
    }
}

