/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.vault;

import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientVaultRaidData;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.VaultOverlayMessage;
import iskallia.vault.world.data.ServerVaults;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VaultMusicHandler {
    public static final int PANIC_TICKS_THRESHOLD = 600;
    public static SimpleSoundInstance panicSound;
    public static SimpleSoundInstance ambientLoop;
    public static SimpleSoundInstance ambientSound;
    public static SimpleSoundInstance bossLoop;
    public static boolean playBossMusic;
    private static int ticksBeforeAmbientSound;

    public static void startBossLoop() {
        if (bossLoop != null) {
            VaultMusicHandler.stopBossLoop();
        }
        bossLoop = SimpleSoundInstance.m_119745_((SoundEvent)ModSounds.VAULT_BOSS_LOOP);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)bossLoop);
    }

    public static void stopBossLoop() {
        if (bossLoop != null) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)bossLoop);
            bossLoop = null;
        }
        playBossMusic = false;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        boolean inArena;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        SoundManager sh = mc.m_91106_();
        if (mc.f_91073_ == null) {
            VaultMusicHandler.stopBossLoop();
            return;
        }
        boolean inVault = ServerVaults.isVaultWorld((Level)mc.f_91073_);
        boolean bl = inArena = mc.f_91073_.m_46472_() == VaultMod.ARENA_KEY;
        if (!inVault && !inArena) {
            VaultMusicHandler.stopBossLoop();
            return;
        }
        VaultOverlayMessage.OverlayType type = ClientVaultRaidData.getOverlayType();
        if (type != VaultOverlayMessage.OverlayType.VAULT || !ClientVaultRaidData.showTimer()) {
            return;
        }
        int remainingTicks = ClientVaultRaidData.getRemainingTicks();
        if (remainingTicks < 600) {
            panicSound = VaultMusicHandler.playNotActive(panicSound, () -> SimpleSoundInstance.m_119752_((SoundEvent)ModSounds.TIMER_PANIC_TICK_SFX, (float)(2.0f - (float)remainingTicks / 600.0f)));
        }
        if (!ClientVaultRaidData.isInBossFight()) {
            VaultMusicHandler.stopBossLoop();
        } else if (!sh.m_120403_((SoundInstance)bossLoop)) {
            VaultMusicHandler.startBossLoop();
        }
        if (ClientVaultRaidData.isInBossFight()) {
            VaultMusicHandler.stopSound(ambientLoop);
        } else {
            ambientLoop = VaultMusicHandler.playNotActive(ambientLoop, () -> SimpleSoundInstance.m_119745_((SoundEvent)ModSounds.VAULT_AMBIENT_LOOP));
        }
        if (ticksBeforeAmbientSound < 0) {
            ambientSound = VaultMusicHandler.playNotActive(ambientSound, () -> {
                ticksBeforeAmbientSound = 3600;
                return SimpleSoundInstance.m_119759_((SoundEvent)ModSounds.VAULT_AMBIENT);
            });
        }
        --ticksBeforeAmbientSound;
    }

    private static void stopSound(SimpleSoundInstance sound) {
        SoundManager sh = Minecraft.m_91087_().m_91106_();
        if (sound != null && sh.m_120403_((SoundInstance)sound)) {
            sh.m_120399_((SoundInstance)sound);
        }
    }

    private static SimpleSoundInstance playNotActive(@Nullable SimpleSoundInstance existing, Supplier<SimpleSoundInstance> playSound) {
        Minecraft mc = Minecraft.m_91087_();
        if (existing == null || !mc.m_91106_().m_120403_((SoundInstance)existing)) {
            existing = playSound.get();
            mc.m_91106_().m_120367_((SoundInstance)existing);
        }
        return existing;
    }
}

