/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.util.color;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ColorUtil {
    private ColorUtil() {
    }

    public static double fastPerceptualColorDistanceSquared(int[] color1, int[] color2) {
        int red1 = color1[0];
        int red2 = color2[0];
        int redMean = red1 + red2 >> 1;
        int r = red1 - red2;
        int g = color1[1] - color2[1];
        int b = color1[2] - color2[2];
        return ((512 + redMean) * r * r >> 8) + 4 * g * g + ((767 - redMean) * b * b >> 8);
    }

    public static double slowPerceptualColorDistanceSquared(int[] color1, int[] color2) {
        double colorDistance = ColorUtil.fastPerceptualColorDistanceSquared(color1, color2);
        double grey1 = (color1[0] + color1[1] + color1[2]) / 3;
        double grey2 = (color2[0] + color2[1] + color2[2]) / 3;
        double greyDistance1 = Math.abs(grey1 - (double)color1[0]) + Math.abs(grey1 - (double)color1[1]) + Math.abs(grey1 - (double)color1[2]);
        double greyDistance2 = Math.abs(grey2 - (double)color2[0]) + Math.abs(grey2 - (double)color2[1]) + Math.abs(grey2 - (double)color2[2]);
        double greyDistance = greyDistance1 - greyDistance2;
        return colorDistance + greyDistance * greyDistance / 10.0;
    }

    public static double slowPerceptualColorDistanceSquared(Color color1, Color color2) {
        int[] colorInts1 = new int[]{color1.getRed(), color1.getGreen(), color1.getBlue()};
        int[] colorInts2 = new int[]{color2.getRed(), color2.getGreen(), color2.getBlue()};
        return ColorUtil.slowPerceptualColorDistanceSquared(colorInts1, colorInts2);
    }

    public static Color blendColors(Color color1, Color color2, float color1Ratio) {
        return new Color(ColorUtil.blendColors(color1.getRGB(), color2.getRGB(), color1Ratio), true);
    }

    public static int blendColors(int color1, int color2, float color1Ratio) {
        float ratio1 = Mth.m_14036_((float)color1Ratio, (float)0.0f, (float)1.0f);
        float ratio2 = 1.0f - ratio1;
        int a1 = (color1 & 0xFF000000) >> 24;
        int r1 = (color1 & 0xFF0000) >> 16;
        int g1 = (color1 & 0xFF00) >> 8;
        int b1 = color1 & 0xFF;
        int a2 = (color2 & 0xFF000000) >> 24;
        int r2 = (color2 & 0xFF0000) >> 16;
        int g2 = (color2 & 0xFF00) >> 8;
        int b2 = color2 & 0xFF;
        int a = Mth.m_14045_((int)Math.round((float)a1 * ratio1 + (float)a2 * ratio2), (int)0, (int)255);
        int r = Mth.m_14045_((int)Math.round((float)r1 * ratio1 + (float)r2 * ratio2), (int)0, (int)255);
        int g = Mth.m_14045_((int)Math.round((float)g1 * ratio1 + (float)g2 * ratio2), (int)0, (int)255);
        int b = Mth.m_14045_((int)Math.round((float)b1 * ratio1 + (float)b2 * ratio2), (int)0, (int)255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Color overlayColor(Color base, Color overlay) {
        return new Color(ColorUtil.overlayColor(base.getRGB(), overlay.getRGB()), true);
    }

    public static int overlayColor(int base, int overlay) {
        int alpha = (base & 0xFF000000) >> 24;
        int baseR = (base & 0xFF0000) >> 16;
        int baseG = (base & 0xFF00) >> 8;
        int baseB = base & 0xFF;
        int overlayR = (overlay & 0xFF0000) >> 16;
        int overlayG = (overlay & 0xFF00) >> 8;
        int overlayB = overlay & 0xFF;
        int r = Math.round((float)baseR * ((float)overlayR / 255.0f)) & 0xFF;
        int g = Math.round((float)baseG * ((float)overlayG / 255.0f)) & 0xFF;
        int b = Math.round((float)baseB * ((float)overlayB / 255.0f)) & 0xFF;
        return alpha << 24 | r << 16 | g << 8 | b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getOverlayColor(ItemStack stack) {
        if (stack.m_41619_()) {
            return -1;
        }
        if (stack.m_41720_() instanceof BlockItem) {
            Block b = Block.m_49814_((Item)stack.m_41720_());
            if (b == Blocks.f_50016_) {
                return -1;
            }
            BlockState state = b.m_49966_();
            return Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, 0);
        }
        return Minecraft.m_91087_().getItemColors().m_92676_(stack, 0);
    }
}

