/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import iskallia.vault.core.data.key.VersionedKey;
import iskallia.vault.core.vault.VaultRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class KeyRegistrySuggestions {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final Style UNPARSED_STYLE = Style.f_131099_.m_131140_(ChatFormatting.RED);
    private static final Style LITERAL_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    private static final List<Style> ARGUMENT_STYLES = (List)Stream.of(ChatFormatting.AQUA, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE, ChatFormatting.GOLD).map(arg_0 -> ((Style)Style.f_131099_).m_131140_(arg_0)).collect(ImmutableList.toImmutableList());
    final Minecraft minecraft;
    final Screen screen;
    final EditBox input;
    final Font font;
    private final boolean commandsOnly;
    private final boolean onlyShowIfCursorPastError;
    final int lineStartOffset;
    final int suggestionLineLimit;
    final boolean anchorToBottom;
    final int fillColor;
    private final List<FormattedCharSequence> commandUsage = Lists.newArrayList();
    private int commandUsagePosition;
    private int commandUsageWidth;
    @Nullable
    private ParseResults<SharedSuggestionProvider> currentParse;
    @Nullable
    private CompletableFuture<Suggestions> pendingSuggestions;
    @Nullable
    SuggestionsList suggestions;
    private boolean allowSuggestions;
    boolean keepSuggestions;

    public KeyRegistrySuggestions(Minecraft pMinecraft, Screen pScreen, EditBox pInput, Font pFont, boolean pCommandsOnly, boolean pOnlyShowIfCursorPastError, int pLineStartOffset, int pSuggestionLineLimit, boolean pAnchorToBottom, int pFillColor) {
        this.minecraft = pMinecraft;
        this.screen = pScreen;
        this.input = pInput;
        this.font = pFont;
        this.commandsOnly = pCommandsOnly;
        this.onlyShowIfCursorPastError = pOnlyShowIfCursorPastError;
        this.lineStartOffset = pLineStartOffset;
        this.suggestionLineLimit = pSuggestionLineLimit;
        this.anchorToBottom = pAnchorToBottom;
        this.fillColor = pFillColor;
        pInput.m_94149_(this::formatChat);
    }

    public void setAllowSuggestions(boolean pAutoSuggest) {
        this.allowSuggestions = pAutoSuggest;
        if (!pAutoSuggest) {
            this.suggestions = null;
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.suggestions != null && this.suggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.screen.m_7222_() == this.input && pKeyCode == 258) {
            this.showSuggestions(true);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double pDelta) {
        return this.suggestions != null && this.suggestions.mouseScrolled(Mth.m_14008_((double)pDelta, (double)-1.0, (double)1.0));
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pMouseButton) {
        return this.suggestions != null && this.suggestions.mouseClicked((int)pMouseX, (int)pMouseY, pMouseButton);
    }

    public void showSuggestions(boolean pNarrateFirstSuggestion) {
        String value = this.input.m_94155_();
        List<Suggestion> suggestionList = VaultRegistry.TEMPLATE_POOL.getKeys().stream().map(VersionedKey::getId).map(ResourceLocation::toString).filter(id -> id.contains(value)).map(id -> new Suggestion(new StringRange(0, value.length()), id)).collect(Collectors.toList());
        if (!suggestionList.isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : suggestionList) {
                i = Math.max(i, this.font.m_92895_(suggestion.getText()));
            }
            int j = Mth.m_14045_((int)this.input.m_94211_(0), (int)0, (int)(this.input.m_94211_(0) + this.input.m_94210_() - i));
            int k = this.anchorToBottom ? this.screen.f_96544_ - 12 : this.input.f_93621_ + this.input.m_93694_() + 2;
            this.suggestions = new SuggestionsList(j, k, i, suggestionList, pNarrateFirstSuggestion);
        }
    }

    private List<Suggestion> sortSuggestions(Suggestions pSuggestions) {
        String s = this.input.m_94155_().substring(0, this.input.m_94207_());
        int i = KeyRegistrySuggestions.getLastWordIndex(s);
        String s1 = s.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (Suggestion suggestion : pSuggestions.getList()) {
            if (!suggestion.getText().startsWith(s1) && !suggestion.getText().startsWith("minecraft:" + s1)) {
                list1.add(suggestion);
                continue;
            }
            list.add(suggestion);
        }
        list.addAll(list1);
        return list;
    }

    public void updateCommandInfo() {
        String s = this.input.m_94155_();
        if (this.currentParse != null && !this.currentParse.getReader().getString().equals(s)) {
            this.currentParse = null;
        }
        if (!this.keepSuggestions) {
            this.input.m_94167_((String)null);
            this.suggestions = null;
        }
        this.commandUsage.clear();
    }

    private static int getLastWordIndex(String pText) {
        if (Strings.isNullOrEmpty((String)pText)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(pText);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    private static FormattedCharSequence getExceptionMessage(CommandSyntaxException pException) {
        Component component = ComponentUtils.m_130729_((Message)pException.getRawMessage());
        String s = pException.getContext();
        return s == null ? component.m_7532_() : new TranslatableComponent("command.context.parse_error", new Object[]{component, pException.getCursor(), s}).m_7532_();
    }

    private void updateUsageInfo() {
        this.commandUsagePosition = 0;
        this.commandUsageWidth = this.screen.f_96543_;
        if (this.commandUsage.isEmpty()) {
            this.fillNodeUsage(ChatFormatting.GRAY);
        }
        this.suggestions = null;
        if (this.allowSuggestions && this.minecraft.f_91066_.f_92037_) {
            this.showSuggestions(false);
        }
    }

    private void fillNodeUsage(ChatFormatting pFormatting) {
    }

    private FormattedCharSequence formatChat(String p_93915_, int p_93916_) {
        return this.currentParse != null ? KeyRegistrySuggestions.formatText(this.currentParse, p_93915_, p_93916_) : FormattedCharSequence.m_13714_((String)p_93915_, (Style)Style.f_131099_);
    }

    @Nullable
    static String calculateSuggestionSuffix(String pInputText, String pSuggestionText) {
        return pSuggestionText.startsWith(pInputText) ? pSuggestionText.substring(pInputText.length()) : null;
    }

    private static FormattedCharSequence formatText(ParseResults<SharedSuggestionProvider> pProvider, String pCommand, int pMaxLength) {
        int i1;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        int j = -1;
        CommandContextBuilder commandcontextbuilder = pProvider.getContext().getLastChild();
        for (ParsedArgument parsedargument : commandcontextbuilder.getArguments().values()) {
            int k;
            if (++j >= ARGUMENT_STYLES.size()) {
                j = 0;
            }
            if ((k = Math.max(parsedargument.getRange().getStart() - pMaxLength, 0)) >= pCommand.length()) break;
            int l = Math.min(parsedargument.getRange().getEnd() - pMaxLength, pCommand.length());
            if (l <= 0) continue;
            list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(i, k), (Style)LITERAL_STYLE));
            list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(k, l), (Style)ARGUMENT_STYLES.get(j)));
            i = l;
        }
        if (pProvider.getReader().canRead() && (i1 = Math.max(pProvider.getReader().getCursor() - pMaxLength, 0)) < pCommand.length()) {
            int j1 = Math.min(i1 + pProvider.getReader().getRemainingLength(), pCommand.length());
            list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(i, i1), (Style)LITERAL_STYLE));
            list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(i1, j1), (Style)UNPARSED_STYLE));
            i = j1;
        }
        list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(i), (Style)LITERAL_STYLE));
        return FormattedCharSequence.m_13722_((List)list);
    }

    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        if (this.suggestions != null) {
            this.suggestions.render(pPoseStack, pMouseX, pMouseY);
        } else {
            int i = 0;
            for (FormattedCharSequence formattedcharsequence : this.commandUsage) {
                int j = this.anchorToBottom ? this.screen.f_96544_ - 14 - 13 - 12 * i : 72 + 12 * i;
                GuiComponent.m_93172_((PoseStack)pPoseStack, (int)(this.commandUsagePosition - 1), (int)j, (int)(this.commandUsagePosition + this.commandUsageWidth + 1), (int)(j + 12), (int)this.fillColor);
                this.font.m_92744_(pPoseStack, formattedcharsequence, (float)this.commandUsagePosition, (float)(j + 2), -1);
                ++i;
            }
        }
    }

    public String getNarrationMessage() {
        return this.suggestions != null ? "\n" + this.suggestions.getNarrationMessage() : "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public class SuggestionsList {
        private final Rect2i rect;
        private final String originalContents;
        private final List<Suggestion> suggestionList;
        private int offset;
        private int current;
        private Vec2 lastMouse = Vec2.f_82462_;
        private boolean tabCycles;
        private int lastNarratedEntry;

        SuggestionsList(int p_93957_, int p_93958_, int p_93959_, List<Suggestion> p_93960_, boolean p_93961_) {
            int i = p_93957_ - 1;
            int j = KeyRegistrySuggestions.this.anchorToBottom ? p_93958_ - 3 - Math.min(p_93960_.size(), KeyRegistrySuggestions.this.suggestionLineLimit) * 12 : p_93958_;
            this.rect = new Rect2i(i, j, p_93959_ + 1, Math.min(p_93960_.size(), KeyRegistrySuggestions.this.suggestionLineLimit) * 12);
            this.originalContents = KeyRegistrySuggestions.this.input.m_94155_();
            this.lastNarratedEntry = p_93961_ ? -1 : 0;
            this.suggestionList = p_93960_;
            this.select(0);
        }

        public void render(PoseStack pPoseStack, int pMouseX, int pMouseY) {
            Message message;
            boolean flag3;
            int i = Math.min(this.suggestionList.size(), KeyRegistrySuggestions.this.suggestionLineLimit);
            int j = -5592406;
            boolean flag = this.offset > 0;
            boolean flag1 = this.suggestionList.size() > this.offset + i;
            boolean flag2 = flag || flag1;
            boolean bl = flag3 = this.lastMouse.f_82470_ != (float)pMouseX || this.lastMouse.f_82471_ != (float)pMouseY;
            if (flag3) {
                this.lastMouse = new Vec2((float)pMouseX, (float)pMouseY);
            }
            if (flag2) {
                GuiComponent.m_93172_((PoseStack)pPoseStack, (int)this.rect.m_110085_(), (int)(this.rect.m_110086_() - 1), (int)(this.rect.m_110085_() + this.rect.m_110090_()), (int)this.rect.m_110086_(), (int)KeyRegistrySuggestions.this.fillColor);
                GuiComponent.m_93172_((PoseStack)pPoseStack, (int)this.rect.m_110085_(), (int)(this.rect.m_110086_() + this.rect.m_110091_()), (int)(this.rect.m_110085_() + this.rect.m_110090_()), (int)(this.rect.m_110086_() + this.rect.m_110091_() + 1), (int)KeyRegistrySuggestions.this.fillColor);
                if (flag) {
                    for (int k = 0; k < this.rect.m_110090_(); ++k) {
                        if (k % 2 != 0) continue;
                        GuiComponent.m_93172_((PoseStack)pPoseStack, (int)(this.rect.m_110085_() + k), (int)(this.rect.m_110086_() - 1), (int)(this.rect.m_110085_() + k + 1), (int)this.rect.m_110086_(), (int)-1);
                    }
                }
                if (flag1) {
                    for (int i1 = 0; i1 < this.rect.m_110090_(); ++i1) {
                        if (i1 % 2 != 0) continue;
                        GuiComponent.m_93172_((PoseStack)pPoseStack, (int)(this.rect.m_110085_() + i1), (int)(this.rect.m_110086_() + this.rect.m_110091_()), (int)(this.rect.m_110085_() + i1 + 1), (int)(this.rect.m_110086_() + this.rect.m_110091_() + 1), (int)-1);
                    }
                }
            }
            boolean flag4 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestionList.get(l + this.offset);
                GuiComponent.m_93172_((PoseStack)pPoseStack, (int)this.rect.m_110085_(), (int)(this.rect.m_110086_() + 12 * l), (int)(this.rect.m_110085_() + this.rect.m_110090_()), (int)(this.rect.m_110086_() + 12 * l + 12), (int)KeyRegistrySuggestions.this.fillColor);
                if (pMouseX > this.rect.m_110085_() && pMouseX < this.rect.m_110085_() + this.rect.m_110090_() && pMouseY > this.rect.m_110086_() + 12 * l && pMouseY < this.rect.m_110086_() + 12 * l + 12) {
                    if (flag3) {
                        this.select(l + this.offset);
                    }
                    flag4 = true;
                }
                KeyRegistrySuggestions.this.font.m_92750_(pPoseStack, suggestion.getText(), (float)(this.rect.m_110085_() + 1), (float)(this.rect.m_110086_() + 2 + 12 * l), l + this.offset == this.current ? -256 : -5592406);
            }
            if (flag4 && (message = this.suggestionList.get(this.current).getTooltip()) != null) {
                KeyRegistrySuggestions.this.screen.m_96602_(pPoseStack, ComponentUtils.m_130729_((Message)message), pMouseX, pMouseY);
            }
        }

        public boolean mouseClicked(int pMouseX, int pMouseY, int pMouseButton) {
            if (!this.rect.m_110087_(pMouseX, pMouseY)) {
                return false;
            }
            int i = (pMouseY - this.rect.m_110086_()) / 12 + this.offset;
            if (i >= 0 && i < this.suggestionList.size()) {
                this.select(i);
                this.useSuggestion();
            }
            return true;
        }

        public boolean mouseScrolled(double pDelta) {
            int j;
            int i = (int)(KeyRegistrySuggestions.this.minecraft.f_91067_.m_91589_() * (double)KeyRegistrySuggestions.this.minecraft.m_91268_().m_85445_() / (double)KeyRegistrySuggestions.this.minecraft.m_91268_().m_85443_());
            if (this.rect.m_110087_(i, j = (int)(KeyRegistrySuggestions.this.minecraft.f_91067_.m_91594_() * (double)KeyRegistrySuggestions.this.minecraft.m_91268_().m_85446_() / (double)KeyRegistrySuggestions.this.minecraft.m_91268_().m_85444_()))) {
                this.offset = Mth.m_14045_((int)((int)((double)this.offset - pDelta)), (int)0, (int)Math.max(this.suggestionList.size() - KeyRegistrySuggestions.this.suggestionLineLimit, 0));
                return true;
            }
            return false;
        }

        public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (pKeyCode == 265) {
                this.cycle(-1);
                this.tabCycles = false;
                return true;
            }
            if (pKeyCode == 264) {
                this.cycle(1);
                this.tabCycles = false;
                return true;
            }
            if (pKeyCode == 258) {
                if (this.tabCycles) {
                    this.cycle(Screen.m_96638_() ? -1 : 1);
                }
                this.useSuggestion();
                return true;
            }
            if (pKeyCode == 256) {
                this.hide();
                return true;
            }
            return false;
        }

        public void cycle(int pChange) {
            this.select(this.current + pChange);
            int i = this.offset;
            int j = this.offset + KeyRegistrySuggestions.this.suggestionLineLimit - 1;
            if (this.current < i) {
                this.offset = Mth.m_14045_((int)this.current, (int)0, (int)Math.max(this.suggestionList.size() - KeyRegistrySuggestions.this.suggestionLineLimit, 0));
            } else if (this.current > j) {
                this.offset = Mth.m_14045_((int)(this.current + KeyRegistrySuggestions.this.lineStartOffset - KeyRegistrySuggestions.this.suggestionLineLimit), (int)0, (int)Math.max(this.suggestionList.size() - KeyRegistrySuggestions.this.suggestionLineLimit, 0));
            }
        }

        public void select(int pIndex) {
            this.current = pIndex;
            if (this.current < 0) {
                this.current += this.suggestionList.size();
            }
            if (this.current >= this.suggestionList.size()) {
                this.current -= this.suggestionList.size();
            }
            Suggestion suggestion = this.suggestionList.get(this.current);
            KeyRegistrySuggestions.this.input.m_94167_(KeyRegistrySuggestions.calculateSuggestionSuffix(KeyRegistrySuggestions.this.input.m_94155_(), suggestion.apply(this.originalContents)));
            if (this.lastNarratedEntry != this.current) {
                NarratorChatListener.f_93311_.m_168785_(this.getNarrationMessage());
            }
        }

        public void useSuggestion() {
            Suggestion suggestion = this.suggestionList.get(this.current);
            KeyRegistrySuggestions.this.keepSuggestions = true;
            KeyRegistrySuggestions.this.input.m_94144_(suggestion.apply(this.originalContents));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            KeyRegistrySuggestions.this.input.m_94196_(i);
            KeyRegistrySuggestions.this.input.m_94208_(i);
            this.select(this.current);
            KeyRegistrySuggestions.this.keepSuggestions = false;
            this.tabCycles = true;
        }

        Component getNarrationMessage() {
            this.lastNarratedEntry = this.current;
            Suggestion suggestion = this.suggestionList.get(this.current);
            Message message = suggestion.getTooltip();
            return message != null ? new TranslatableComponent("narration.suggestion.tooltip", new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText(), message}) : new TranslatableComponent("narration.suggestion", new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText()});
        }

        public void hide() {
            KeyRegistrySuggestions.this.suggestions = null;
        }
    }
}

