/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.render.DollISTER;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.IntegrationCurios;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class DollLayerRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final PlayerModel<Player> alexMiniModel;
    private final PlayerModel<Player> steveMiniModel;

    public DollLayerRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
        EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
        this.alexMiniModel = new PlayerModel<Player>(entityModels.m_171103_(ModelLayers.f_171166_), true){

            protected Iterable<ModelPart> m_5607_() {
                return List.of(this.f_102808_, this.f_102809_);
            }
        };
        this.setModelProperties(this.alexMiniModel);
        this.steveMiniModel = new PlayerModel<Player>(entityModels.m_171103_(ModelLayers.f_171162_), false){

            protected Iterable<ModelPart> m_5607_() {
                return List.of(this.f_102808_, this.f_102809_);
            }
        };
        this.setModelProperties(this.steveMiniModel);
    }

    private void setModelProperties(PlayerModel<Player> model) {
        float rotation;
        model.f_102610_ = true;
        model.f_102814_.f_104203_ = rotation = -1.5707964f;
        model.f_102813_.f_104203_ = rotation;
        model.f_103376_.f_104203_ = rotation;
        model.f_103377_.f_104203_ = rotation;
    }

    @SubscribeEvent
    public static void on(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> DollLayerRenderer.registerDollLayer()));
    }

    private static void registerDollLayer() {
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        Map skinMap = renderManager.getSkinMap();
        for (EntityRenderer renderer : skinMap.values()) {
            if (!(renderer instanceof PlayerRenderer)) continue;
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            playerRenderer.m_115326_((RenderLayer)new DollLayerRenderer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)playerRenderer));
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack doll = IntegrationCurios.getItemFromCuriosHeadSlot((Player)player, stack -> stack.m_41720_() == ModItems.VAULT_DOLL);
        if (doll.m_41619_()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        DollISTER.getPlayerProfileTexture(minecraft, doll).ifPresent(profileTexture -> {
            ResourceLocation playerSkin = minecraft.m_91109_().m_118825_(profileTexture, MinecraftProfileTexture.Type.SKIN);
            String metadata = profileTexture.getMetadata("model");
            boolean slimSkin = metadata != null && !metadata.equals("default");
            poseStack.m_85836_();
            ((PlayerModel)this.m_117386_()).f_102808_.m_104299_(poseStack);
            ItemStack helmetItem = player.m_6844_(EquipmentSlot.HEAD);
            double offset = -1.1 - (double)(helmetItem.m_41619_() ? 0.0f : ModConfigs.VAULT_ITEMS.VAULT_DOLL.getHelmetOffset(helmetItem.m_41720_()));
            poseStack.m_85837_(0.0, offset, 0.0);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            if (slimSkin) {
                this.alexMiniModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.steveMiniModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            poseStack.m_85849_();
        });
    }
}

