/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.item.VaultDollItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraftforge.client.ForgeHooksClient;

public class DollISTER
extends BlockEntityWithoutLevelRenderer {
    public static final DollISTER INSTANCE = new DollISTER(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    private static final String UPDATING_SKIN_TAG = "updatingSkin";
    private static final String DEFAULT_SKIN_TAG = "defaultSkin";
    private final PlayerModel<Player> alexMiniModel;
    private final PlayerModel<Player> steveMiniModel;

    private DollISTER(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
        this.alexMiniModel = new PlayerModel<Player>(entityModelSet.m_171103_(ModelLayers.f_171166_), true){

            protected Iterable<ModelPart> m_5607_() {
                return List.of(this.f_102808_, this.f_102809_);
            }
        };
        this.alexMiniModel.f_102610_ = true;
        this.steveMiniModel = new PlayerModel<Player>(entityModelSet.m_171103_(ModelLayers.f_171162_), false){

            protected Iterable<ModelPart> m_5607_() {
                return List.of(this.f_102808_, this.f_102809_);
            }
        };
        this.steveMiniModel.f_102610_ = true;
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        poseStack.m_85837_(0.0, -0.5, 0.0);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean slimSkin = false;
        ResourceLocation playerSkin = DefaultPlayerSkin.m_118626_();
        Optional<MinecraftProfileTexture> pt = DollISTER.getPlayerProfileTexture(minecraft, stack);
        if (pt.isPresent()) {
            MinecraftProfileTexture profileTexture = pt.get();
            playerSkin = minecraft.m_91109_().m_118825_(profileTexture, MinecraftProfileTexture.Type.SKIN);
            String metadata = profileTexture.getMetadata("model");
            slimSkin = metadata != null && !metadata.equals("default");
        }
        ItemRenderer itemRenderer = minecraft.m_91291_();
        BakedModel model = itemRenderer.m_174264_(stack, null, (LivingEntity)minecraft.f_91074_, 0);
        boolean leftHand = minecraft.f_91074_ != null && minecraft.f_91074_.m_21206_() == stack;
        ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)model, (ItemTransforms.TransformType)transformType, (boolean)leftHand);
        if (slimSkin) {
            this.alexMiniModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.steveMiniModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static Optional<MinecraftProfileTexture> getPlayerProfileTexture(Minecraft minecraft, ItemStack stack) {
        return VaultDollItem.getPlayerGameProfile(stack).flatMap(gameProfile -> {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_(UPDATING_SKIN_TAG) || tag.m_128441_(DEFAULT_SKIN_TAG)) {
                return Optional.empty();
            }
            if (!gameProfile.getProperties().containsKey((Object)"textures")) {
                tag.m_128379_(UPDATING_SKIN_TAG, true);
                SkullBlockEntity.m_155738_((GameProfile)gameProfile, gp -> {
                    VaultDollItem.setGameProfile(stack.m_41784_(), gp);
                    CompoundTag t = stack.m_41784_();
                    if (!gp.getProperties().containsKey((Object)"textures")) {
                        t.m_128379_(DEFAULT_SKIN_TAG, true);
                    }
                    t.m_128473_(UPDATING_SKIN_TAG);
                });
                return Optional.empty();
            }
            SkinManager skinManager = minecraft.m_91109_();
            Map skinInfo = skinManager.m_118815_(gameProfile);
            if (skinInfo.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)skinInfo.get(MinecraftProfileTexture.Type.SKIN);
                return Optional.of(profileTexture);
            }
            return Optional.empty();
        });
    }
}

