/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.util.color.ColorUtil;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public abstract class BaseFloatingCubeParticle
extends Particle {
    private static final Random rand = new Random();
    private final BlockPos originPos;
    private final float size;
    private final SpriteSet spriteSet;
    private float effectPercent = 0.0f;
    private float prevEffectPercent = 0.0f;
    private final Vec3 rotationChange;
    private Vec3 rotationDegreeAxis;
    private Vec3 prevRotationDegreeAxis = Vec3.f_82478_;

    protected BaseFloatingCubeParticle(ClientLevel world, SpriteSet spriteSet, double x, double y, double z) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.originPos = new BlockPos(x, y, z);
        this.size = 0.45f;
        Vec3 change = new Vec3((double)(rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)), (double)(rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)), (double)(rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)));
        this.rotationChange = change.m_82542_(5.0, 5.0, 5.0);
        Vec3 axis = new Vec3((double)(rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)), (double)rand.nextFloat(), (double)(rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1)));
        this.rotationDegreeAxis = axis.m_82542_(18.0, 18.0, 18.0);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        if (!this.m_107276_()) {
            return;
        }
        if (!this.isValid()) {
            this.m_107274_();
            return;
        }
        this.prevEffectPercent = this.effectPercent;
        this.effectPercent = this.isActive() ? Math.min(this.effectPercent + 0.02f, 1.0f) : Math.max(this.effectPercent - 0.01f, 0.0f);
        this.updateRotations();
    }

    private void updateRotations() {
        if (this.effectPercent > 0.0f && this.rotationChange.m_82556_() > 0.0) {
            Vec3 modify = this.rotationChange.m_82542_((double)this.effectPercent, (double)this.effectPercent, (double)this.effectPercent);
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.m_82490_(1.0);
            this.rotationDegreeAxis = this.rotationDegreeAxis.m_82549_(modify);
            this.rotationDegreeAxis = new Vec3(this.rotationDegreeAxis.m_7096_() % 360.0, this.rotationDegreeAxis.m_7098_() % 360.0, this.rotationDegreeAxis.m_7094_() % 360.0);
            if (!this.rotationDegreeAxis.m_82549_(modify).equals((Object)this.rotationDegreeAxis)) {
                this.prevRotationDegreeAxis = this.rotationDegreeAxis.m_82546_(modify);
            }
        } else {
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.m_82490_(1.0);
        }
    }

    protected abstract boolean isValid();

    protected abstract boolean isActive();

    private Vec3 getInterpolatedRotation(float partialTicks) {
        return new Vec3(Mth.m_14139_((double)partialTicks, (double)this.prevRotationDegreeAxis.m_7096_(), (double)this.rotationDegreeAxis.m_7096_()), Mth.m_14139_((double)partialTicks, (double)this.prevRotationDegreeAxis.m_7098_(), (double)this.rotationDegreeAxis.m_7098_()), Mth.m_14139_((double)partialTicks, (double)this.prevRotationDegreeAxis.m_7094_(), (double)this.rotationDegreeAxis.m_7094_()));
    }

    private double getYOffset(float partialTicks) {
        double offset = (Math.sin((double)this.effectPercent * Math.PI + 4.71238898038469) + 1.0) / 2.0;
        double offsetPrev = (Math.sin((double)this.prevEffectPercent * Math.PI + 4.71238898038469) + 1.0) / 2.0;
        return Mth.m_14139_((double)partialTicks, (double)offsetPrev, (double)offset);
    }

    public void m_5744_(VertexConsumer buffer, Camera ari, float partialTicks) {
        float effectPart = Mth.m_14179_((float)partialTicks, (float)this.prevEffectPercent, (float)this.effectPercent);
        Color color = new Color(ColorUtil.blendColors(this.getActiveColor(), 0x505050, effectPart));
        float x = (float)Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_);
        float y = (float)Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_);
        float z = (float)Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_);
        Vec3 cameraPos = ari.m_90583_();
        x = (float)((double)x - cameraPos.m_7096_());
        y = (float)((double)y - cameraPos.m_7098_());
        z = (float)((double)z - cameraPos.m_7094_());
        Vec3 iRotation = this.getInterpolatedRotation(partialTicks);
        Matrix4f offsetMatrix = new Matrix4f();
        offsetMatrix.m_27624_();
        offsetMatrix.m_27644_(Matrix4f.m_27653_((float)x, (float)((float)((double)y + 1.25 + this.getYOffset(partialTicks) * 0.4)), (float)z));
        offsetMatrix.m_27646_(Vector3f.f_122223_.m_122240_((float)iRotation.m_7096_()));
        offsetMatrix.m_27646_(Vector3f.f_122225_.m_122240_((float)iRotation.m_7098_()));
        offsetMatrix.m_27646_(Vector3f.f_122227_.m_122240_((float)iRotation.m_7094_()));
        offsetMatrix.m_27644_(Matrix4f.m_27632_((float)this.size, (float)this.size, (float)this.size));
        this.renderTexturedCube(buffer, offsetMatrix, color.getRed(), color.getGreen(), color.getBlue(), 255);
    }

    protected abstract int getActiveColor();

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    private void renderTexturedCube(VertexConsumer buf, Matrix4f offset, int r, int g, int b, int a) {
        int combinedLight = LightmapHelper.getPackedFullbrightCoords();
        TextureAtlasSprite tas = this.spriteSet.m_7102_(rand);
        float minU = tas.m_118409_();
        float minV = tas.m_118411_();
        float maxU = tas.m_118410_();
        float maxV = tas.m_118412_();
        buf.m_85982_(offset, -0.5f, -0.5f, -0.5f).m_7421_(minU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, -0.5f, -0.5f).m_7421_(maxU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, -0.5f, 0.5f).m_7421_(maxU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, -0.5f, 0.5f).m_7421_(minU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, 0.5f, 0.5f).m_7421_(minU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, 0.5f, 0.5f).m_7421_(maxU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, 0.5f, -0.5f).m_7421_(maxU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, 0.5f, -0.5f).m_7421_(minU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, -0.5f, 0.5f).m_7421_(maxU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, 0.5f, 0.5f).m_7421_(maxU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, 0.5f, -0.5f).m_7421_(minU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, -0.5f, -0.5f).m_7421_(minU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, -0.5f, -0.5f).m_7421_(maxU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, 0.5f, -0.5f).m_7421_(maxU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, 0.5f, 0.5f).m_7421_(minU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, -0.5f, 0.5f).m_7421_(minU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, -0.5f, -0.5f).m_7421_(minU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, -0.5f, -0.5f).m_7421_(maxU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, 0.5f, -0.5f).m_7421_(maxU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, 0.5f, -0.5f).m_7421_(minU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, -0.5f, 0.5f).m_7421_(minU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, -0.5f, 0.5f).m_7421_(maxU, minV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, 0.5f, 0.5f, 0.5f).m_7421_(maxU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
        buf.m_85982_(offset, -0.5f, 0.5f, 0.5f).m_7421_(minU, maxV).m_6122_(r, g, b, a).m_85969_(combinedLight).m_5752_();
    }

    public boolean shouldCull() {
        return false;
    }
}

