/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.group.AbilityGroup;
import iskallia.vault.util.MathUtilities;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

public class AbilitySelectionWidget
extends AbstractWidget {
    public static final ResourceLocation HUD_RESOURCE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");
    protected AbilityNode<?, ?> abilityNode;
    protected double angleBoundary;

    public AbilitySelectionWidget(int x, int y, AbilityNode<?, ?> abilityNode, double angleBoundary) {
        super(x, y, 24, 24, (Component)new TextComponent(abilityNode.getName()));
        this.abilityNode = abilityNode;
        this.angleBoundary = angleBoundary;
    }

    public AbilityNode<?, ?> getAbilityNode() {
        return this.abilityNode;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.f_93620_ - 12, this.f_93621_ - 12, this.f_93618_, this.f_93619_);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        float midX = (float)minecraft.m_91268_().m_85445_() / 2.0f;
        float midY = (float)minecraft.m_91268_().m_85446_() / 2.0f;
        Vec2 towardsWidget = new Vec2((float)this.f_93620_ - midX, (float)this.f_93621_ - midY);
        Vec2 towardsMouse = new Vec2((float)mouseX - midX, (float)(mouseY - (double)midY));
        double dot = towardsWidget.f_82470_ * towardsMouse.f_82470_ + towardsWidget.f_82471_ * towardsMouse.f_82471_;
        double angleBetween = Math.acos(dot / (MathUtilities.length(towardsWidget) * MathUtilities.length(towardsMouse)));
        return angleBetween < this.angleBoundary;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Rectangle bounds = this.getBounds();
        String styleKey = this.abilityNode.getSpecialization() != null ? this.abilityNode.getSpecialization() : this.abilityNode.getGroup().getParentName();
        AbilityGroup<?, ?> thisAbility = this.abilityNode.getGroup();
        int cooldown = ClientAbilityData.getCooldown(thisAbility);
        int maxCooldown = ClientAbilityData.getMaxCooldown(thisAbility);
        if (thisAbility.equals(ClientAbilityData.getSelectedAbility())) {
            RenderSystem.m_157429_((float)0.7f, (float)0.7f, (float)0.7f, (float)0.3f);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_RESOURCE);
        this.m_93228_(matrixStack, bounds.x + 1, bounds.y + 1, 28, 36, 22, 22);
        ITextureAtlas atlas = ModTextureAtlases.ABILITIES.get();
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)(bounds.x + 4), (int)(bounds.y + 4), (int)0, (int)16, (int)16, (TextureAtlasSprite)atlas.getSprite(ModConfigs.ABILITIES_GUI.getIcon(styleKey)));
        if (cooldown > 0) {
            RenderSystem.m_157429_((float)0.7f, (float)0.7f, (float)0.7f, (float)0.5f);
            float cooldownPercent = (float)cooldown / (float)maxCooldown;
            int cooldownHeight = (int)(16.0f * cooldownPercent);
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(bounds.x + 4), (int)(bounds.y + 4 + (16 - cooldownHeight)), (int)(bounds.x + 4 + 16), (int)(bounds.y + 4 + 16), (int)-1711276033);
            RenderSystem.m_69478_();
        }
        if (thisAbility.equals(ClientAbilityData.getSelectedAbility())) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_RESOURCE);
            this.m_93228_(matrixStack, bounds.x, bounds.y, 89, 13, 24, 24);
        } else if (this.m_5953_(mouseX, mouseY)) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_RESOURCE);
            this.m_93228_(matrixStack, bounds.x, bounds.y, 64 + (cooldown > 0 ? 50 : 0), 13, 24, 24);
        }
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

