/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.screen.ToolViseScreen;
import iskallia.vault.config.PaxelConfigs;
import iskallia.vault.event.InputEvents;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.paxel.PaxelItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class PaxelTooltipComponent
implements ClientTooltipComponent {
    private static final ResourceLocation TEXTURE = ToolViseScreen.TEXTURE;
    private final PaxelItem.PaxelTooltip tooltip;
    private final Map<PaxelItem.Perk, Component> advanced = new HashMap<PaxelItem.Perk, Component>();

    public PaxelTooltipComponent(PaxelItem.PaxelTooltip tooltip) {
        this.tooltip = tooltip;
        this.tooltip.perks.forEach(perk -> this.advanced.put((PaxelItem.Perk)((Object)perk), (Component)new TextComponent(ModConfigs.PAXEL_CONFIGS.getPerkUpgrade((PaxelItem.Perk)((Object)perk)).getAdvancedTooltip()).m_130940_(ChatFormatting.DARK_GRAY)));
    }

    public int m_142103_() {
        return 20 + 18 * this.tooltip.perks.size();
    }

    public int m_142069_(Font font) {
        int width = 56;
        float[] statValues = this.tooltip.statValues;
        for (int i = 0; i < statValues.length; ++i) {
            float statValue = statValues[i];
            PaxelItem.Stat stat = this.tooltip.stats[i];
            PaxelConfigs.Upgrade upgradeCfg = ModConfigs.PAXEL_CONFIGS.getUpgrade(stat);
            String valueStr = upgradeCfg.formatValue(statValue);
            width += font.m_92895_(valueStr) + 2;
        }
        int perkMax = 16;
        int max = 0;
        for (Map.Entry<PaxelItem.Perk, Component> entry : this.advanced.entrySet()) {
            TextComponent cmp = new TextComponent(entry.getKey().m_7912_());
            if (InputEvents.isShiftDown()) {
                cmp.m_130946_(" ").m_7220_(entry.getValue());
            }
            max = Math.max(max, font.m_92852_((FormattedText)cmp));
        }
        return Math.max(width, perkMax + max);
    }

    public void m_183452_(Font font, int x, int y, PoseStack poseStack, ItemRenderer ir, int zLevel) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)zLevel);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int uStat = 0;
        int vStat = 218;
        int xOffsetStat = x;
        int widthHeight = 14;
        float[] statValues = this.tooltip.statValues;
        for (int i = 0; i < statValues.length; ++i) {
            float statValue = statValues[i];
            PaxelItem.Stat stat = this.tooltip.stats[i];
            PaxelConfigs.Upgrade upgradeCfg = ModConfigs.PAXEL_CONFIGS.getUpgrade(stat);
            String valueStr = upgradeCfg.formatValue(statValue);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)xOffsetStat, (int)y, (int)widthHeight, (int)widthHeight, (float)uStat, (float)vStat, (int)widthHeight, (int)widthHeight, (int)256, (int)256);
            uStat += 14;
            TextComponent text = new TextComponent(valueStr);
            font.m_92889_(poseStack, (Component)text, (float)(xOffsetStat += widthHeight), (float)(y + 4), -1);
            xOffsetStat += font.m_92852_((FormattedText)text) + 2;
        }
        int uPerk = 0;
        int vPerk = 232;
        boolean shift = InputEvents.isShiftDown();
        for (PaxelItem.Perk perk : this.tooltip.perks) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)(y += 16), (int)widthHeight, (int)widthHeight, (float)(uPerk + widthHeight * perk.ordinal()), (float)vPerk, (int)widthHeight, (int)widthHeight, (int)256, (int)256);
            MutableComponent perkText = new TextComponent(perk.m_7912_()).m_130948_(Style.f_131099_.m_178520_(ModConfigs.PAXEL_CONFIGS.getPerkUpgrade(perk).getColor()));
            if (shift) {
                perkText.m_130946_(" ").m_7220_(this.advanced.get((Object)perk));
            }
            font.m_92889_(poseStack, (Component)perkText, (float)(x + 2 + widthHeight), (float)(y + 4), -1);
        }
        poseStack.m_85849_();
    }
}

