/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.ScalableItemElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.summary.VaultEndScreen;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.VaultRarity;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public class VaultChestIconElement<E extends VaultChestIconElement<E>>
extends ContainerElement<E> {
    private static final int WIDTH = 111;
    private static final int HEIGHT = 53;

    public VaultChestIconElement(IPosition position, TextureAtlasRegion icon, Component name, int totalChests, int omegaChests, int epicChests, int rareChests, int commonChests, int trappedChests, VaultChestType vaultChestType) {
        super(Spatials.positionXYZ(position).size(111, 53));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(5, 0, 3).size(24, 24), ScreenTextures.VAULT_EXIT_ELEMENT_ICON).layout((screen, gui, parent, world) -> world.size(24, 24)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(0, 2, 2).size(111, 20), ScreenTextures.VAULT_EXIT_ELEMENT_TITLE).layout((screen, gui, parent, world) -> world.size(111, 20)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXYZ(4, 20, 1).size(103, 33), ScreenTextures.VAULT_EXIT_ELEMENT_BG).layout((screen, gui, parent, world) -> world.size(103, 33)));
        this.addElement(new TextureAtlasElement(Spatials.positionXYZ(9, 4, 5), icon));
        Map<VaultChestType, Map<VaultRarity, Float>> map = ModConfigs.VAULT_STATS.getChests();
        float xpCommonMul = map.get((Object)vaultChestType).get((Object)VaultRarity.COMMON).floatValue();
        float xpRareMul = map.get((Object)vaultChestType).get((Object)VaultRarity.RARE).floatValue();
        float xpEpicMul = map.get((Object)vaultChestType).get((Object)VaultRarity.EPIC).floatValue();
        float xpOmegaMul = map.get((Object)vaultChestType).get((Object)VaultRarity.OMEGA).floatValue();
        float xpCommon = (float)commonChests * xpCommonMul;
        float xpRare = (float)rareChests * xpRareMul;
        float xpEpic = (float)epicChests * xpEpicMul;
        float xpOmega = (float)omegaChests * xpOmegaMul;
        float totalXp = xpCommon + xpRare + xpEpic + xpOmega;
        this.addElement(new StringElement((IPosition)Spatials.positionXYZ(32, 8, 5), (ISize)Spatials.size(16, 7), () -> name, LabelTextStyle.shadow().left()));
        int width = TextBorder.DEFAULT_FONT.get().m_92895_("Total: " + totalChests);
        IMutableSpatial iMutableSpatial = Spatials.positionXYZ(9, 26, 5);
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        this.addElement(new ValueElement((IPosition)iMutableSpatial, (ISize)Spatials.size(width, 9), () -> totalChests, LabelTextStyle.shadow()));
        MutableComponent xpComponent = new TextComponent(String.format("%.1fxp", Float.valueOf(totalXp))).m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR));
        this.addElement(new StringElement((IPosition)Spatials.positionXYZ(100 - TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)xpComponent), 26, 5), (ISize)Spatials.size(TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)xpComponent), 7), () -> VaultChestIconElement.lambda$new$5((Component)xpComponent), LabelTextStyle.shadow()));
        this.addElement((ChestTypeValueElement)new ChestTypeValueElement(Spatials.positionXYZ(15 - TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(omegaChests)) / 2, 39, 5), Spatials.size(TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(omegaChests)), 7), () -> omegaChests, LabelTextStyle.shadow(), VaultRarity.OMEGA.color).tooltip(() -> new TextComponent("Omega").m_130940_(VaultRarity.OMEGA.color).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(String.format("%.1fxp", Float.valueOf(xpOmega))).m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR)))));
        this.addElement((ChestTypeValueElement)new ChestTypeValueElement(Spatials.positionXYZ(35 - TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(epicChests)) / 2, 39, 5), Spatials.size(TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(epicChests)), 7), () -> epicChests, LabelTextStyle.shadow(), VaultRarity.EPIC.color).tooltip(() -> new TextComponent("Epic").m_130940_(VaultRarity.EPIC.color).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(String.format("%.1fxp", Float.valueOf(xpEpic))).m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR)))));
        this.addElement((ChestTypeValueElement)new ChestTypeValueElement(Spatials.positionXYZ(55 - TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(rareChests)) / 2, 39, 5), Spatials.size(TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(rareChests)), 7), () -> rareChests, LabelTextStyle.shadow(), VaultRarity.RARE.color).tooltip(() -> new TextComponent("Rare").m_130940_(VaultRarity.RARE.color).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(String.format("%.1fxp", Float.valueOf(xpRare))).m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR)))));
        this.addElement((ChestTypeValueElement)new ChestTypeValueElement(Spatials.positionXYZ(75 - TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(commonChests)) / 2, 39, 5), Spatials.size(TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(commonChests)), 7), () -> commonChests, LabelTextStyle.shadow(), VaultRarity.COMMON.color).tooltip(() -> new TextComponent("Common").m_130940_(VaultRarity.COMMON.color).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(String.format("%.1fxp", Float.valueOf(xpCommon))).m_130948_(Style.f_131099_.m_131148_(VaultEndScreen.XP_COLOR)))));
        this.addElement((ChestTypeValueElement)new ChestTypeValueElement(Spatials.positionXYZ(95 - TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(trappedChests)) / 2, 39, 5), Spatials.size(TextBorder.DEFAULT_FONT.get().m_92895_(String.valueOf(trappedChests)), 7), () -> trappedChests, LabelTextStyle.shadow(), ChatFormatting.RED).tooltip(() -> new TextComponent("Trapped").m_130940_(ChatFormatting.RED)));
    }

    protected ScalableItemElement<?> makeElementSlot(ISpatial spatial, Supplier<ItemStack> itemStack, float scale) {
        return new ScalableItemElement(spatial, itemStack, scale);
    }

    private static /* synthetic */ Component lambda$new$5(Component xpComponent) {
        return xpComponent;
    }

    private static final class StringElement
    extends DynamicLabelElement<Component, StringElement> {
        private StringElement(IPosition position, ISize size, Supplier<Component> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }
    }

    private static final class ValueElement
    extends DynamicLabelElement<Integer, ValueElement> {
        private ValueElement(IPosition position, ISize size, Supplier<Integer> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Integer value) {
            this.set((Component)new TextComponent("Total: " + value));
        }
    }

    private static final class ChestTypeValueElement
    extends DynamicLabelElement<Integer, ChestTypeValueElement> {
        Component trailingComponent;
        ChatFormatting chatFormatting;

        private ChestTypeValueElement(IPosition position, ISize size, Supplier<Integer> valueSupplier, LabelTextStyle.Builder labelTextStyle, Component trailingComponent, ChatFormatting chatFormatting) {
            super(position, size, valueSupplier, labelTextStyle);
            this.chatFormatting = chatFormatting;
            this.trailingComponent = trailingComponent;
        }

        private ChestTypeValueElement(IPosition position, ISize size, Supplier<Integer> valueSupplier, LabelTextStyle.Builder labelTextStyle, ChatFormatting chatFormatting) {
            super(position, size, valueSupplier, labelTextStyle);
            this.chatFormatting = chatFormatting;
            this.trailingComponent = new TextComponent("");
        }

        @Override
        protected void onValueChanged(Integer value) {
            this.set((Component)new TranslatableComponent(value.toString()).m_130940_(this.chatFormatting).m_7220_(this.trailingComponent));
        }
    }

    public record ValueSupplier(Supplier<Integer> favorSupplier, Supplier<Component> tooltipTitleSupplier, Supplier<List<Component>> tooltipDescriptionSupplier) {
        public static ValueSupplier of(Supplier<Integer> favorSupplier, Supplier<Component> tooltipTitleSupplier, Supplier<List<Component>> tooltipDescriptionSupplier) {
            return new ValueSupplier(favorSupplier, tooltipTitleSupplier, tooltipDescriptionSupplier);
        }
    }
}

