/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary.element;

import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.summary.VaultExitContainerScreenData;
import iskallia.vault.client.gui.screen.summary.element.VaultChestIconElement;
import iskallia.vault.client.gui.screen.summary.element.VaultXpIconElement;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.VaultRarity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class LootStatsContainerElement
extends VerticalScrollClipContainer<LootStatsContainerElement> {
    public static int VERTICAL_SPACING = 58;

    public LootStatsContainerElement(ISpatial spatial, VaultExitContainerScreenData screenData) {
        super(spatial, Padding.of(2, 0));
        this.addElement((VaultChestElement)new VaultChestElement(Spatials.positionY(3), screenData).postLayout((screen, gui, parent, world) -> {
            world.translateX((this.innerWidth() - world.width()) / 2);
            return true;
        }));
    }

    private static final class VaultChestElement
    extends ElasticContainerElement<VaultChestElement> {
        private VaultChestElement(IPosition position, VaultExitContainerScreenData screenData) {
            super(Spatials.positionXYZ(position));
            StatCollector statCollector = screenData.getStatsCollector();
            int woodenOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.OMEGA);
            int woodenEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.EPIC);
            int woodenRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.RARE);
            int woodenCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.COMMON);
            int woodenTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.WOODEN);
            int woodenTotal = woodenTrapped + woodenCommon + woodenRare + woodenEpic + woodenOmega;
            int gildedOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.OMEGA);
            int gildedEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.EPIC);
            int gildedRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.RARE);
            int gildedCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.COMMON);
            int gildedTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.GILDED);
            int gildedTotal = gildedTrapped + gildedCommon + gildedRare + gildedEpic + gildedOmega;
            int altarOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.OMEGA);
            int altarEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.EPIC);
            int altarRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.RARE);
            int altarCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.COMMON);
            int altarTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.ALTAR);
            int altarTotal = altarTrapped + altarCommon + altarRare + altarEpic + altarOmega;
            int livingOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.OMEGA);
            int livingEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.EPIC);
            int livingRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.RARE);
            int livingCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.COMMON);
            int livingTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.LIVING);
            int livingTotal = livingTrapped + livingCommon + livingRare + livingEpic + livingOmega;
            int ornateOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.OMEGA);
            int ornateEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.EPIC);
            int ornateRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.RARE);
            int ornateCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.COMMON);
            int ornateTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.ORNATE);
            int ornateTotal = ornateTrapped + ornateCommon + ornateRare + ornateEpic + ornateOmega;
            int treasureOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.OMEGA);
            int treasureEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.EPIC);
            int treasureRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.RARE);
            int treasureCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.COMMON);
            int treasureTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.TREASURE);
            int treasureTotal = treasureTrapped + treasureCommon + treasureRare + treasureEpic + treasureOmega;
            int totalOmega = woodenOmega + gildedOmega + altarOmega + livingOmega + ornateOmega + treasureOmega;
            int totalEpic = woodenEpic + gildedEpic + altarEpic + livingEpic + ornateEpic + treasureEpic;
            int totalRare = woodenRare + gildedRare + altarRare + livingRare + ornateRare + treasureRare;
            int totalCommon = woodenCommon + gildedCommon + altarCommon + livingCommon + ornateCommon + treasureCommon;
            int totalTrapped = woodenTrapped + gildedTrapped + altarTrapped + livingTrapped + ornateTrapped + treasureTrapped;
            int total = totalTrapped + totalCommon + totalRare + totalEpic + totalOmega;
            int treasureSand = 0;
            int coinPile = 0;
            Object2IntMap<ResourceLocation> group = statCollector.getMinedBlocks();
            for (Object2IntMap.Entry entry : group.object2IntEntrySet()) {
                ResourceLocation loc = (ResourceLocation)entry.getKey();
                int amount = entry.getIntValue();
                String path = loc.m_135815_();
                if (path.equals("coin_pile")) {
                    coinPile = amount;
                    continue;
                }
                if (!path.equals("treasure_sand")) continue;
                treasureSand = amount;
            }
            MutableComponent component = new TextComponent("Total Chests Looted: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(String.valueOf(total)).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent(", Trapped: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(String.valueOf(totalTrapped)).m_130940_(ChatFormatting.RED));
            MutableComponent component2 = new TextComponent("Total Coin Piles Collected: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(String.valueOf(coinPile)).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent(", Treasure Sand: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(String.valueOf(treasureSand)).m_130940_(ChatFormatting.GREEN));
            this.addElements(new ChestStringElement((IPosition)Spatials.positionXYZ(160, 4, 1), (ISize)Spatials.size(16, 7), () -> VaultChestElement.lambda$new$0((Component)component), LabelTextStyle.shadow().center()), new IElement[0]);
            Map<ResourceLocation, Float> map = ModConfigs.VAULT_STATS.getBlocksMined();
            float xpCoinPileMul = map.get(VaultMod.id("coin_pile")).floatValue();
            float xpTreasureSandMul = map.get(VaultMod.id("treasure_sand")).floatValue();
            int textWidthCoin = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent("Coin Pile").m_130946_(" x" + coinPile)) + TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent(" " + xpCoinPileMul * (float)coinPile + "xp"));
            int textWidthSand = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent("Treasure Sand").m_130946_(" x" + treasureSand)) + TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent(" " + xpTreasureSandMul * (float)treasureSand + "xp"));
            int bottomWidth = Math.max(textWidthCoin, textWidthSand);
            this.addElements(new VaultChestIconElement(Spatials.positionY(19).positionX(0), ScreenTextures.ICON_WOODEN_CHEST, (Component)new TextComponent("Wooden"), woodenTotal, woodenOmega, woodenEpic, woodenRare, woodenCommon, woodenTrapped, VaultChestType.WOODEN), new VaultChestIconElement(Spatials.positionY(19).positionX(114), ScreenTextures.ICON_LIVING_CHEST, (Component)new TextComponent("Living"), livingTotal, livingOmega, livingEpic, livingRare, livingCommon, livingTrapped, VaultChestType.LIVING), new VaultChestIconElement(Spatials.positionY(19).positionX(228), ScreenTextures.ICON_GILDED_CHEST, (Component)new TextComponent("Gilded"), gildedTotal, gildedOmega, gildedEpic, gildedRare, gildedCommon, gildedTrapped, VaultChestType.GILDED), new VaultChestIconElement(Spatials.positionY(19 + VERTICAL_SPACING).positionX(0), ScreenTextures.ICON_ORNATE_CHEST, (Component)new TextComponent("Ornate"), ornateTotal, ornateOmega, ornateEpic, ornateRare, ornateCommon, ornateTrapped, VaultChestType.ORNATE), new VaultChestIconElement(Spatials.positionY(19 + VERTICAL_SPACING).positionX(114), ScreenTextures.ICON_ALTAR_CHEST, (Component)new TextComponent("Altar"), altarTotal, altarOmega, altarEpic, altarRare, altarCommon, altarTrapped, VaultChestType.ALTAR), new VaultChestIconElement(Spatials.positionY(19 + VERTICAL_SPACING).positionX(228), ScreenTextures.ICON_TREASURE_CHEST, (Component)new TextComponent("Treasure"), treasureTotal, treasureOmega, treasureEpic, treasureRare, treasureCommon, treasureTrapped, VaultChestType.TREASURE), new VaultXpIconElement((IPosition)Spatials.positionY(38 + VERTICAL_SPACING * 2).positionX(171 - (bottomWidth + 52) / 2), ScreenTextures.ICON_COIN_STACKS, (Component)new TextComponent("Coin Pile"), bottomWidth + 52, coinPile, xpCoinPileMul * (float)coinPile), new VaultXpIconElement((IPosition)Spatials.positionY(66 + VERTICAL_SPACING * 2).positionX(171 - (bottomWidth + 52) / 2), new ItemStack((ItemLike)ModBlocks.TREASURE_SAND), (Component)new TextComponent("Treasure Sand"), bottomWidth + 52, treasureSand, xpTreasureSandMul * (float)treasureSand));
            this.addElement(new TextureAtlasElement(Spatials.positionXYZ(10, 25 + VERTICAL_SPACING * 2, 0).width(333), ScreenTextures.VAULT_EXIT_ELEMENT_HORIZONTAL_SPLITTER));
            this.addElement(new TextureAtlasElement(Spatials.positionXYZ(10, 42 + VERTICAL_SPACING * 3, 0).width(333), ScreenTextures.VAULT_EXIT_ELEMENT_HORIZONTAL_SPLITTER));
            bottomWidth = 0;
            for (Object2IntMap.Entry entry : group.object2IntEntrySet()) {
                ResourceLocation loc = (ResourceLocation)entry.getKey();
                int amount = entry.getIntValue();
                if (loc.m_135815_().equals("coin_pile") || loc.m_135815_().equals("treasure_sand")) continue;
                ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(loc));
                float xpMul = map.get(loc).floatValue();
                int textWidth = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent(amount + "x ").m_7220_(stack.m_41786_())) + TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)new TextComponent(" " + xpMul * (float)amount + "xp"));
                bottomWidth = Math.max(bottomWidth, textWidth);
            }
            int elements = 0;
            for (Object2IntMap.Entry entry : group.object2IntEntrySet()) {
                ResourceLocation loc = (ResourceLocation)entry.getKey();
                int amount = entry.getIntValue();
                if (loc.m_135815_().equals("coin_pile") || loc.m_135815_().equals("treasure_sand")) continue;
                ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(loc));
                float xpMul = map.get(loc).floatValue();
                this.addElements(new VaultXpIconElement((IPosition)Spatials.positionY(55 + VERTICAL_SPACING * 3 + 28 * elements).positionX(171 - (bottomWidth + 52) / 2), stack, stack.m_41786_(), bottomWidth + 52, amount, xpMul * (float)amount), new IElement[0]);
                ++elements;
            }
            this.addElement(new TextureAtlasElement(Spatials.positionXYZ(10, 42 + VERTICAL_SPACING * 3 + 16 + 28 * elements, 0).width(333), ScreenTextures.VAULT_EXIT_ELEMENT_HORIZONTAL_SPLITTER));
        }

        private static /* synthetic */ Component lambda$new$0(Component component) {
            return component;
        }
    }

    private static final class ChestStringElement
    extends DynamicLabelElement<Component, ChestStringElement> {
        private ChestStringElement(IPosition position, ISize size, Supplier<Component> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }
    }
}

