/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.summary;

import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderFunction;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.summary.element.StatLabelListElement;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.VaultRarity;
import iskallia.vault.util.function.Memo;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class VaultExitContainerScreenData {
    protected final VaultSnapshot snapshot;

    public VaultExitContainerScreenData(VaultSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    protected int getUnspentSkillPoints() {
        return VaultBarOverlay.unspentSkillPoints;
    }

    protected int getUnspentKnowledgePoints() {
        return VaultBarOverlay.unspentKnowledgePoints;
    }

    public VaultSnapshot getSnapshot() {
        return this.snapshot;
    }

    public float getVaultLevelPercentageWithReward(Vault vault) {
        int reward = this.getStatsCollector().getExperience(vault);
        return (float)(VaultBarOverlay.vaultExp + reward) / (float)VaultBarOverlay.tnl;
    }

    public float getVaultLevelPercentage() {
        return (float)VaultBarOverlay.vaultExp / (float)VaultBarOverlay.tnl;
    }

    public int getVaultLevel() {
        return VaultBarOverlay.vaultLevel;
    }

    protected ITooltipRenderFunction getVaultLevelTooltip() {
        return Tooltips.shift(Tooltips.multi(Memo.of(() -> List.of(new TextComponent("Vault Experience"), Tooltips.DEFAULT_HOLD_SHIFT_COMPONENT))), Tooltips.multi(() -> List.of(new TextComponent("Vault Experience"), new TextComponent("Experience: " + VaultBarOverlay.vaultExp + "/" + VaultBarOverlay.tnl).m_130940_(ChatFormatting.GRAY), new TextComponent("Level: " + VaultBarOverlay.vaultLevel).m_130940_(ChatFormatting.GRAY))));
    }

    public StatCollector getStatsCollector() {
        Vault vault = this.snapshot.getEnd();
        return vault.get(Vault.STATS).get(Minecraft.m_91087_().f_91074_.m_142081_());
    }

    public Modifiers getModifiers() {
        Vault vault = this.snapshot.getEnd();
        return vault.get(Vault.MODIFIERS);
    }

    public static List<Component> getXpReceipt(Vault vault, StatCollector statCollector, boolean shiftDown, float xpMultiplier) {
        ArrayList<Component> list = new ArrayList<Component>();
        float chestsXp = VaultExitContainerScreenData.getTotalChestsXp(statCollector);
        list.add((Component)new TextComponent("  Chests - ").m_130946_(shiftDown ? String.format("(x%.1f) %.1f xp", Float.valueOf(xpMultiplier), Float.valueOf(chestsXp)) : String.format("%.1f xp", Float.valueOf(chestsXp * xpMultiplier))));
        float minedBlocksXp = VaultExitContainerScreenData.getMinedBlocksXp(statCollector);
        list.add((Component)new TextComponent("  Mined Blocks - ").m_130946_(shiftDown ? String.format("(x%.1f) %.1f xp", Float.valueOf(xpMultiplier), Float.valueOf(minedBlocksXp)) : String.format("%.1f xp", Float.valueOf(minedBlocksXp * xpMultiplier))));
        float treasureRoomXp = VaultExitContainerScreenData.getTreasureRoomXp(statCollector);
        list.add((Component)new TextComponent("  Treasure Rooms - ").m_130946_(shiftDown ? String.format("(x%.1f) %.1f xp", Float.valueOf(xpMultiplier), Float.valueOf(treasureRoomXp)) : String.format("%.1f xp", Float.valueOf(treasureRoomXp * xpMultiplier))));
        float mobsKilledXp = VaultExitContainerScreenData.getMobsKilledXp(statCollector);
        list.add((Component)new TextComponent("  Mobs Unalived - ").m_130946_(shiftDown ? String.format("(x%.1f) %.1f xp", Float.valueOf(xpMultiplier), Float.valueOf(mobsKilledXp)) : String.format("%.1f xp", Float.valueOf(mobsKilledXp * xpMultiplier))));
        float completionXp = VaultExitContainerScreenData.getCompletionXp(vault, statCollector);
        list.add((Component)new TextComponent("  Objective - ").m_130946_(shiftDown ? String.format("(x%.1f) %.1f xp", Float.valueOf(xpMultiplier), Float.valueOf(completionXp)) : String.format("%.1f xp", Float.valueOf(completionXp * xpMultiplier))));
        return list;
    }

    public static int getChestCount(StatCollector statCollector, VaultChestType chestType, VaultRarity vaultRarity) {
        return statCollector.getLootedChests(chestType, vaultRarity);
    }

    public static int getTrappedChestCount(StatCollector statCollector, VaultChestType chestType) {
        return statCollector.getTrappedChests(chestType);
    }

    public static float getMinedBlocksXp(StatCollector statCollector) {
        float xp = 0.0f;
        Map<ResourceLocation, Float> map = ModConfigs.VAULT_STATS.getBlocksMined();
        Object2IntMap<ResourceLocation> group = statCollector.getMinedBlocks();
        for (Object2IntMap.Entry entry : group.object2IntEntrySet()) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            int amount = entry.getIntValue();
            float xpMul = map.get(loc).floatValue();
            xp += xpMul * (float)amount;
        }
        return xp;
    }

    public static float getCompletionXp(Vault vault, StatCollector statCollector) {
        return ModConfigs.VAULT_STATS.getCompletion(vault).get((Object)statCollector.getCompletion()).floatValue();
    }

    public static int getCoinPile(StatCollector statCollector) {
        int coinPile = 0;
        Object2IntMap<ResourceLocation> group = statCollector.getMinedBlocks();
        for (Object2IntMap.Entry entry : group.object2IntEntrySet()) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            int amount = entry.getIntValue();
            String path = loc.m_135815_();
            if (!path.equals("coin_pile")) continue;
            coinPile = amount;
        }
        return coinPile;
    }

    public static int getTreasureSand(StatCollector statCollector) {
        int treasureSand = 0;
        Object2IntMap<ResourceLocation> group = statCollector.getMinedBlocks();
        for (Object2IntMap.Entry entry : group.object2IntEntrySet()) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            int amount = entry.getIntValue();
            String path = loc.m_135815_();
            if (!path.equals("treasure_sand")) continue;
            treasureSand = amount;
        }
        return treasureSand;
    }

    public static int getMobsKilled(StatCollector statCollector) {
        AtomicInteger mobsKilled = new AtomicInteger();
        statCollector.getEntitiesKilled().forEach((resourceLocation, integer) -> mobsKilled.updateAndGet(v -> v + integer));
        return mobsKilled.get();
    }

    public static float getMobsKilledXp(StatCollector statCollector) {
        AtomicReference<Float> totalXp = new AtomicReference<Float>(Float.valueOf(0.0f));
        statCollector.getEntitiesKilled().forEach((resourceLocation, integer) -> {
            Map<ResourceLocation, Float> map = ModConfigs.VAULT_STATS.getMobsKilled();
            float xpMul = map.getOrDefault(resourceLocation, map.get(new ResourceLocation("default"))).floatValue();
            float xp = xpMul * (float)integer.intValue();
            totalXp.updateAndGet(v -> Float.valueOf(v.floatValue() + xp));
        });
        return totalXp.get().floatValue();
    }

    public static float getTreasureRoomXp(StatCollector statCollector) {
        return (float)statCollector.getTreasureRoomsOpened() * ModConfigs.VAULT_STATS.getTreasureRoomsOpened();
    }

    public static int getTotalChests(StatCollector statCollector) {
        int woodenOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.OMEGA);
        int woodenEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.EPIC);
        int woodenRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.RARE);
        int woodenCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.COMMON);
        int woodenTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.WOODEN);
        int gildedOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.OMEGA);
        int gildedEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.EPIC);
        int gildedRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.RARE);
        int gildedCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.COMMON);
        int gildedTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.GILDED);
        int altarOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.OMEGA);
        int altarEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.EPIC);
        int altarRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.RARE);
        int altarCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.COMMON);
        int altarTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.ALTAR);
        int livingOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.OMEGA);
        int livingEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.EPIC);
        int livingRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.RARE);
        int livingCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.COMMON);
        int livingTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.LIVING);
        int ornateOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.OMEGA);
        int ornateEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.EPIC);
        int ornateRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.RARE);
        int ornateCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.COMMON);
        int ornateTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.ORNATE);
        int treasureOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.OMEGA);
        int treasureEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.EPIC);
        int treasureRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.RARE);
        int treasureCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.COMMON);
        int treasureTrapped = VaultExitContainerScreenData.getTrappedChestCount(statCollector, VaultChestType.TREASURE);
        int totalOmega = woodenOmega + gildedOmega + altarOmega + livingOmega + ornateOmega + treasureOmega;
        int totalEpic = woodenEpic + gildedEpic + altarEpic + livingEpic + ornateEpic + treasureEpic;
        int totalRare = woodenRare + gildedRare + altarRare + livingRare + ornateRare + treasureRare;
        int totalCommon = woodenCommon + gildedCommon + altarCommon + livingCommon + ornateCommon + treasureCommon;
        int totalTrapped = woodenTrapped + gildedTrapped + altarTrapped + livingTrapped + ornateTrapped + treasureTrapped;
        int total = totalTrapped + totalCommon + totalRare + totalEpic + totalOmega;
        return total;
    }

    public static float getTotalChestsXp(StatCollector statCollector) {
        int woodenOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.OMEGA);
        int woodenEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.EPIC);
        int woodenRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.RARE);
        int woodenCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.WOODEN, VaultRarity.COMMON);
        float woodenTotal = VaultExitContainerScreenData.getXp(VaultChestType.WOODEN, woodenCommon, woodenRare, woodenEpic, woodenOmega);
        int gildedOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.OMEGA);
        int gildedEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.EPIC);
        int gildedRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.RARE);
        int gildedCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.GILDED, VaultRarity.COMMON);
        float gildedTotal = VaultExitContainerScreenData.getXp(VaultChestType.GILDED, gildedCommon, gildedRare, gildedEpic, gildedOmega);
        int altarOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.OMEGA);
        int altarEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.EPIC);
        int altarRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.RARE);
        int altarCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ALTAR, VaultRarity.COMMON);
        float altarTotal = VaultExitContainerScreenData.getXp(VaultChestType.ALTAR, altarCommon, altarRare, altarEpic, altarOmega);
        int livingOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.OMEGA);
        int livingEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.EPIC);
        int livingRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.RARE);
        int livingCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.LIVING, VaultRarity.COMMON);
        float livingTotal = VaultExitContainerScreenData.getXp(VaultChestType.LIVING, livingCommon, livingRare, livingEpic, livingOmega);
        int ornateOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.OMEGA);
        int ornateEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.EPIC);
        int ornateRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.RARE);
        int ornateCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.ORNATE, VaultRarity.COMMON);
        float ornateTotal = VaultExitContainerScreenData.getXp(VaultChestType.ORNATE, ornateCommon, ornateRare, ornateEpic, ornateOmega);
        int treasureOmega = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.OMEGA);
        int treasureEpic = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.EPIC);
        int treasureRare = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.RARE);
        int treasureCommon = VaultExitContainerScreenData.getChestCount(statCollector, VaultChestType.TREASURE, VaultRarity.COMMON);
        float treasureTotal = VaultExitContainerScreenData.getXp(VaultChestType.TREASURE, treasureCommon, treasureRare, treasureEpic, treasureOmega);
        return woodenTotal + gildedTotal + altarTotal + livingTotal + ornateTotal + treasureTotal;
    }

    public static float getXp(VaultChestType vaultChestType, int commonChests, int rareChests, int epicChests, int omegaChests) {
        Map<VaultChestType, Map<VaultRarity, Float>> map = ModConfigs.VAULT_STATS.getChests();
        float xpCommonMul = map.get((Object)vaultChestType).get((Object)VaultRarity.COMMON).floatValue();
        float xpRareMul = map.get((Object)vaultChestType).get((Object)VaultRarity.RARE).floatValue();
        float xpEpicMul = map.get((Object)vaultChestType).get((Object)VaultRarity.EPIC).floatValue();
        float xpOmegaMul = map.get((Object)vaultChestType).get((Object)VaultRarity.OMEGA).floatValue();
        float xpCommon = (float)commonChests * xpCommonMul;
        float xpRare = (float)rareChests * xpRareMul;
        float xpEpic = (float)epicChests * xpEpicMul;
        float xpOmega = (float)omegaChests * xpOmegaMul;
        float totalXp = xpCommon + xpRare + xpEpic + xpOmega;
        return totalXp;
    }

    public static float getDamageDealt(StatCollector statCollector) {
        Object2FloatMap<ResourceLocation> group = statCollector.getDamageDealt();
        float damageDealt = 0.0f;
        for (Object2FloatMap.Entry entry : group.object2FloatEntrySet()) {
            float amount = entry.getFloatValue();
            damageDealt += amount;
        }
        return damageDealt;
    }

    public static float getDamageReceived(StatCollector statCollector) {
        Object2FloatMap<ResourceLocation> group = statCollector.getDamageReceived();
        float damageReceived = 0.0f;
        for (Object2FloatMap.Entry entry : group.object2FloatEntrySet()) {
            float amount = entry.getFloatValue();
            damageReceived += amount;
        }
        return damageReceived;
    }

    public Completion getCompletion() {
        return this.getStatsCollector().getCompletion();
    }

    public String getCompletionTranslationString() {
        return "screen.the_vault." + this.getCompletion().toString().toLowerCase();
    }

    @Nonnull
    public List<StatLabelListElement.Stat<?>> getOverviewLoot() {
        Vault vault = this.snapshot.getEnd();
        Vault startVault = this.snapshot.getStart();
        StatCollector statCollector = this.getStatsCollector();
        return List.of(StatLabelListElement.Stat.ofInteger(() -> "Coin Piles Collected", () -> "Coin Piles: " + VaultExitContainerScreenData.getCoinPile(statCollector), () -> VaultExitContainerScreenData.getCoinPile(statCollector)), StatLabelListElement.Stat.ofInteger(() -> "Treasure Sand Broken", () -> "Treasure Sand: " + VaultExitContainerScreenData.getTreasureSand(statCollector), () -> VaultExitContainerScreenData.getTreasureSand(statCollector)), StatLabelListElement.Stat.ofInteger(() -> "Treasure Rooms Opened", () -> "Value: " + VaultExitContainerScreenData.getTreasureRoomXp(statCollector) + "xp", statCollector::getTreasureRoomsOpened), StatLabelListElement.Stat.ofInteger(() -> "Chests Looted", () -> "Value: " + VaultExitContainerScreenData.getTotalChestsXp(statCollector) + "xp", () -> VaultExitContainerScreenData.getTotalChests(statCollector)));
    }

    @Nonnull
    public List<StatLabelListElement.Stat<?>> getOverviewCombat() {
        Vault vault = this.snapshot.getEnd();
        Vault startVault = this.snapshot.getStart();
        StatCollector statCollector = this.getStatsCollector();
        return List.of(StatLabelListElement.Stat.ofInteger(() -> "Mobs Unalived", () -> "Value: " + VaultExitContainerScreenData.getMobsKilledXp(statCollector) + "xp", () -> VaultExitContainerScreenData.getMobsKilled(statCollector)), StatLabelListElement.Stat.ofFloat(() -> "Damage Dealt", () -> "Dealt: " + VaultExitContainerScreenData.getDamageDealt(statCollector), () -> Float.valueOf(VaultExitContainerScreenData.getDamageDealt(statCollector))), StatLabelListElement.Stat.ofFloat(() -> "Damage Received", () -> "Received: " + VaultExitContainerScreenData.getDamageReceived(statCollector), () -> Float.valueOf(VaultExitContainerScreenData.getDamageReceived(statCollector))));
    }

    @Nonnull
    public List<StatLabelListElement.Stat<?>> getOverviewGeneric() {
        Vault vault = this.snapshot.getEnd();
        Vault startVault = this.snapshot.getStart();
        float experienceMultiplier = this.getStatsCollector().getExpMultiplier();
        int endTime = vault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME);
        int startTime = startVault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME);
        return List.of(StatLabelListElement.Stat.ofLong(() -> "Vault Seed", () -> "Seed: " + (vault.get(Vault.SEED) & 0xFFFFFFFFFFFFL), () -> vault.get(Vault.SEED) & 0xFFFFFFFFFFFFL), StatLabelListElement.Stat.ofInteger(() -> "Vault Level", () -> "Level: " + vault.get(Vault.LEVEL).get(), () -> vault.get(Vault.LEVEL).get()), StatLabelListElement.Stat.ofSeconds(() -> "Time Left", () -> UIHelper.formatTimeString(vault.get(Vault.CLOCK).get(TickClock.DISPLAY_TIME)), () -> vault.get(Vault.CLOCK).get(TickClock.DISPLAY_TIME) / 20), StatLabelListElement.Stat.ofSeconds(() -> "Time Spent", () -> UIHelper.formatTimeString(endTime - startTime), () -> (endTime - startTime) / 20), StatLabelListElement.Stat.ofFloat(() -> "Experience Multiplier", () -> "Multiplier: " + String.format("%.1f", Float.valueOf(experienceMultiplier)), () -> Float.valueOf(experienceMultiplier)));
    }
}

