/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.spi;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.screen.player.AbstractSkillTabElementContainerScreen;
import iskallia.vault.client.util.TooltipUtil;
import iskallia.vault.util.MiscUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public abstract class AbstractPanRegion<S extends AbstractSkillTabElementContainerScreen<?>>
extends Screen {
    protected S parentScreen;
    protected static Map<Class<?>, Vec2> persistedTranslations = new HashMap();
    protected static Map<Class<?>, Float> persistedScales = new HashMap();
    protected final CenterButton centerButton;
    private boolean scrollable = true;
    protected Vec2 viewportTranslation;
    protected float viewportScale;
    protected boolean dragging;
    protected Vec2 grabbedPos;

    protected AbstractPanRegion(S parentScreen, Component title) {
        super(title);
        this.parentScreen = parentScreen;
        this.dragging = false;
        this.grabbedPos = new Vec2(0.0f, 0.0f);
        this.centerButton = this.createCenterButton();
    }

    @Nullable
    protected CenterButton createCenterButton() {
        return new CenterButton(0, 0, 18, 16, TextComponent.f_131282_, button -> this.loadViewportTransforms(true));
    }

    protected void loadViewportTransforms(boolean forceCenter) {
        Class<?> aClass = ((Object)((Object)this)).getClass();
        if (forceCenter || !persistedTranslations.containsKey(aClass)) {
            persistedTranslations.put(aClass, this.getCenter());
            persistedScales.put(aClass, Float.valueOf(this.clampViewportScale(0.5f)));
        }
        this.viewportTranslation = persistedTranslations.get(aClass);
        this.viewportScale = persistedScales.get(aClass).floatValue();
    }

    protected void saveViewportTransforms() {
        persistedTranslations.put(((Object)((Object)this)).getClass(), this.viewportTranslation);
        persistedScales.put(((Object)((Object)this)).getClass(), Float.valueOf(this.viewportScale));
    }

    public Rectangle getBounds() {
        return new Rectangle(30, 60, (int)((float)((AbstractSkillTabElementContainerScreen)this.parentScreen).f_96543_ * 0.55f) - 30, ((AbstractSkillTabElementContainerScreen)this.parentScreen).f_96544_ - 30 - 60);
    }

    protected void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public abstract void update();

    protected abstract Collection<? extends AbstractWidget> getWidgets();

    protected Vec2 getCenter() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (AbstractWidget widget : this.getWidgets()) {
            if (widget.f_93620_ < minX) {
                minX = widget.f_93620_;
            }
            if (widget.f_93620_ > maxX) {
                maxX = widget.f_93620_;
            }
            if (widget.f_93621_ < minY) {
                minY = widget.f_93621_;
            }
            if (widget.f_93621_ <= maxY) continue;
            maxY = widget.f_93621_;
        }
        return new Vec2((float)((minX + maxX) / -2), (float)((minY + maxY) / -2));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.centerButton != null && this.centerButton.m_6375_(mouseX, mouseY, 0)) {
            return true;
        }
        if (this.scrollable) {
            this.dragging = true;
            this.grabbedPos = new Vec2((float)mouseX, (float)mouseY);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.scrollable) {
            this.dragging = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.scrollable && this.dragging) {
            this.calculateViewportTranslation(mouseX, mouseY);
            this.grabbedPos = new Vec2((float)mouseX, (float)mouseY);
        }
    }

    protected void calculateViewportTranslation(double mouseX, double mouseY) {
        float dx = (float)(mouseX - (double)this.grabbedPos.f_82470_) / this.viewportScale;
        float dy = (float)(mouseY - (double)this.grabbedPos.f_82471_) / this.viewportScale;
        this.viewportTranslation = new Vec2(this.viewportTranslation.f_82470_ + dx, this.viewportTranslation.f_82471_ + dy);
        this.saveViewportTransforms();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean mouseScrolled = super.m_6050_(mouseX, mouseY, delta);
        if (!this.scrollable) {
            return mouseScrolled;
        }
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        double zoomingX = (mouseX - (double)midpoint.x) / (double)this.viewportScale + (double)this.viewportTranslation.f_82470_;
        double zoomingY = (mouseY - (double)midpoint.y) / (double)this.viewportScale + (double)this.viewportTranslation.f_82471_;
        int wheel = delta < 0.0 ? -1 : 1;
        double zoomTargetX = (zoomingX - (double)this.viewportTranslation.f_82470_) / (double)this.viewportScale;
        double zoomTargetY = (zoomingY - (double)this.viewportTranslation.f_82471_) / (double)this.viewportScale;
        this.viewportScale = (float)((double)this.viewportScale + 0.25 * (double)wheel * (double)this.viewportScale);
        this.viewportScale = this.clampViewportScale(this.viewportScale);
        this.viewportTranslation = new Vec2((float)(-zoomTargetX * (double)this.viewportScale + zoomingX), (float)(-zoomTargetY * (double)this.viewportScale + zoomingY));
        this.saveViewportTransforms();
        return mouseScrolled;
    }

    protected float clampViewportScale(float viewportScale) {
        return Mth.m_14036_((float)viewportScale, (float)0.5f, (float)5.0f);
    }

    public void m_7861_() {
        this.saveViewportTransforms();
    }

    public List<Runnable> renderTab(Rectangle containerBounds, PoseStack renderStack, int mouseX, int mouseY, float pTicks) {
        ArrayList<Runnable> postRender = new ArrayList<Runnable>();
        UIHelper.renderOverflowHidden(renderStack, ms -> this.renderTabBackground((PoseStack)ms, containerBounds), ms -> this.renderTabForeground((PoseStack)ms, containerBounds, mouseX, mouseY, pTicks, (List<Runnable>)postRender));
        if (this.centerButton != null) {
            if (this.centerButton.m_198029_()) {
                postRender.clear();
                postRender.add(() -> TooltipUtil.renderTooltip(renderStack, List.of(FormattedCharSequence.m_13714_((String)"Center", (Style)Style.f_131099_.m_178520_(Color.WHITE.getRGB()))), mouseX, mouseY, Integer.MAX_VALUE, Integer.MAX_VALUE));
            }
            this.centerButton.f_93620_ = containerBounds.x + containerBounds.width - 20;
            this.centerButton.f_93621_ = containerBounds.y + containerBounds.height - 16;
            this.centerButton.m_6305_(renderStack, mouseX, mouseY, pTicks);
        }
        return postRender;
    }

    public void renderTabForeground(PoseStack renderStack, Rectangle containerBounds, int mouseX, int mouseY, float pTicks, List<Runnable> postContainerRender) {
        this.m_6305_(renderStack, mouseX, mouseY, pTicks);
    }

    public void renderTabBackground(PoseStack matrixStack, Rectangle containerBounds) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.BACKGROUNDS_RESOURCE);
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, buf -> {
            float textureSize = 16.0f * this.viewportScale;
            float currentX = containerBounds.x;
            float currentY = containerBounds.y;
            float uncoveredWidth = containerBounds.width;
            float uncoveredHeight = containerBounds.height;
            while (uncoveredWidth > 0.0f) {
                while (uncoveredHeight > 0.0f) {
                    float pWidth = Math.min(textureSize, uncoveredWidth) / textureSize;
                    float pHeight = Math.min(textureSize, uncoveredHeight) / textureSize;
                    ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack, currentX, currentY, 0.0f, pWidth * textureSize, pHeight * textureSize).tex(0.31254f, 0.0f, 0.999f * pWidth / 16.0f, 0.999f * pHeight / 16.0f).draw();
                    uncoveredHeight -= textureSize;
                    currentY += textureSize;
                }
                uncoveredWidth -= textureSize;
                currentX += textureSize;
                uncoveredHeight = containerBounds.height;
                currentY = containerBounds.y;
            }
        });
    }

    public static class CenterButton
    extends Button {
        public CenterButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress, Button.f_93716_);
        }

        protected void m_7906_(@Nonnull PoseStack poseStack, @Nonnull Minecraft minecraft, int mouseX, int mouseY) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93228_(poseStack, this.f_93620_ + 1, this.f_93621_, 192, 0, 16, 16);
        }
    }
}

