/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.pan;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.screen.player.TalentsElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog.TalentDialog;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.spi.AbstractPanRegion;
import iskallia.vault.client.gui.screen.player.legacy.widget.TalentWidget;
import iskallia.vault.client.gui.screen.player.legacy.widget.connect.ConnectorWidget;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.talent.TalentTree;
import iskallia.vault.util.MiscUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class TalentPanRegion
extends AbstractPanRegion<TalentsElementContainerScreen> {
    private final Map<String, TalentWidget> talentWidgets = new HashMap<String, TalentWidget>();
    private final List<ConnectorWidget> talentConnectors = new LinkedList<ConnectorWidget>();
    private final TalentDialog talentDialog;
    private TalentWidget selectedWidget;

    public TalentPanRegion(TalentDialog talentDialog, TalentsElementContainerScreen parentScreen) {
        super(parentScreen, (Component)new TextComponent("Talents Tab"));
        this.talentDialog = talentDialog;
    }

    @Override
    protected Collection<? extends AbstractWidget> getWidgets() {
        return this.talentWidgets.values();
    }

    @Override
    public void update() {
        this.talentWidgets.clear();
        TalentTree talentTree = ((TalentsElementContainerScreen)this.parentScreen).getTalentTree();
        ModConfigs.TALENTS_GUI.getStyles().forEach((talentName, style) -> this.talentWidgets.put((String)talentName, new TalentWidget(ModConfigs.TALENTS.getByName((String)talentName), talentTree, (SkillStyle)style)));
        ModConfigs.TALENTS_GUI.getStyles().forEach((talentName, style) -> {
            TalentWidget target = this.talentWidgets.get(talentName);
            if (target == null) {
                return;
            }
            ModConfigs.SKILL_GATES.getGates().getDependencyTalents((String)talentName).forEach(dependentOn -> {
                TalentWidget source = this.talentWidgets.get(dependentOn.getParentName());
                if (source == null) {
                    return;
                }
                if (!ModConfigs.SKILL_GATES.getGates().shouldDrawArrow((String)talentName, dependentOn.getParentName())) {
                    return;
                }
                this.talentConnectors.add(new ConnectorWidget(source, target, ConnectorWidget.ConnectorType.ARROW));
            });
            ModConfigs.SKILL_GATES.getGates().getLockedByTalents((String)talentName).forEach(dependentOn -> {
                TalentWidget source = this.talentWidgets.get(dependentOn.getParentName());
                if (source == null) {
                    return;
                }
                if (!ModConfigs.SKILL_GATES.getGates().shouldDrawArrow((String)talentName, dependentOn.getParentName())) {
                    return;
                }
                ConnectorWidget widget = new ConnectorWidget(source, target, ConnectorWidget.ConnectorType.DOUBLE_ARROW);
                widget.setColor(new Color(0xAC0000));
                this.talentConnectors.add(widget);
            });
        });
        this.loadViewportTransforms(false);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        int containerMouseX = (int)((mouseX - (double)midpoint.x) / (double)this.viewportScale - (double)this.viewportTranslation.f_82470_);
        int containerMouseY = (int)((mouseY - (double)midpoint.y) / (double)this.viewportScale - (double)this.viewportTranslation.f_82471_);
        boolean talentWidgetClicked = false;
        for (TalentWidget abilityWidget : this.talentWidgets.values()) {
            if (!abilityWidget.m_5953_(containerMouseX, containerMouseY) || !abilityWidget.m_6375_(containerMouseX, containerMouseY, button)) continue;
            if (this.selectedWidget != null) {
                this.selectedWidget.deselect();
            }
            this.selectedWidget = abilityWidget;
            this.selectedWidget.select();
            this.talentDialog.setTalentGroup(this.selectedWidget.getTalentGroup());
            talentWidgetClicked = true;
            break;
        }
        return talentWidgetClicked;
    }

    @Override
    public void renderTabForeground(PoseStack renderStack, Rectangle containerBounds, int mouseX, int mouseY, float pTicks, List<Runnable> postContainerRender) {
        RenderSystem.m_69478_();
        Point2D.Float midpoint = MiscUtils.getMidpoint(this.getBounds());
        renderStack.m_85836_();
        renderStack.m_85837_((double)midpoint.x, (double)midpoint.y, 0.0);
        renderStack.m_85841_(this.viewportScale, this.viewportScale, 1.0f);
        renderStack.m_85837_((double)this.viewportTranslation.f_82470_, (double)this.viewportTranslation.f_82471_, 0.0);
        int containerMouseX = (int)(((float)mouseX - midpoint.x) / this.viewportScale - this.viewportTranslation.f_82470_);
        int containerMouseY = (int)(((float)mouseY - midpoint.y) / this.viewportScale - this.viewportTranslation.f_82471_);
        for (ConnectorWidget talentConnector : this.talentConnectors) {
            talentConnector.renderConnection(renderStack);
        }
        for (TalentWidget abilityWidget : this.talentWidgets.values()) {
            abilityWidget.renderWidget(renderStack, containerBounds, mouseX, mouseY, containerMouseX, containerMouseY, pTicks, postContainerRender);
        }
        renderStack.m_85849_();
    }
}

