/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.component.ScrollableContainer;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.TalentsElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.spi.AbstractDialog;
import iskallia.vault.client.gui.screen.player.legacy.widget.TalentWidget;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.TalentLevelMessage;
import iskallia.vault.skill.talent.TalentGroup;
import iskallia.vault.skill.talent.TalentNode;
import iskallia.vault.skill.talent.TalentTree;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class TalentDialog
extends AbstractDialog<TalentsElementContainerScreen> {
    private final TalentTree talentTree;
    private TalentGroup<?> talentGroup = null;
    private TalentWidget talentWidget = null;

    public TalentDialog(TalentTree talentTree, TalentsElementContainerScreen skillTreeScreen) {
        super(skillTreeScreen);
        this.talentTree = talentTree;
    }

    @Override
    public void update() {
        if (this.talentGroup != null) {
            int regretCost;
            SkillStyle abilityStyle = ModConfigs.TALENTS_GUI.getStyles().get(this.talentGroup.getParentName());
            this.talentWidget = new TalentWidget(this.talentGroup, this.talentTree, abilityStyle);
            this.talentWidget.setRenderPips(false);
            TalentNode<?> talentNode = this.talentTree.getNodeOf(this.talentGroup);
            Object talent = talentNode.getTalent();
            int cost = talent == null ? this.talentGroup.learningCost() : this.talentGroup.cost(talentNode.getLevel() + 1);
            int n = regretCost = talent == null ? 0 : this.talentGroup.getTalent(talentNode.getLevel()).getRegretCost();
            String levelUpText = !talentNode.isLearned() ? "Learn (" + this.talentGroup.learningCost() + ")" : (talentNode.getLevel() >= this.talentGroup.getMaxLevel() ? "Learned" : "Upgrade (" + cost + ")");
            Object regretText = !talentNode.isLearned() ? "Unlearn" : "Unlearn (" + regretCost + ")";
            this.learnButton = new Button(0, 0, 0, 0, (Component)new TextComponent(levelUpText), button -> this.upgradeAbility(), Button.f_93716_);
            this.regretButton = new Button(0, 0, 0, 0, (Component)new TextComponent((String)regretText), button -> this.unlearnAbility(), Button.f_93716_);
            this.descriptionComponent = new ScrollableContainer(this::renderDescriptions);
            boolean isLocked = ModConfigs.SKILL_GATES.getGates().isLocked(this.talentGroup, this.talentTree);
            boolean fulfillsLevelRequirement = talentNode.getLevel() >= this.talentGroup.getMaxLevel() || VaultBarOverlay.vaultLevel >= talentNode.getGroup().getTalent(talentNode.getLevel() + 1).getLevelRequirement();
            this.learnButton.f_93623_ = cost <= VaultBarOverlay.unspentSkillPoints && fulfillsLevelRequirement && !isLocked && talentNode.getLevel() < this.talentGroup.getMaxLevel();
            boolean hasDependants = false;
            if (talentNode.getLevel() == 1) {
                List<TalentGroup<?>> dependentNodes = ModConfigs.SKILL_GATES.getGates().getTalentsDependingOn(this.talentGroup.getParentName());
                for (TalentGroup<?> dependent : dependentNodes) {
                    if (!this.talentTree.getNodeOf(dependent).isLearned()) continue;
                    hasDependants = true;
                    break;
                }
            }
            this.regretButton.f_93623_ = regretCost <= VaultBarOverlay.unspentRegretPoints && talentNode.isLearned() && !isLocked && !hasDependants;
        }
    }

    public void setTalentGroup(TalentGroup<?> talentGroup) {
        this.talentGroup = talentGroup;
        this.update();
    }

    private void upgradeAbility() {
        TalentNode<?> talentNode = this.talentTree.getNodeOf(this.talentGroup);
        if (talentNode.getLevel() >= this.talentGroup.getMaxLevel()) {
            return;
        }
        if (VaultBarOverlay.vaultLevel < talentNode.getGroup().getTalent(talentNode.getLevel() + 1).getLevelRequirement()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            minecraft.f_91074_.m_5496_(talentNode.isLearned() ? ModSounds.SKILL_TREE_UPGRADE_SFX : ModSounds.SKILL_TREE_LEARN_SFX, 1.0f, 1.0f);
        }
        this.talentTree.upgradeTalent(null, talentNode);
        this.update();
        ModNetwork.CHANNEL.sendToServer((Object)new TalentLevelMessage(this.talentGroup.getParentName(), true));
    }

    private void unlearnAbility() {
        TalentNode<?> talentNode = this.talentTree.getNodeOf(this.talentGroup);
        if (!talentNode.isLearned()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            minecraft.f_91074_.m_5496_(ModSounds.SKILL_TREE_UPGRADE_SFX, 1.0f, 1.0f);
        }
        this.talentTree.downgradeTalent(null, talentNode);
        this.update();
        ModNetwork.CHANNEL.sendToServer((Object)new TalentLevelMessage(this.talentGroup.getParentName(), false));
    }

    @Override
    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85836_();
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        if (this.talentGroup == null) {
            return;
        }
        matrixStack.m_85837_((double)(this.bounds.x + 5), (double)(this.bounds.y + 5), 0.0);
        this.renderHeading(matrixStack, mouseX, mouseY, partialTicks);
        this.descriptionComponent.setBounds(this.getDescriptionsBounds());
        this.descriptionComponent.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderFooter(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderHeading(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
        SkillStyle style = ModConfigs.TALENTS_GUI.getStyles().get(this.talentGroup.getParentName());
        TalentNode talentNode = this.talentTree.getNodeByName(this.talentGroup.getParentName());
        Rectangle widgetBounds = this.talentWidget.getClickableBounds();
        UIHelper.renderContainerBorder(this, matrixStack, this.getHeadingBounds(), 14, 44, 2, 2, 2, 2, -7631989);
        String abilityName = talentNode.getGroup().getParentName();
        String subText = talentNode.getLevel() == 0 ? "Not Learned Yet" : "Level: " + talentNode.getLevel() + "/" + talentNode.getGroup().getMaxLevel();
        int gap = 5;
        matrixStack.m_85836_();
        matrixStack.m_85837_(10.0, 0.0, 0.0);
        FontHelper.drawStringWithBorder(matrixStack, abilityName, (float)(widgetBounds.width + gap), 13.0f, talentNode.getLevel() == 0 ? -1 : -1849, talentNode.getLevel() == 0 ? -16777216 : -12897536);
        FontHelper.drawStringWithBorder(matrixStack, subText, (float)(widgetBounds.width + gap), 23.0f, talentNode.getLevel() == 0 ? -1 : -1849, talentNode.getLevel() == 0 ? -16777216 : -12897536);
        matrixStack.m_85837_((double)(-style.x), (double)(-style.y), 0.0);
        matrixStack.m_85837_(widgetBounds.getWidth() / 2.0, 0.0, 0.0);
        matrixStack.m_85837_(0.0, 23.0, 0.0);
        this.talentWidget.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderDescriptions(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Rectangle renderableBounds = this.descriptionComponent.getRenderableBounds();
        TextComponent text = new TextComponent("");
        text.m_7220_((Component)ModConfigs.SKILL_DESCRIPTIONS.getDescriptionFor(this.talentGroup.getParentName()));
        text.m_130946_("\n\n").m_7220_(this.getAdditionalDescription(this.talentGroup));
        int renderedLineCount = UIHelper.renderWrappedText(matrixStack, (Component)text, renderableBounds.width, 10);
        this.descriptionComponent.setInnerHeight(renderedLineCount * 10 + 20);
        RenderSystem.m_69482_();
    }

    private Component getAdditionalDescription(TalentGroup<?> talentGroup) {
        String arrow = String.valueOf('\u25b6');
        MutableComponent costArrowTxt = new TextComponent(" " + arrow + " ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        MutableComponent lvlReqArrowTxt = new TextComponent(" " + arrow + " ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        MutableComponent txt = new TextComponent("Cost: ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x484847)));
        for (int lvl = 1; lvl <= talentGroup.getMaxLevel(); ++lvl) {
            if (lvl > 1) {
                txt.m_7220_((Component)costArrowTxt);
            }
            int cost = talentGroup.getTalent(lvl).getLearningCost();
            txt.m_7220_((Component)new TextComponent(String.valueOf(cost)).m_130940_(ChatFormatting.WHITE));
        }
        boolean displayRequirements = false;
        TextComponent lvlReq = new TextComponent("\n\nLevel requirement: ");
        for (int lvl = 1; lvl <= talentGroup.getMaxLevel(); ++lvl) {
            if (lvl > 1) {
                lvlReq.m_7220_((Component)lvlReqArrowTxt);
            }
            int levelRequirement = talentGroup.getTalent(lvl).getLevelRequirement();
            TextComponent lvlReqPart = new TextComponent(String.valueOf(levelRequirement));
            if (VaultBarOverlay.vaultLevel < levelRequirement) {
                lvlReqPart.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7E0000)));
            } else {
                lvlReqPart.m_130940_(ChatFormatting.WHITE);
            }
            lvlReq.m_7220_((Component)lvlReqPart);
            if (levelRequirement <= 0) continue;
            displayRequirements = true;
        }
        if (displayRequirements) {
            txt.m_7220_((Component)lvlReq);
        } else {
            txt.m_7220_((Component)new TextComponent("\n\nNo Level requirements"));
        }
        return txt;
    }

    private void renderFooter(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int containerX = mouseX - this.bounds.x - 5;
        int containerY = mouseY - this.bounds.y - 5;
        this.learnButton.m_6305_(matrixStack, containerX, containerY, partialTicks);
        this.regretButton.m_6305_(matrixStack, containerX, containerY, partialTicks);
    }
}

