/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.legacy.tab.split.dialog;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.component.ScrollableContainer;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.client.gui.screen.player.AbilitiesElementContainerScreen;
import iskallia.vault.client.gui.screen.player.legacy.tab.split.spi.AbstractDialog;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityNodeTextures;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityWidget;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.network.message.AbilityLevelMessage;
import iskallia.vault.network.message.AbilitySelectSpecializationMessage;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityRegistry;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.component.AbilityDescriptionFactory;
import iskallia.vault.skill.ability.config.spi.AbstractAbilityConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbstractAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class AbilityDialog
extends AbstractDialog<AbilitiesElementContainerScreen> {
    private final AbilityTree abilityTree;
    private MutableComponent descriptionContentComponent;
    private String selectedAbility = null;
    private AbilityWidget selectedAbilityWidget = null;

    public AbilityDialog(AbilityTree abilityTree, AbilitiesElementContainerScreen skillTreeScreen) {
        super(skillTreeScreen);
        this.abilityTree = abilityTree;
    }

    @Override
    public void update() {
        boolean activeState;
        Button.OnPress pressAction;
        Object buttonText;
        if (this.selectedAbility == null) {
            return;
        }
        AbstractAbility<?> ability = AbilityRegistry.getAbility(this.selectedAbility);
        if (ability == null) {
            return;
        }
        AbilityNode<?, ?> existingNode = this.abilityTree.getNodeOf(ability);
        boolean isSpecialization = !ability.getAbilityGroupName().equals(this.selectedAbility);
        this.selectedAbilityWidget = new AbilityWidget(this.selectedAbility, this.abilityTree, 0, 0, isSpecialization ? AbilityNodeTextures.SECONDARY_NODE : AbilityNodeTextures.PRIMARY_NODE, TextureAtlasRegion.of(ModTextureAtlases.ABILITIES, ModConfigs.ABILITIES_GUI.getIcon(this.selectedAbility)));
        AbilityNode<?, ?> targetAbilityNode = this.selectedAbilityWidget.makeAbilityNode();
        AbilityGroup<?, ?> targetAbilityGroup = targetAbilityNode.getGroup();
        if (targetAbilityNode.getSpecialization() != null) {
            buttonText = "Select Specialization";
            pressAction = button -> this.selectSpecialization();
            activeState = existingNode.getSpecialization() == null && existingNode.isLearned() && VaultBarOverlay.vaultLevel >= ((AbstractAbilityConfig)targetAbilityNode.getAbilityConfig()).getLevelRequirement();
            this.regretButton = null;
        } else {
            buttonText = !targetAbilityNode.isLearned() ? "Learn (" + targetAbilityGroup.learningCost() + ")" : (existingNode.getLevel() >= targetAbilityGroup.getMaxLevel() ? "Fully Learned" : "Upgrade (" + targetAbilityGroup.levelUpCost(targetAbilityNode.getSpecialization(), targetAbilityNode.getLevel()) + ")");
            pressAction = button -> this.upgradeAbility();
            Object config = targetAbilityNode.getAbilityConfig();
            int cost = config == null ? targetAbilityGroup.learningCost() : targetAbilityGroup.levelUpCost(targetAbilityNode.getSpecialization(), targetAbilityNode.getLevel());
            int regretCost = existingNode.isLearned() ? ((AbstractAbilityConfig)existingNode.getAbilityConfig()).getRegretCost() : 0;
            activeState = cost <= VaultBarOverlay.unspentSkillPoints && existingNode.getLevel() < targetAbilityGroup.getMaxLevel() && targetAbilityNode.getLevel() < targetAbilityGroup.getMaxLevel() + 1 && VaultBarOverlay.vaultLevel >= ((AbstractAbilityConfig)targetAbilityNode.getAbilityConfig()).getLevelRequirement();
            Object regretButtonText = !existingNode.isLearned() ? "Unlearn" : "Unlearn (" + regretCost + ")";
            boolean hasDependants = false;
            if (existingNode.getLevel() == 1) {
                List<AbilityGroup<?, ?>> dependentNodes = ModConfigs.SKILL_GATES.getGates().getAbilitiesDependingOn(((AbstractAbility)existingNode.getAbility()).getAbilityGroupName());
                for (AbilityGroup<?, ?> dependent : dependentNodes) {
                    if (!this.abilityTree.getNodeOf(dependent).isLearned()) continue;
                    hasDependants = true;
                    break;
                }
            }
            this.regretButton = new Button(0, 0, 0, 0, (Component)new TextComponent((String)regretButtonText), button -> this.downgradeAbility(), Button.f_93716_);
            this.regretButton.f_93623_ = existingNode.isLearned() && regretCost <= VaultBarOverlay.unspentRegretPoints && !hasDependants;
        }
        this.descriptionComponent = new ScrollableContainer(this::renderDescriptions);
        this.descriptionContentComponent = AbilityDescriptionFactory.create(existingNode.getGroup(), targetAbilityNode.getSpecialization(), existingNode.getLevel(), VaultBarOverlay.vaultLevel);
        this.learnButton = new Button(0, 0, 0, 0, (Component)new TextComponent((String)buttonText), pressAction, Button.f_93716_);
        this.learnButton.f_93623_ = activeState;
    }

    public void setAbilityWidget(String abilityName) {
        this.selectedAbility = abilityName;
        this.update();
    }

    private void upgradeAbility() {
        AbilityNode<?, ?> abilityNode = this.abilityTree.getNodeByName(AbilityRegistry.getAbility(this.selectedAbility).getAbilityGroupName());
        if (abilityNode.getLevel() >= abilityNode.getGroup().getMaxLevel()) {
            return;
        }
        Minecraft.m_91087_().f_91074_.m_5496_(abilityNode.isLearned() ? ModSounds.SKILL_TREE_UPGRADE_SFX : ModSounds.SKILL_TREE_LEARN_SFX, 1.0f, 1.0f);
        this.abilityTree.upgradeAbility(null, abilityNode);
        this.update();
        ModNetwork.CHANNEL.sendToServer((Object)new AbilityLevelMessage(abilityNode.getGroup().getParentName(), true));
    }

    private void downgradeAbility() {
        boolean isSpecialization;
        AbstractAbility<?> ability = AbilityRegistry.getAbility(this.selectedAbility);
        if (ability == null) {
            return;
        }
        boolean bl = isSpecialization = !ability.getAbilityGroupName().equals(this.selectedAbility);
        if (isSpecialization) {
            return;
        }
        AbilityNode<?, ?> abilityNode = this.abilityTree.getNodeOf(ability);
        if (!abilityNode.isLearned()) {
            return;
        }
        Minecraft.m_91087_().f_91074_.m_5496_(ModSounds.SKILL_TREE_UPGRADE_SFX, 1.0f, 1.0f);
        this.abilityTree.downgradeAbility(null, abilityNode);
        this.update();
        ModNetwork.CHANNEL.sendToServer((Object)new AbilityLevelMessage(abilityNode.getGroup().getParentName(), false));
    }

    private void selectSpecialization() {
        AbilityNode<?, ?> targetNode = this.selectedAbilityWidget.makeAbilityNode();
        AbilityNode<?, ?> existingNode = this.abilityTree.getNodeByName(AbilityRegistry.getAbility(this.selectedAbility).getAbilityGroupName());
        String toSelect = targetNode.getSpecialization();
        String abilityName = existingNode.getGroup().getParentName();
        if (existingNode.getSpecialization() != null && targetNode.getGroup().equals(existingNode.getGroup())) {
            return;
        }
        if (VaultBarOverlay.vaultLevel < ((AbstractAbilityConfig)targetNode.getAbilityConfig()).getLevelRequirement()) {
            return;
        }
        Minecraft.m_91087_().f_91074_.m_5496_(ModSounds.SKILL_TREE_UPGRADE_SFX, 1.0f, 1.0f);
        this.abilityTree.selectSpecialization(abilityName, toSelect);
        ((AbilitiesElementContainerScreen)this.skillTreeScreen).update();
        ModNetwork.CHANNEL.sendToServer((Object)new AbilitySelectSpecializationMessage(abilityName, toSelect));
    }

    @Override
    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        if (this.selectedAbility == null || this.selectedAbilityWidget == null) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(this.bounds.x + 5), (double)(this.bounds.y + 5), 0.0);
        this.renderHeading(matrixStack, mouseX, mouseY, partialTicks);
        this.descriptionComponent.setBounds(this.getDescriptionsBounds());
        this.descriptionComponent.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderFooter(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderHeading(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Object subText;
        Object abilityName;
        boolean learned;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenTextures.UI_RESOURCE);
        AbilityNode<?, ?> targetAbilityNode = this.selectedAbilityWidget.makeAbilityNode();
        AbilityNode<?, ?> currentAbilityNode = this.abilityTree.getNodeOf(targetAbilityNode.getGroup());
        if (targetAbilityNode.getSpecialization() != null) {
            learned = targetAbilityNode.getSpecialization().equals(currentAbilityNode.getSpecialization());
            abilityName = targetAbilityNode.getGroup().getParentName() + ": " + targetAbilityNode.getSpecializationName();
            subText = learned ? "Selected" : "Not selected";
        } else {
            learned = targetAbilityNode.isLearned();
            abilityName = targetAbilityNode.getGroup().getParentName();
            subText = !learned ? "Not learned yet" : "Level: " + currentAbilityNode.getLevel() + "/" + targetAbilityNode.getGroup().getMaxLevel();
        }
        int width = this.selectedAbilityWidget.m_5711_();
        UIHelper.renderContainerBorder(this, matrixStack, this.getHeadingBounds(), 14, 44, 2, 2, 2, 2, -7631989);
        int gap = 5;
        matrixStack.m_85836_();
        matrixStack.m_85837_(10.0, 0.0, 0.0);
        FontHelper.drawStringWithBorder(matrixStack, (String)abilityName, (float)(width + gap), 13.0f, !learned ? -1 : -1849, !learned ? -16777216 : -12897536);
        FontHelper.drawStringWithBorder(matrixStack, (String)subText, (float)(width + gap), 23.0f, !learned ? -1 : -1849, !learned ? -16777216 : -12897536);
        matrixStack.m_85837_((double)((float)width / 2.0f), 0.0, 0.0);
        matrixStack.m_85837_(0.0, 23.0, 0.0);
        this.selectedAbilityWidget.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85849_();
    }

    private void renderDescriptions(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Rectangle bounds = this.descriptionComponent.getRenderableBounds();
        int renderedLineCount = UIHelper.renderWrappedText(matrixStack, (Component)this.descriptionContentComponent, bounds.width, 10);
        this.descriptionComponent.setInnerHeight(renderedLineCount * 10 + 20);
        RenderSystem.m_69482_();
    }

    private void renderFooter(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int containerX = mouseX - this.bounds.x - 5;
        int containerY = mouseY - this.bounds.y - 5;
        this.learnButton.m_6305_(matrixStack, containerX, containerY, partialTicks);
        if (this.regretButton != null) {
            this.regretButton.m_6305_(matrixStack, containerX, containerY, partialTicks);
        }
    }
}

