/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.element;

import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class VaultGodFavorIconElement<E extends VaultGodFavorIconElement<E>>
extends ContainerElement<E> {
    public VaultGodFavorIconElement(IPosition position, TextureAtlasRegion textureAtlasRegion, ValueSupplier valueSupplier) {
        super(Spatials.positionXYZ(position).size(16, 16));
        this.addElement(new TextureAtlasElement(textureAtlasRegion));
        this.addElement(new ValueElement((IPosition)Spatials.positionY(9), (ISize)Spatials.size(16, 7), valueSupplier.favorSupplier, LabelTextStyle.border4().right()));
        this.tooltip(Tooltips.shift(Tooltips.multi(() -> List.of(valueSupplier.tooltipTitleSupplier.get(), Tooltips.DEFAULT_HOLD_SHIFT_COMPONENT)), Tooltips.multi(valueSupplier.tooltipDescriptionSupplier)));
    }

    private static final class ValueElement
    extends DynamicLabelElement<Integer, ValueElement> {
        private ValueElement(IPosition position, ISize size, Supplier<Integer> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Integer value) {
            if (value > 0) {
                this.set((Component)new TextComponent("+" + value));
            } else {
                this.set((Component)new TextComponent(String.valueOf(value)));
            }
        }
    }

    public record ValueSupplier(Supplier<Integer> favorSupplier, Supplier<Component> tooltipTitleSupplier, Supplier<List<Component>> tooltipDescriptionSupplier) {
        public static ValueSupplier of(Supplier<Integer> favorSupplier, Supplier<Component> tooltipTitleSupplier, Supplier<List<Component>> tooltipDescriptionSupplier) {
            return new ValueSupplier(favorSupplier, tooltipTitleSupplier, tooltipDescriptionSupplier);
        }
    }
}

