/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.element;

import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.player.element.StatLabelElement;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public class StatLabelElementBuilder<V extends Comparable<V>> {
    public static final Comparator<StatLabelElementBuilder<?>> COMPARATOR = Comparator.comparing(b -> b.labelSupplier.get());
    private static final int LABEL_HEIGHT = 11;
    private final Supplier<String> labelSupplier;
    private final Supplier<String> descriptionSupplier;
    private final Supplier<V> valueSupplier;
    private final Function<V, MutableComponent> valueFormatFunction;
    private final TextColor textColor;
    private Supplier<V> valueCapSupplier;
    private Function<V, MutableComponent> valueCapFormatFunction;
    private Supplier<V> finalValueSupplier;

    public StatLabelElementBuilder(Supplier<String> labelSupplier, Supplier<String> descriptionSupplier, Supplier<V> valueSupplier, Function<V, MutableComponent> valueFormatFunction, TextColor textColor) {
        this.labelSupplier = labelSupplier;
        this.descriptionSupplier = descriptionSupplier;
        this.valueSupplier = valueSupplier;
        this.valueFormatFunction = valueFormatFunction;
        this.textColor = textColor;
        this.finalValueSupplier = this.valueSupplier;
    }

    public StatLabelElementBuilder<V> setValueCap(Supplier<V> valueCapSupplier, Function<V, MutableComponent> valueCapFormatFunction) {
        this.valueCapSupplier = valueCapSupplier;
        this.valueCapFormatFunction = valueCapFormatFunction;
        this.finalValueSupplier = () -> ((Comparable)this.valueCapSupplier.get()).compareTo((Comparable)this.valueSupplier.get()) < 0 ? (Comparable)this.valueCapSupplier.get() : (Comparable)this.valueSupplier.get();
        return this;
    }

    private boolean isValueCapped() {
        return this.valueCapSupplier != null && ((Comparable)this.valueCapSupplier.get()).compareTo((Comparable)this.valueSupplier.get()) < 0;
    }

    public StatLabelElement<V> build(int width, int index) {
        return (StatLabelElement)((StatLabelElement)new StatLabelElement<V>(ISpatial.ZERO, Spatials.size(width, 11), this.labelSupplier, this.finalValueSupplier, this.valueFormatFunction, LabelTextStyle.defaultStyle(), this.textColor, () -> this.isValueCapped() ? TextColor.m_131266_((int)14898260) : this.textColor).layout((screen, gui, parent, world) -> world.translateY(index * 11).width(parent))).tooltip(Tooltips.shift(Tooltips.multi(() -> List.of(new TextComponent(this.labelSupplier.get()), Tooltips.DEFAULT_HOLD_SHIFT_COMPONENT)), Tooltips.multi(() -> {
            if (this.isValueCapped()) {
                return List.of(new TextComponent(this.labelSupplier.get()), this.buildCapDescription(this.valueFormatFunction.apply((Comparable)this.valueSupplier.get()), this.valueCapFormatFunction.apply((Comparable)this.valueCapSupplier.get())), new TextComponent(this.descriptionSupplier.get()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
            }
            return List.of(new TextComponent(this.labelSupplier.get()), new TextComponent(this.descriptionSupplier.get()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA))));
        })));
    }

    private Component buildCapDescription(MutableComponent value, MutableComponent valueCap) {
        return new TextComponent("Stat value of ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA))).m_7220_((Component)value.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x47CC47)))).m_7220_((Component)new TextComponent(" capped at ").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA)))).m_7220_((Component)valueCap.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14898260))));
    }
}

