/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.player.element;

import iskallia.vault.client.gui.screen.player.element.StatLabelElement;
import iskallia.vault.client.gui.screen.player.element.StatLabelElementBuilder;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import java.util.function.Function;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public final class GearAttributeStatLabel {
    public static StatLabelElementBuilder<Integer> ofInteger(Player player, VaultGearAttribute<Integer> attribute) {
        return GearAttributeStatLabel.of(player, attribute, VaultGearAttributeTypeMerger.intSum());
    }

    public static StatLabelElementBuilder<Double> ofDouble(Player player, VaultGearAttribute<Double> attribute) {
        return GearAttributeStatLabel.of(player, attribute, VaultGearAttributeTypeMerger.doubleSum());
    }

    public static StatLabelElementBuilder<Float> ofFloat(Player player, VaultGearAttribute<Float> attribute) {
        return GearAttributeStatLabel.of(player, attribute, VaultGearAttributeTypeMerger.floatSum());
    }

    public static StatLabelElementBuilder<Float> ofFloat(Player player, VaultGearAttribute<Float> attribute, Function<Player, Float> attributeCapSupplier) {
        return GearAttributeStatLabel.of(player, attribute, VaultGearAttributeTypeMerger.floatSum()).setValueCap(() -> (Float)attributeCapSupplier.apply(player), value -> attribute.getReader().getValueDisplay((Float)value));
    }

    public static StatLabelElementBuilder<Boolean> ofBoolean(Player player, VaultGearAttribute<Boolean> attribute) {
        return GearAttributeStatLabel.of(player, attribute, VaultGearAttributeTypeMerger.anyTrue(), StatLabelElement.BOOLEAN_FORMATTER);
    }

    public static <V extends Comparable<V>> StatLabelElementBuilder<V> of(Player player, VaultGearAttribute<V> attribute, Function<Player, V> valueSupplier) {
        return GearAttributeStatLabel.of(player, attribute, valueSupplier, (V value) -> attribute.getReader().getValueDisplay((Comparable)value));
    }

    private static <V extends Comparable<V>> StatLabelElementBuilder<V> of(Player player, VaultGearAttribute<V> attribute, VaultGearAttributeTypeMerger<V, V> attributeTypeMerger) {
        return GearAttributeStatLabel.of(player, attribute, attributeTypeMerger, (V value) -> attribute.getReader().getValueDisplay((Comparable)value));
    }

    private static <V extends Comparable<V>> StatLabelElementBuilder<V> of(Player player, VaultGearAttribute<V> attribute, VaultGearAttributeTypeMerger<V, V> attributeTypeMerger, Function<V, MutableComponent> valueFormatFunction) {
        return new StatLabelElementBuilder<Comparable>(() -> attribute.getReader().getModifierName(), () -> ModConfigs.MENU_PLAYER_STAT_DESCRIPTIONS.getModGearAttributeDescriptionFor(attribute.getRegistryName()), () -> (Comparable)AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player).getAttributeValue(attribute, attributeTypeMerger), valueFormatFunction, TextColor.m_131266_((int)0));
    }

    private static <V extends Comparable<V>> StatLabelElementBuilder<V> of(Player player, VaultGearAttribute<V> attribute, Function<Player, V> valueSupplier, Function<V, MutableComponent> valueFormatFunction) {
        return new StatLabelElementBuilder<Comparable>(() -> attribute.getReader().getModifierName(), () -> ModConfigs.MENU_PLAYER_STAT_DESCRIPTIONS.getModGearAttributeDescriptionFor(attribute.getRegistryName()), () -> (Comparable)valueSupplier.apply(player), valueFormatFunction, TextColor.m_131266_((int)0));
    }

    private GearAttributeStatLabel() {
    }
}

