/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.bounty.element.task;

import iskallia.vault.bounty.task.MiningTask;
import iskallia.vault.bounty.task.properties.MiningProperties;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.screen.bounty.element.task.AbstractTaskElement;
import iskallia.vault.util.TextUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class MiningTaskElement
extends AbstractTaskElement<MiningTask> {
    protected MiningTaskElement(ISpatial spatial, MiningTask task) {
        super(spatial, task);
    }

    @Override
    protected float getProgressPercentage() {
        return (float)(this.getAmountObtained() / this.getAmountRequired());
    }

    @Override
    protected double getAmountRequired() {
        return ((MiningProperties)((MiningTask)this.getTask()).getProperties()).getAmount();
    }

    @Override
    protected double getAmountObtained() {
        return ((MiningTask)this.getTask()).getAmountObtained();
    }

    @Override
    public List<MutableComponent> getDescription() {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        DecimalFormat df = new DecimalFormat("0");
        ResourceLocation itemId = ((MiningProperties)((MiningTask)this.getTask()).getProperties()).getBlockId();
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(itemId);
        TextComponent name = block == null ? TextUtil.formatLocationPathAsProperNoun(itemId) : block.m_49954_();
        components.add(new TextComponent("Mine ").m_7220_((Component)new TextComponent(df.format(((MiningProperties)((MiningTask)this.getTask()).getProperties()).getAmount()) + "x ")).m_7220_((Component)name).m_130946_(" in The Vault!"));
        return components;
    }

    @Override
    protected MutableComponent getTargetDisplayName() {
        ResourceLocation itemId = ((MiningProperties)((MiningTask)this.getTask()).getProperties()).getBlockId();
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(itemId);
        return block == null ? TextUtil.formatLocationPathAsProperNoun(itemId) : block.m_49954_();
    }

    @Override
    protected List<Component> getExtendedDisplay() {
        ResourceLocation itemId = ((MiningProperties)((MiningTask)this.getTask()).getProperties()).getBlockId();
        Block item = (Block)ForgeRegistries.BLOCKS.getValue(itemId);
        return new ItemStack((ItemLike)item).m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.ADVANCED);
    }
}

