/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.bounty.element;

import iskallia.vault.bounty.Bounty;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.screen.bounty.element.BountyTableContainerElement;
import iskallia.vault.client.gui.screen.bounty.element.HeaderElement;
import iskallia.vault.client.gui.screen.bounty.element.task.TaskScrollContainerElement;
import iskallia.vault.container.BountyContainer;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ServerboundAbandonBountyMessage;
import iskallia.vault.network.message.bounty.ServerboundActivateBountyMessage;
import iskallia.vault.network.message.bounty.ServerboundClaimRewardMessage;
import iskallia.vault.util.TextUtil;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.NotNull;

public class BountyElement
extends ContainerElement<BountyElement> {
    private final BountyTableContainerElement parent;
    private final BountyContainer container;
    private final HeaderElement headerElement;
    private Bounty bounty;
    private Status status = Status.NONE;
    private final TaskScrollContainerElement taskScrollContainerElement;
    private final NineSliceButtonElement<?> actionButton;

    public BountyElement(BountyTableContainerElement parent, ISpatial spatial, BountyContainer container) {
        super(spatial);
        this.parent = parent;
        this.container = container;
        this.headerElement = this.addElement(new HeaderElement(Spatials.positionXY(1, 0).width(this.getWorldSpatial().width() - 5).height(20), new TextComponent("Select a bounty!"), ScreenTextures.BOUNTY_UNIDENTIFIED, false));
        this.taskScrollContainerElement = this.addElement(new TaskScrollContainerElement(Spatials.positionXY(4, 20).width(this.width() - 10).height(this.height() - 53)));
        this.actionButton = this.addElement(new NineSliceButtonElement(Spatials.positionXY(4, this.taskScrollContainerElement.bottom() + 3).width(this.width() - 10).height(20), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::onActionClicked).setRenderButtonHeld(() -> this.status == Status.ACTIVE && !this.bounty.getTask().isComplete()).label((MutableComponent)this.getButtonLabel(), LabelTextStyle.center().shadow()));
        this.headerElement.enableSpatialDebugRender(false, true);
        this.taskScrollContainerElement.enableSpatialDebugRender(false, true);
        this.actionButton.enableSpatialDebugRender(false, true);
        if (!this.container.getActive().isEmpty()) {
            this.setBounty(((Bounty)this.container.getActive().get(0)).getId(), Status.ACTIVE);
        } else {
            this.actionButton.setDisabled(true);
        }
    }

    @NotNull
    private TextComponent getButtonLabel() {
        switch (this.status) {
            case ACTIVE: {
                if (this.bounty.getTask().isComplete()) {
                    return new TextComponent("Claim Reward");
                }
                return new TextComponent("Abandon");
            }
            case AVAILABLE: {
                return new TextComponent("Activate");
            }
        }
        return new TextComponent("");
    }

    private void onActionClicked() {
        switch (this.status) {
            case ACTIVE: {
                if (this.bounty.getTask().isComplete()) {
                    ModNetwork.CHANNEL.sendToServer((Object)new ServerboundClaimRewardMessage(this.bounty.getId()));
                    this.container.getActive().removeById(this.bounty.getId());
                    this.container.getComplete().add(this.bounty);
                    this.bounty.setExpiration(Instant.now().plus((long)ModConfigs.BOUNTY_CONFIG.getWaitingPeriodInHours(), ChronoUnit.HOURS).toEpochMilli());
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12275_, 0.7f, 1.0f);
                } else if (this.actionButton.getTimeHeld() > 60.0) {
                    this.status = Status.COMPLETE;
                    ModNetwork.CHANNEL.sendToServer((Object)new ServerboundAbandonBountyMessage(this.bounty.getId()));
                    this.container.getActive().removeById(this.bounty.getId());
                    this.container.getComplete().add(this.bounty);
                    this.bounty.setExpiration(Instant.now().plus((long)ModConfigs.BOUNTY_CONFIG.getAbandonedPenaltyInHours(), ChronoUnit.HOURS).toEpochMilli());
                }
                if (this.bounty != null) {
                    this.update(this.bounty);
                }
                this.parent.refreshBountySelection();
                break;
            }
            case AVAILABLE: {
                if (!this.container.getActive().isEmpty()) break;
                this.container.getActive().add(this.bounty);
                this.container.getAvailable().removeById(this.bounty.getId());
                this.status = Status.ACTIVE;
                ModNetwork.CHANNEL.sendToServer((Object)new ServerboundActivateBountyMessage(this.bounty.getId()));
                this.update(this.bounty);
                this.parent.refreshBountySelection();
                break;
            }
        }
    }

    public void setBounty(UUID bountyId, Status status) {
        Optional<Bounty> optionalBounty = this.container.getBountyById(bountyId);
        if (optionalBounty.isEmpty()) {
            return;
        }
        this.bounty = optionalBounty.get();
        this.status = status;
        this.update(this.bounty);
    }

    public void update(Bounty bounty) {
        MutableComponent bountyTitle = TextUtil.formatLocationPathAsProperNoun(bounty.getTask().getTaskType()).m_130948_(this.status.display.m_7383_());
        this.headerElement.setTitle(bountyTitle);
        this.headerElement.setIcon(bounty.getTask().getTaskType());
        this.headerElement.tooltip(Tooltips.single(() -> this.status.getDisplay()));
        this.taskScrollContainerElement.setTaskElement(bounty.getTask());
        this.actionButton.label((MutableComponent)this.getButtonLabel(), LabelTextStyle.center().shadow());
        this.actionButton.setDisabled(this.status == Status.COMPLETE || this.bounty == null);
        if (this.status == Status.COMPLETE) {
            this.replaceExpirationLabel();
        } else {
            if (this.status == Status.AVAILABLE && !this.container.getActive().isEmpty()) {
                this.actionButton.setDisabled(true);
            }
            this.removeExpirationLabel();
        }
        ScreenLayout.requestLayout();
    }

    private void replaceExpirationLabel() {
        this.removeExpirationLabel();
        ExpirationElement expirationElement = (ExpirationElement)((ExpirationElement)new ExpirationElement((IPosition)Spatials.positionXYZ(0, 0, 1), () -> this.bounty.getExpiration() - Instant.now().toEpochMilli(), LabelTextStyle.center().shadow(), !this.bounty.getTask().isComplete()).layout((screen, gui, parent, world) -> {
            world.size(this.actionButton.width(), this.actionButton.height());
            world.translateXYZ(4, this.height() - 19, 1);
        })).enableSpatialDebugRender(false, true);
        this.addElement(expirationElement);
    }

    private void removeExpirationLabel() {
        ExpirationElement element = null;
        for (IElement iElement : this.elementStore.getSpatialElementList()) {
            ExpirationElement expirationElement;
            if (!(iElement instanceof ExpirationElement)) continue;
            element = expirationElement = (ExpirationElement)iElement;
            break;
        }
        if (element != null) {
            this.removeElement(element);
        }
    }

    public Bounty getSelectedBounty() {
        return this.bounty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BountyElement that = (BountyElement)o;
        return this.bounty.getId().equals(that.bounty.getId());
    }

    public static enum Status {
        ACTIVE(new TextComponent("Active").m_130940_(ChatFormatting.GREEN)),
        AVAILABLE(new TextComponent("Available").m_130940_(ChatFormatting.WHITE)),
        COMPLETE(new TextComponent("Complete").m_130940_(ChatFormatting.AQUA)),
        NONE((MutableComponent)new TextComponent(""));

        private final MutableComponent display;

        private Status(MutableComponent display) {
            this.display = display;
        }

        public MutableComponent getDisplay() {
            return this.display;
        }

        public int getWidth() {
            return TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)this.getDisplay());
        }
    }

    public static class ExpirationElement
    extends DynamicLabelElement<Long, ExpirationElement> {
        private final boolean isAbandoned;

        public ExpirationElement(IPosition position, Supplier<Long> valueSupplier, LabelTextStyle.Builder labelTextStyle, boolean isAbandoned) {
            super(position, valueSupplier, labelTextStyle);
            this.isAbandoned = isAbandoned;
        }

        @Override
        protected void onValueChanged(Long value) {
            if (value < 0L) {
                return;
            }
            String timeRemaining = DurationFormatUtils.formatDuration((long)value, (String)"HH:mm:ss");
            String labelText = this.isAbandoned ? "Abandon Penalty: " : "New Bounty in: ";
            this.set((Component)new TextComponent(labelText + timeRemaining).m_130940_(ChatFormatting.WHITE));
        }
    }
}

