/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.ClientDiscoveredEntriesData;
import iskallia.vault.client.ClientVaultForgeData;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.CraftingSelectorElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.OutputSlotElement;
import iskallia.vault.client.gui.framework.element.ProficiencyDisplayElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.container.VaultForgeContainer;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.gear.crafting.VaultForgeHelper;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultForgeRequestCraftMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class VaultForgeScreen
extends AbstractElementContainerScreen<VaultForgeContainer> {
    private final ButtonElement<?> craftButton;
    private final Inventory playerInventory;
    private VaultForgeRecipe selectedRecipe = null;

    public VaultForgeScreen(VaultForgeContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.playerInventory = inventory;
        int width = 176;
        this.setGuiSize(Spatials.size(width, 206));
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)((VaultForgeContainer)this.m_6262_()).getTileEntity().m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 113), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        NonNullList normalSlots = ((VaultForgeContainer)this.m_6262_()).f_38839_;
        this.addElement((SlotsElement)new SlotsElement(Spatials.zero(), normalSlots.subList(0, normalSlots.size() - 1), ScreenTextures.INSET_ITEM_SLOT_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.addElement((OutputSlotElement)new OutputSlotElement(Spatials.zero(), (Slot)Iterables.getLast((Iterable)normalSlots), ScreenTextures.INSET_CRAFTING_RESULT_SLOT_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.addElement((CraftingSelectorElement)new CraftingSelectorElement(Spatials.positionXY(47, 55).height(54), 3, ClientVaultForgeData.getRecipes(), ClientDiscoveredEntriesData.Trinkets.getObserverTrinkets(), this::onRecipeSelect, this::getMissingRecipeInputs).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.craftButton = (ButtonElement)new ButtonElement(Spatials.positionXY(122, 73), ScreenTextures.BUTTON_CRAFT_TEXTURES, this::onCraftClick).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement(this.craftButton);
        this.craftButton.setDisabled(true);
        int xPadding = 8;
        int availableWidth = width - xPadding * 2;
        int elementWidth = ScreenTextures.PROFICIENCY_DISPLAY_FRAME.width() + 2;
        List<ProficiencyType> displayTypes = ProficiencyType.getCraftableTypes();
        int remainingWidth = availableWidth - displayTypes.size() * elementWidth;
        int spacing = Math.round((float)remainingWidth / (float)displayTypes.size());
        for (int i = 0; i < displayTypes.size(); ++i) {
            ProficiencyType type = displayTypes.get(i);
            int xOffset = i * spacing + i * elementWidth;
            this.addElement((ProficiencyDisplayElement)new ProficiencyDisplayElement(Spatials.zero(), type).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui).translateXY(xPadding + xOffset, 18)));
        }
    }

    private List<ItemStack> getMissingRecipeInputs(List<ItemStack> inputs) {
        return VaultForgeHelper.getMissingInputs(inputs, this.playerInventory, ((VaultForgeContainer)this.f_97732_).getTileEntity());
    }

    private void onCraftClick() {
        if (this.selectedRecipe != null) {
            ModNetwork.CHANNEL.sendToServer((Object)new VaultForgeRequestCraftMessage(this.selectedRecipe.getId()));
        }
    }

    private void onRecipeSelect(VaultForgeRecipe recipe) {
        this.craftButton.setDisabled(false);
        this.selectedRecipe = recipe;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

