/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.block;

import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.ScrollableItemStackSelectorElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.container.SpiritExtractorContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SpiritExtractorScreen
extends AbstractElementContainerScreen<SpiritExtractorContainer> {
    public SpiritExtractorScreen(SpiritExtractorContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(176, 182));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(0, -10).size(0, 10), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui).add(Spatials.size(0, 10)))));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(7, -4), (Component)new TextComponent("Spirit Extractor").m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((ScrollableItemStackSelectorElement)new ScrollableItemStackSelectorElement((ISpatial)Spatials.positionXY(7, 6).height(54), 8, new ScrollableItemStackSelectorElement.SelectorModel<ScrollableItemStackSelectorElement.ItemSelectorEntry>(){

            @Override
            public List<ScrollableItemStackSelectorElement.ItemSelectorEntry> getEntries() {
                return ((SpiritExtractorContainer)SpiritExtractorScreen.this.m_6262_()).getStoredItems().stream().map(ItemSelectorWithTooltipEntry::new).collect(Collectors.toList());
            }
        }).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, ((SpiritExtractorContainer)this.m_6262_()).m_38853_((int)0).f_40221_ - 12), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        ButtonElement purchaseButton = (ButtonElement)new ButtonElement(Spatials.positionXY(53, 69), ScreenTextures.BUTTON_PAY_TEXTURES, () -> ((SpiritExtractorContainer)this.m_6262_()).startSpewingItems()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        purchaseButton.setDisabled(() -> !((SpiritExtractorContainer)this.m_6262_()).coinsCoverTotalCost() || ((SpiritExtractorContainer)this.m_6262_()).isSpewingItems());
        purchaseButton.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            tooltipRenderer.renderComponentTooltip(poseStack, this.getPurchaseButtonTooltipLines(), mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        });
        this.addElement(purchaseButton);
    }

    @NotNull
    private List<Component> getPurchaseButtonTooltipLines() {
        ArrayList<Component> purchaseButtonTooltips = new ArrayList<Component>();
        purchaseButtonTooltips.add((Component)new TextComponent("Cost for recovering items"));
        int paymentStackCount = ((SpiritExtractorContainer)this.m_6262_()).m_38853_(36).m_7993_().m_41613_();
        ItemStack totalCost = ((SpiritExtractorContainer)this.m_6262_()).getTotalCost();
        ChatFormatting textColor = paymentStackCount < totalCost.m_41613_() ? ChatFormatting.RED : ChatFormatting.YELLOW;
        String percentString = (int)((float)paymentStackCount / (float)totalCost.m_41613_() * 100.0f) + "%";
        purchaseButtonTooltips.add((Component)new TextComponent(percentString + " " + totalCost.m_41720_().m_7626_(totalCost).getString() + " (of " + totalCost.m_41613_() + ")").m_130940_(textColor));
        purchaseButtonTooltips.add((Component)new TextComponent(this.getSpiritRecoveryCountText()).m_130940_(ChatFormatting.GRAY));
        return purchaseButtonTooltips;
    }

    private String getSpiritRecoveryCountText() {
        int spiritRecoveryCount = ((SpiritExtractorContainer)this.m_6262_()).getSpiritRecoveryCount();
        return spiritRecoveryCount <= 0 ? "No Spirits recovered yet" : "Number of Spirits recovered: " + spiritRecoveryCount;
    }

    private static class ItemSelectorWithTooltipEntry
    extends ScrollableItemStackSelectorElement.ItemSelectorEntry {
        public ItemSelectorWithTooltipEntry(ItemStack displayStack) {
            super(displayStack, false);
        }

        @Override
        public void adjustSlot(FakeItemSlotElement<?> slot) {
            slot.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                if (!this.getDisplayStack().m_41619_()) {
                    tooltipRenderer.renderTooltip(poseStack, this.getDisplayStack(), mouseX, mouseY, TooltipDirection.RIGHT);
                }
                return true;
            });
            slot.setLabelStackCount();
        }
    }
}

