/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.ClientShardTradeData;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.DynamicLabelElement;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.ItemStackDisplayElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.container.inventory.ShardTradeContainer;
import iskallia.vault.event.InputEvents;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.ItemShardPouch;
import iskallia.vault.network.message.ShardTradeTradeMessage;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ShardTradeScreen
extends AbstractElementContainerScreen<ShardTradeContainer> {
    private final LabelElement<?> labelRandomTrade;
    private final LabelElement<?>[] labelShopTrades = new LabelElement[3];

    public ShardTradeScreen(ShardTradeContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(176, 184));
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)new TextComponent("Black Market").m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 90), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXY(13, 28), ScreenTextures.SOUL_SHARD_TRADE_ORNAMENT).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((FakeItemSlotElement)new FakeItemSlotElement(Spatials.positionXY(29, 44), () -> new ItemStack((ItemLike)ModItems.UNKNOWN_ITEM), () -> !this.canBuyRandomTrade()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).whenClicked(this::buyRandomTrade).tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
            tooltipRenderer.renderTooltip(poseStack, new ItemStack((ItemLike)ModItems.UNKNOWN_ITEM), mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        });
        this.addElement((ItemStackDisplayElement)new ItemStackDisplayElement(Spatials.positionXY(29, 64), new ItemStack((ItemLike)ModItems.SOUL_SHARD)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.labelRandomTrade = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(37, 74, 200), TextComponent.f_131282_, LabelTextStyle.border8().center()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXYZ(gui)));
        this.addElement((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXY(74, 6), ScreenTextures.BLACK_MARKET_ORNAMENT).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        for (int i = 0; i < 3; ++i) {
            int tradeIndex = i;
            int yOffsetTrade = 10 + i * 28;
            this.addElement(((ButtonElement)new ButtonElement(Spatials.positionXY(78, yOffsetTrade), ScreenTextures.BUTTON_TRADE_WIDE_TEXTURES, () -> {}).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).setDisabled(() -> !this.canBuyTrade(tradeIndex))).setEnabled(false);
            int yOffset = 14 + i * 28;
            this.addElement((FakeItemSlotElement)new FakeItemSlotElement(Spatials.positionXY(141, yOffset), () -> {
                Tuple<ItemStack, Integer> trade = ClientShardTradeData.getTradeInfo(tradeIndex);
                return trade == null ? ItemStack.f_41583_ : ((ItemStack)trade.m_14418_()).m_41777_();
            }, () -> !this.canBuyTrade(tradeIndex)).setLabelStackCount().layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).whenClicked(() -> this.buyTrade(tradeIndex)).tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                Tuple<ItemStack, Integer> trade = ClientShardTradeData.getTradeInfo(tradeIndex);
                if (trade != null && !((ItemStack)trade.m_14418_()).m_41619_()) {
                    tooltipRenderer.renderTooltip(poseStack, (ItemStack)trade.m_14418_(), mouseX, mouseY, TooltipDirection.RIGHT);
                }
                return true;
            });
            this.addElement((ItemStackDisplayElement)new ItemStackDisplayElement(Spatials.positionXY(89, yOffset), new ItemStack((ItemLike)ModItems.SOUL_SHARD)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
            this.labelShopTrades[i] = this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(97, yOffset + 10, 200), TextComponent.f_131282_, LabelTextStyle.border8().center()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXYZ(gui)));
        }
        LocalDateTime endTime = ClientShardTradeData.getNextReset();
        LocalDateTime nowTime = LocalDateTime.now(ZoneId.of("UTC")).withNano(0);
        LocalTime diff = LocalTime.MIN.plusSeconds(ChronoUnit.SECONDS.between(nowTime, endTime));
        TextComponent component = new TextComponent(diff.format(DateTimeFormatter.ISO_LOCAL_TIME));
        IMutableSpatial iMutableSpatial = Spatials.positionXYZ(this.getGuiSpatial().width() / 2 - TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)component) / 2 - 1, -10, 200);
        int n = TextBorder.DEFAULT_FONT.get().m_92852_((FormattedText)component);
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        this.addElement((CountDownElement)new CountDownElement((IPosition)iMutableSpatial, (ISize)Spatials.size(n, 9), () -> ShardTradeScreen.lambda$new$22((Component)component), LabelTextStyle.shadow()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui.x(), gui.y())));
        this.addElement((TextureAtlasElement)((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXY(this.getGuiSpatial().width() / 2 - ScreenTextures.TAB_COUNTDOWN_BACKGROUND.width() / 2, -ScreenTextures.TAB_COUNTDOWN_BACKGROUND.height()), ScreenTextures.TAB_COUNTDOWN_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui))).tooltip(Tooltips.multi(() -> List.of(new TextComponent("Shop resets in")))));
        this.updateTradeLabels();
    }

    protected void m_181908_() {
        super.m_181908_();
        this.updateTradeLabels();
    }

    private void updateTradeLabels() {
        int playerShards = ItemShardPouch.getShardCount((Player)Minecraft.m_91087_().f_91074_);
        int randomCost = ClientShardTradeData.getRandomTradeCost();
        LocalDateTime nextReset = ClientShardTradeData.getNextReset();
        LocalDateTime now = LocalDateTime.now(ZoneId.of("UTC")).withNano(0);
        LocalTime diff = LocalTime.MIN.plusSeconds(ChronoUnit.SECONDS.between(now, nextReset));
        TextComponent component = new TextComponent(diff.format(DateTimeFormatter.ISO_LOCAL_TIME));
        int randomCostColor = playerShards >= randomCost ? 0xFFFFFF : 0x7E0000;
        MutableComponent randomCostComponent = new TextComponent(String.valueOf(randomCost)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)randomCostColor)));
        this.labelRandomTrade.set((Component)randomCostComponent);
        for (int i = 0; i < 3; ++i) {
            Tuple<ItemStack, Integer> tradeInfo = ClientShardTradeData.getTradeInfo(i);
            if (tradeInfo == null) {
                this.labelShopTrades[i].set(TextComponent.f_131282_);
                continue;
            }
            int tradeCost = (Integer)tradeInfo.m_14419_();
            int tradeCostColor = playerShards >= tradeCost ? 0xFFFFFF : 0x7E0000;
            MutableComponent tradeCostComponent = new TextComponent(String.valueOf(tradeCost)).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)tradeCostColor)));
            this.labelShopTrades[i].set((Component)tradeCostComponent);
        }
    }

    private boolean canBuyRandomTrade() {
        return ItemShardPouch.getShardCount((Player)Minecraft.m_91087_().f_91074_) >= ClientShardTradeData.getRandomTradeCost();
    }

    private boolean canBuyTrade(int tradeIndex) {
        Tuple<ItemStack, Integer> tradeInfo = ClientShardTradeData.getTradeInfo(tradeIndex);
        if (tradeInfo == null) {
            return false;
        }
        return ItemShardPouch.getShardCount((Player)Minecraft.m_91087_().f_91074_) >= (Integer)tradeInfo.m_14419_();
    }

    private void buyRandomTrade() {
        if (!this.canBuyRandomTrade()) {
            return;
        }
        ModNetwork.CHANNEL.sendToServer((Object)new ShardTradeTradeMessage(-1, InputEvents.isShiftDown(), Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_142081_() : null));
    }

    private void buyTrade(int tradeIndex) {
        if (!this.canBuyTrade(tradeIndex)) {
            return;
        }
        ModNetwork.CHANNEL.sendToServer((Object)new ShardTradeTradeMessage(tradeIndex, InputEvents.isShiftDown(), Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_142081_() : null));
    }

    private static /* synthetic */ Component lambda$new$22(Component component) {
        return component;
    }

    private static final class CountDownElement
    extends DynamicLabelElement<Component, CountDownElement> {
        private CountDownElement(IPosition position, ISize size, Supplier<Component> valueSupplier, LabelTextStyle.Builder labelTextStyle) {
            super(position, size, valueSupplier, labelTextStyle);
        }

        @Override
        protected void onValueChanged(Component value) {
            this.set(value);
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            LocalDateTime endTime = ClientShardTradeData.getNextReset();
            LocalDateTime nowTime = LocalDateTime.now(ZoneId.of("UTC")).withNano(0);
            LocalTime diff = LocalTime.MIN.plusSeconds(ChronoUnit.SECONDS.between(nowTime, endTime));
            TextComponent component = new TextComponent(diff.format(DateTimeFormatter.ISO_LOCAL_TIME));
            this.onValueChanged((Component)component);
        }
    }
}

