/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.helper.ConfettiParticles;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.widget.RaffleEntry;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.RaffleServerMessage;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class RaffleScreen
extends Screen {
    public static final ResourceLocation UI_RESOURCE = new ResourceLocation("the_vault", "textures/gui/raffle.png");
    public static final int containerWidth = 62;
    public static final int containerHeight = 20;
    protected ConfettiParticles leftConfettiPopper = new ConfettiParticles().angleRange(290.0f, 355.0f).quantityRange(60, 80).delayRange(0, 10).lifespanRange(20, 100).sizeRange(2, 5).speedRange(2.0f, 10.0f);
    protected ConfettiParticles rightConfettiPopper = new ConfettiParticles().angleRange(200.0f, 265.0f).quantityRange(60, 80).delayRange(0, 10).lifespanRange(20, 100).sizeRange(2, 5).speedRange(2.0f, 10.0f);
    protected boolean popped;
    protected boolean spinning;
    protected List<String> occupants;
    protected String winner;
    protected List<RaffleEntry> raffleWidgets = new LinkedList<RaffleEntry>();
    protected Button raffleButton;
    protected int spinTicks;
    protected int distance;
    protected double elapsedTicks;
    private double C;

    public RaffleScreen(List<String> occupants, String winner) {
        super((Component)new TextComponent("Raffle Screen"));
        this.occupants = new LinkedList<String>();
        this.occupants.addAll(occupants);
        Collections.shuffle(occupants);
        this.winner = winner;
        int winnerIndex = occupants.indexOf(winner);
        this.spinTicks = 200;
        int freeSpinCount = 5;
        this.distance = freeSpinCount * (occupants.size() * 20 + (occupants.size() - 1) + 1) + (winnerIndex - 2) * 21;
        for (int i = 0; i < this.occupants.size(); ++i) {
            RaffleEntry entry = new RaffleEntry(occupants.get(i), i % 5);
            entry.setBounds(new Rectangle(0, i * 21, 62, 20));
            this.raffleWidgets.add(entry);
        }
        this.C = 0.5 * (double)this.spinTicks * (double)this.spinTicks;
    }

    protected void m_7856_() {
        super.m_7856_();
        int midX = this.f_96543_ / 2;
        int midY = this.f_96544_ / 2;
        this.raffleButton = new Button(midX - 50, midY + 40, 100, 20, (Component)new TextComponent("Raffle!"), this::onRaffleButtonClick);
    }

    public Rectangle getViewportBounds() {
        int midX = this.f_96543_ / 2;
        int midY = this.f_96544_ / 2;
        return new Rectangle(midX - 32, midY - 60, 62, 90);
    }

    public double calculateYOffset(double tick) {
        return (-(tick * tick * tick) / 6.0 + this.C * tick) * (double)this.distance / ((double)(-(this.spinTicks * this.spinTicks * this.spinTicks)) / 6.0 + this.C * (double)this.spinTicks);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.raffleButton.m_94757_(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.raffleButton.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.raffleButton.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.raffleButton.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void onRaffleButtonClick(Button button) {
        this.spinning = true;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96558_(matrixStack, 0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)UI_RESOURCE);
        int midX = this.f_96543_ / 2;
        int midY = this.f_96544_ / 2;
        int crystalWidth = 114;
        int crystalHeight = 130;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)midX, (double)midY, 0.0);
        matrixStack.m_85841_(1.5f, 1.5f, 1.5f);
        this.m_93228_(matrixStack, -crystalWidth / 2, -crystalHeight / 2, 0, 0, crystalWidth, crystalHeight);
        matrixStack.m_85849_();
        UIHelper.renderOverflowHidden(matrixStack, this::renderWheelBackground, this::renderWheel);
        Rectangle viewportBounds = this.getViewportBounds();
        RenderSystem.m_69478_();
        UIHelper.renderContainerBorder((GuiComponent)this, matrixStack, viewportBounds, 115, 0, 7, 7, 7, 7, 0);
        int indicatorWidth = 17;
        int indicatorHeight = 15;
        this.m_93228_(matrixStack, midX - 42, (int)((float)viewportBounds.y + (float)viewportBounds.height / 2.0f - (float)(indicatorHeight / 2)), 115, 18, indicatorWidth, indicatorHeight);
        this.raffleButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        boolean bl = this.raffleButton.f_93623_ = !this.spinning && !this.popped;
        if (this.popped) {
            String winnerText = String.format("Winner is %s!", this.winner);
            int textWidth = this.f_96547_.m_92895_(winnerText);
            this.f_96547_.m_92750_(matrixStack, winnerText, (float)midX - (float)textWidth / 2.0f, (float)midY + (float)crystalHeight / 2.0f + 33.0f, -4855553);
        }
        this.leftConfettiPopper.spawnedPosition(10, midY);
        this.rightConfettiPopper.spawnedPosition(this.f_96543_ - 10, midY);
        this.leftConfettiPopper.tick();
        this.rightConfettiPopper.tick();
        this.leftConfettiPopper.render(matrixStack);
        this.rightConfettiPopper.render(matrixStack);
        if (this.spinning) {
            this.elapsedTicks += (double)partialTicks;
        }
    }

    protected void renderWheelBackground(PoseStack matrixStack) {
        Rectangle viewportBounds = this.getViewportBounds();
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)viewportBounds.x, (int)viewportBounds.y, (int)(viewportBounds.x + viewportBounds.width), (int)(viewportBounds.y + viewportBounds.height), (int)-13223617);
    }

    protected void renderWheel(PoseStack matrixStack) {
        Rectangle bounds = this.getViewportBounds();
        double yOffset = this.calculateYOffset(this.elapsedTicks);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)bounds.x, (double)bounds.y, 0.0);
        matrixStack.m_85837_(0.0, -yOffset, 0.0);
        for (RaffleEntry raffleWidget : this.raffleWidgets) {
            Rectangle entryBounds = raffleWidget.getBounds();
            RenderSystem.m_157456_((int)0, (ResourceLocation)UI_RESOURCE);
            this.m_93228_(matrixStack, entryBounds.x, entryBounds.y, 190, 3 + raffleWidget.getTypeIndex() * 20, 62, 20);
            boolean isTargeted = entryBounds.contains(entryBounds.x + 2, (int)((double)((float)bounds.y + (float)bounds.height / 2.0f) + yOffset));
            matrixStack.m_85836_();
            int stringWidth = this.f_96547_.m_92895_(raffleWidget.getOccupantName());
            float widthRatio = (float)stringWidth / 62.0f;
            matrixStack.m_85837_((double)(entryBounds.x + 1), (double)(entryBounds.y + 1), 0.0);
            matrixStack.m_85837_(entryBounds.getWidth() / 2.0, entryBounds.getHeight() / 2.0, 0.0);
            if ((double)widthRatio > 0.9) {
                matrixStack.m_85841_(0.9f / widthRatio, 0.9f / widthRatio, 1.0f);
            }
            matrixStack.m_85837_((double)((float)(-stringWidth) / 2.0f), -5.0, 0.0);
            if (isTargeted) {
                this.f_96547_.m_92750_(matrixStack, raffleWidget.getOccupantName(), 0.0f, 0.0f, -65536);
            } else {
                this.f_96547_.m_92883_(matrixStack, raffleWidget.getOccupantName(), 0.0f, 0.0f, -13223617);
            }
            RenderSystem.m_69482_();
            matrixStack.m_85849_();
            if (!((double)(entryBounds.y + entryBounds.height) - yOffset < 0.0)) continue;
            this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)ModSounds.RAFFLE_SFX, (float)1.2f, (float)1.0f));
            entryBounds.y += this.raffleWidgets.size() * 21;
        }
        matrixStack.m_85849_();
        if (this.elapsedTicks >= (double)this.spinTicks) {
            this.spinning = false;
            if (!this.popped) {
                ModNetwork.CHANNEL.sendToServer((Object)RaffleServerMessage.animationDone(this.winner));
                this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)ModSounds.CONFETTI_SFX, (float)1.0f));
                this.leftConfettiPopper.pop();
                this.rightConfettiPopper.pop();
                this.popped = true;
            }
        }
    }
}

